/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.email.service.jms;

import java.util.HashMap;
import javax.annotation.Resource;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.email.domain.EmailTarget;
import org.broadleafcommerce.email.service.exception.EmailException;
import org.broadleafcommerce.email.service.info.EmailInfo;
import org.broadleafcommerce.email.service.message.EmailPropertyType;
import org.broadleafcommerce.email.service.message.MessageCreator;
import org.springframework.mail.MailAuthenticationException;
import org.springframework.mail.MailParseException;
import org.springframework.mail.MailPreparationException;
import org.springframework.mail.MailSendException;

public class EmailServiceMDP
implements MessageListener {
    private static final Log LOG = LogFactory.getLog(EmailServiceMDP.class);
    @Resource(name="blMessageCreator")
    private MessageCreator messageCreator;

    public void onMessage(Message message) {
        try {
            HashMap props = (HashMap)((ObjectMessage)message).getObject();
            if (LOG.isDebugEnabled()) {
                EmailTarget emailUser = (EmailTarget)props.get(EmailPropertyType.USER.getType());
                EmailInfo info = (EmailInfo)props.get(EmailPropertyType.INFO.getType());
                LOG.debug((Object)("Attempt email send type=" + info.getEmailType() + " to=" + emailUser.getEmailAddress() + " from=" + info.getFromAddress() + " subject=" + info.getSubject()));
            }
            this.messageCreator.sendMessage(props);
        }
        catch (MailAuthenticationException e) {
            throw new EmailException(e);
        }
        catch (MailPreparationException e) {
            throw new EmailException(e);
        }
        catch (MailParseException e) {
            throw new EmailException(e);
        }
        catch (MailSendException e) {
            throw new EmailException(e);
        }
        catch (JMSException e) {
            throw new EmailException(e);
        }
    }
}

