/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.config.RuntimeEnvironmentKeyResolver;
import org.broadleafcommerce.config.SystemPropertyRuntimeEnvironmentKeyResolver;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.core.io.Resource;

public class RuntimeEnvironmentPropertiesConfigurer
extends PropertyPlaceholderConfigurer
implements InitializingBean {
    private static final Log LOG = LogFactory.getLog(RuntimeEnvironmentPropertiesConfigurer.class);
    protected String defaultEnvironment;
    protected RuntimeEnvironmentKeyResolver keyResolver;
    protected Set<String> environments = Collections.emptySet();
    protected Set<Resource> propertyLocations;

    public void afterPropertiesSet() throws IOException {
        if (!this.environments.contains(this.defaultEnvironment)) {
            throw new AssertionError((Object)("Default environment '" + this.defaultEnvironment + "' not listed in environment list"));
        }
        if (this.keyResolver == null) {
            this.keyResolver = new SystemPropertyRuntimeEnvironmentKeyResolver();
        }
        String environment = this.determineEnvironment();
        Resource[] propertiesLocation = this.createPropertiesResource(environment);
        Resource[] commonLocation = this.createCommonResource();
        ArrayList<Resource> allLocations = new ArrayList<Resource>();
        for (Resource resource : propertiesLocation) {
            if (!resource.exists()) continue;
            allLocations.add(resource);
        }
        for (Resource resource : commonLocation) {
            if (!resource.exists()) continue;
            allLocations.add(resource);
        }
        this.setLocations(allLocations.toArray(new Resource[0]));
        this.validateProperties();
    }

    protected boolean compareProperties(Properties props1, Properties props2) throws IOException {
        Set<Object> outerKeys = props1.keySet();
        boolean missingKeys = false;
        for (Object keyObj : outerKeys) {
            String key = (String)keyObj;
            if (props2.containsKey(key)) continue;
            missingKeys = true;
            LOG.error((Object)("Property file mismatch: " + key + " missing"));
        }
        return missingKeys;
    }

    protected Resource[] createPropertiesResource(String environment) throws IOException {
        String fileName = environment.toString().toLowerCase() + ".properties";
        Resource[] resources = new Resource[this.propertyLocations.size()];
        int index = 0;
        for (Resource resource : this.propertyLocations) {
            resources[index] = resource.createRelative(fileName);
            ++index;
        }
        return resources;
    }

    protected Resource[] createCommonResource() throws IOException {
        Resource[] resources = new Resource[this.propertyLocations.size()];
        int index = 0;
        for (Resource resource : this.propertyLocations) {
            resources[index] = resource.createRelative("common.properties");
            ++index;
        }
        return resources;
    }

    protected String determineEnvironment() {
        String environment = this.keyResolver.resolveRuntimeEnvironmentKey();
        if (environment == null) {
            LOG.warn((Object)("Unable to determine runtime environment, using default environment '" + this.defaultEnvironment + "'"));
            return this.defaultEnvironment;
        }
        return environment.toLowerCase();
    }

    protected void validateProperties() throws IOException {
        boolean missingKeys = false;
        for (String envOuter : this.environments) {
            for (String envInner : this.environments) {
                if (envOuter.equals(envInner)) continue;
                Properties resource1 = this.mergeProperties(this.createPropertiesResource(envOuter));
                Properties resource2 = this.mergeProperties(this.createPropertiesResource(envInner));
                missingKeys |= this.compareProperties(resource1, resource2);
            }
        }
        if (missingKeys) {
            throw new AssertionError((Object)"Missing runtime properties keys (log entries above have details)");
        }
    }

    protected Properties mergeProperties(Resource[] locations) throws IOException {
        Properties props = new Properties();
        for (Resource resource : locations) {
            if (resource.exists()) {
                props = new Properties(props);
                props.load(resource.getInputStream());
                continue;
            }
            LOG.warn((Object)("Unable to locate resource: " + resource.getFilename()));
        }
        return props;
    }

    public void setDefaultEnvironment(String defaultEnvironment) {
        this.defaultEnvironment = defaultEnvironment;
    }

    public void setKeyResolver(RuntimeEnvironmentKeyResolver keyResolver) {
        this.keyResolver = keyResolver;
    }

    public void setEnvironments(Set<String> environments) {
        this.environments = environments;
    }

    public void setPropertyLocations(Set<Resource> propertyLocations) {
        this.propertyLocations = propertyLocations;
    }
}

