/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.web.core.security;

import java.io.IOException;
import javax.annotation.Resource;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.service.CustomerService;
import org.broadleafcommerce.profile.web.core.CustomerState;
import org.broadleafcommerce.profile.web.core.security.CustomerStateRequestProcessor;
import org.springframework.core.Ordered;
import org.springframework.web.filter.GenericFilterBean;

public class RestApiCustomerStateFilter
extends GenericFilterBean
implements Ordered {
    protected static final Log LOG = LogFactory.getLog(RestApiCustomerStateFilter.class);
    @Resource(name="blCustomerService")
    protected CustomerService customerService;
    protected String customerIdAttributeName = "customerId";

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        String customerId = null;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        if (request.getAttribute(CustomerStateRequestProcessor.getCustomerRequestAttributeName()) == null) {
            if (request.getAttribute(this.customerIdAttributeName) != null) {
                customerId = String.valueOf(request.getAttribute(this.customerIdAttributeName));
            }
            if (customerId == null) {
                customerId = servletRequest.getParameter(this.customerIdAttributeName);
            }
            if (customerId == null) {
                customerId = request.getHeader(this.customerIdAttributeName);
            }
            if (customerId != null && customerId.trim().length() > 0) {
                if (NumberUtils.isNumber((String)customerId)) {
                    Customer customer = this.customerService.readCustomerById(Long.valueOf(customerId));
                    if (customer != null) {
                        CustomerState.setCustomer(customer);
                    }
                } else {
                    LOG.warn((Object)String.format("The customer id passed in '%s' was not a number", customerId));
                }
            }
            if (customerId == null && LOG.isDebugEnabled()) {
                LOG.debug((Object)("No customer ID was found for the API request. In order to look up a customer for the request send a request parameter or request header for the '" + this.customerIdAttributeName + "' attribute"));
            }
        }
        filterChain.doFilter((ServletRequest)request, servletResponse);
    }

    public int getOrder() {
        return 2000;
    }

    public String getCustomerIdAttributeName() {
        return this.customerIdAttributeName;
    }

    public void setCustomerIdAttributeName(String customerIdAttributeName) {
        if (customerIdAttributeName == null || customerIdAttributeName.trim().length() < 1) {
            throw new IllegalArgumentException("customerIdAttributeName cannot be null");
        }
        this.customerIdAttributeName = customerIdAttributeName;
    }
}

