/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.web.controller.validator;

import javax.annotation.Resource;
import org.apache.commons.validator.GenericValidator;
import org.broadleafcommerce.common.util.BLCSystemProperty;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.service.CustomerService;
import org.broadleafcommerce.profile.web.core.form.RegisterCustomerForm;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;

@Component(value="blRegisterCustomerValidator")
public class RegisterCustomerValidator
implements Validator {
    private String validatePasswordExpression = "[0-9A-Za-z]{4,15}";
    @Resource(name="blCustomerService")
    private CustomerService customerService;

    public boolean supports(Class clazz) {
        return clazz.equals(RegisterCustomerForm.class);
    }

    public void validate(Object obj, Errors errors) {
        this.validate(obj, errors, false);
    }

    public void validate(Object obj, Errors errors, boolean useEmailForUsername) {
        RegisterCustomerForm form = (RegisterCustomerForm)obj;
        Customer customerFromDb = this.customerService.readCustomerByUsername(form.getCustomer().getUsername());
        if (customerFromDb != null && customerFromDb.isRegistered()) {
            if (useEmailForUsername) {
                errors.rejectValue("customer.emailAddress", "emailAddress.used", null, null);
            } else {
                errors.rejectValue("customer.username", "username.used", null, null);
            }
        }
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"password", (String)"password.required");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"passwordConfirm", (String)"passwordConfirm.required");
        errors.pushNestedPath("customer");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"firstName", (String)"firstName.required");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"lastName", (String)"lastName.required");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"emailAddress", (String)"emailAddress.required");
        errors.popNestedPath();
        if (!errors.hasErrors()) {
            if (!form.getPassword().matches(this.getValidatePasswordExpression())) {
                errors.rejectValue("password", "password.invalid", null, null);
            }
            if (!form.getPassword().equals(form.getPasswordConfirm())) {
                errors.rejectValue("password", "passwordConfirm.invalid", null, null);
            }
            if (!GenericValidator.isEmail((String)form.getCustomer().getEmailAddress())) {
                errors.rejectValue("customer.emailAddress", "emailAddress.invalid", null, null);
            }
        }
    }

    public String getValidatePasswordExpression() {
        return BLCSystemProperty.resolveSystemProperty((String)"validate.password", (String)this.validatePasswordExpression);
    }

    public void setValidatePasswordExpression(String validatePasswordExpression) {
        this.validatePasswordExpression = validatePasswordExpression;
    }
}

