/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.web.core.security;

import java.util.HashMap;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.web.AbstractBroadleafWebRequestProcessor;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.service.CustomerService;
import org.broadleafcommerce.profile.web.core.security.CustomerAuthenticatedFromCookieEvent;
import org.broadleafcommerce.profile.web.core.security.CustomerLoggedInEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.RememberMeAuthenticationToken;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.WebRequest;

@Component(value="blCustomerStateRequestProcessor")
public class CustomerStateRequestProcessor
extends AbstractBroadleafWebRequestProcessor
implements ApplicationEventPublisherAware {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    public static final String BLC_RULE_MAP_PARAM = "blRuleMap";
    @Resource(name="blCustomerService")
    protected CustomerService customerService;
    private ApplicationEventPublisher eventPublisher;
    protected static String customerRequestAttributeName = "customer";
    public static final String ANONYMOUS_CUSTOMER_SESSION_ATTRIBUTE_NAME = "_blc_anonymousCustomer";
    private static final String LAST_PUBLISHED_EVENT_SESSION_ATTRIBUTED_NAME = "_blc_lastPublishedEvent";

    public void process(WebRequest request) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        Customer customer = null;
        if (authentication != null && !(authentication instanceof AnonymousAuthenticationToken)) {
            String userName = authentication.getName();
            customer = (Customer)request.getAttribute(customerRequestAttributeName, 0);
            if (!(userName == null || customer != null && userName.equals(customer.getUsername()))) {
                customer = this.customerService.readCustomerByUsername(userName);
                if (this.logger.isDebugEnabled() && customer != null) {
                    this.logger.debug((Object)("Customer found by username " + userName));
                }
            }
            if (customer != null) {
                ApplicationEvent lastPublishedEvent = (ApplicationEvent)request.getAttribute(LAST_PUBLISHED_EVENT_SESSION_ATTRIBUTED_NAME, 0);
                if (authentication instanceof RememberMeAuthenticationToken) {
                    CustomerAuthenticatedFromCookieEvent cookieEvent;
                    customer.setCookied(true);
                    boolean publishRememberMeEvent = true;
                    if (lastPublishedEvent != null && lastPublishedEvent instanceof CustomerAuthenticatedFromCookieEvent && userName.equals((cookieEvent = (CustomerAuthenticatedFromCookieEvent)lastPublishedEvent).getCustomer().getUsername())) {
                        publishRememberMeEvent = false;
                    }
                    if (publishRememberMeEvent) {
                        cookieEvent = new CustomerAuthenticatedFromCookieEvent(customer, ((Object)((Object)this)).getClass().getName());
                        this.eventPublisher.publishEvent((ApplicationEvent)cookieEvent);
                        request.setAttribute(LAST_PUBLISHED_EVENT_SESSION_ATTRIBUTED_NAME, (Object)cookieEvent, 0);
                    }
                } else if (authentication instanceof UsernamePasswordAuthenticationToken) {
                    CustomerLoggedInEvent loggedInEvent;
                    customer.setLoggedIn(true);
                    boolean publishLoggedInEvent = true;
                    if (lastPublishedEvent != null && lastPublishedEvent instanceof CustomerLoggedInEvent && userName.equals((loggedInEvent = (CustomerLoggedInEvent)lastPublishedEvent).getCustomer().getUsername())) {
                        publishLoggedInEvent = false;
                    }
                    if (publishLoggedInEvent) {
                        loggedInEvent = new CustomerLoggedInEvent(customer, ((Object)((Object)this)).getClass().getName());
                        this.eventPublisher.publishEvent((ApplicationEvent)loggedInEvent);
                        request.setAttribute(LAST_PUBLISHED_EVENT_SESSION_ATTRIBUTED_NAME, (Object)loggedInEvent, 0);
                    }
                } else {
                    customer = this.resolveAuthenticatedCustomer(authentication);
                }
            }
        }
        if (customer == null) {
            customer = this.resolveAnonymousCustomer(request);
        }
        request.setAttribute(customerRequestAttributeName, (Object)customer, 0);
        HashMap<String, Customer> ruleMap = (HashMap<String, Customer>)request.getAttribute(BLC_RULE_MAP_PARAM, 0);
        if (ruleMap == null) {
            ruleMap = new HashMap<String, Customer>();
        }
        ruleMap.put("customer", customer);
        request.setAttribute(BLC_RULE_MAP_PARAM, ruleMap, 0);
    }

    public Customer resolveAuthenticatedCustomer(Authentication authentication) {
        return null;
    }

    public Customer resolveAnonymousCustomer(WebRequest request) {
        Customer customer = (Customer)request.getAttribute(this.getAnonymousCustomerAttributeName(), 2);
        if (customer == null) {
            customer = this.customerService.createNewCustomer();
            customer.setAnonymous(true);
            request.setAttribute(this.getAnonymousCustomerAttributeName(), (Object)customer, 2);
        }
        return customer;
    }

    public String getAnonymousCustomerAttributeName() {
        return ANONYMOUS_CUSTOMER_SESSION_ATTRIBUTE_NAME;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public static String getCustomerRequestAttributeName() {
        return customerRequestAttributeName;
    }

    public static void setCustomerRequestAttributeName(String customerRequestAttributeName) {
        CustomerStateRequestProcessor.customerRequestAttributeName = customerRequestAttributeName;
    }
}

