/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.web.extensibility;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.profile.extensibility.context.MergeApplicationContextXmlConfigResource;
import org.broadleafcommerce.profile.extensibility.context.StandardConfigLocations;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class MergeXmlWebApplicationContext
extends XmlWebApplicationContext {
    private static final Log LOG = LogFactory.getLog(MergeXmlWebApplicationContext.class);
    private String patchLocation;
    private String shutdownBean;
    private String shutdownMethod;

    protected void loadBeanDefinitions(XmlBeanDefinitionReader reader) throws BeansException, IOException {
        String[] broadleafConfigLocations = StandardConfigLocations.retrieveAll((int)4);
        ArrayList<InputStream> sources = new ArrayList<InputStream>();
        for (String location : broadleafConfigLocations) {
            InputStream source = MergeXmlWebApplicationContext.class.getClassLoader().getResourceAsStream(location);
            if (source == null) continue;
            sources.add(source);
        }
        InputStream[] filteredSources = new InputStream[]{};
        filteredSources = sources.toArray(filteredSources);
        String patchLocation = this.getPatchLocation();
        String[] patchLocations = StringUtils.tokenizeToStringArray((String)patchLocation, (String)",; \t\n");
        InputStream[] patches = new InputStream[patchLocations.length];
        for (int i = 0; i < patchLocations.length; ++i) {
            if (patchLocations[i].startsWith("classpath")) {
                patches[i] = MergeXmlWebApplicationContext.class.getClassLoader().getResourceAsStream(patchLocations[i].substring("classpath*:".length(), patchLocations[i].length()));
            } else {
                Resource resource = this.getResourceByPath(patchLocations[i]);
                patches[i] = resource.getInputStream();
            }
            if (patches[i].available() > 0) continue;
            throw new IOException("Unable to open an input stream on specified application context resource: " + patchLocations[i]);
        }
        Resource[] resources = new MergeApplicationContextXmlConfigResource().getConfigResources(filteredSources, patches);
        reader.loadBeanDefinitions(resources);
    }

    protected void doClose() {
        if (this.getShutdownBean() != null && this.getShutdownMethod() != null) {
            try {
                Object shutdownBean = this.getBean(this.getShutdownBean());
                Method shutdownMethod = shutdownBean.getClass().getMethod(this.getShutdownMethod(), new Class[0]);
                shutdownMethod.invoke(shutdownBean, new Object[0]);
            }
            catch (Throwable e) {
                LOG.error((Object)"Unable to execute custom shutdown call", e);
            }
        }
        super.doClose();
    }

    public String getPatchLocation() {
        return this.patchLocation;
    }

    public void setPatchLocation(String patchLocation) {
        this.patchLocation = patchLocation;
    }

    public String getShutdownBean() {
        return this.shutdownBean;
    }

    public void setShutdownBean(String shutdownBean) {
        this.shutdownBean = shutdownBean;
    }

    public String getShutdownMethod() {
        return this.shutdownMethod;
    }

    public void setShutdownMethod(String shutdownMethod) {
        this.shutdownMethod = shutdownMethod;
    }
}

