/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.paypal.web.controller;

import com.paypal.api.payments.Links;
import com.paypal.api.payments.Payment;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.payment.dto.PaymentResponseDTO;
import org.broadleafcommerce.common.payment.service.PaymentGatewayConfiguration;
import org.broadleafcommerce.common.payment.service.PaymentGatewayHostedService;
import org.broadleafcommerce.common.payment.service.PaymentGatewayWebResponseService;
import org.broadleafcommerce.common.vendor.service.exception.PaymentException;
import org.broadleafcommerce.common.web.payment.controller.PaymentGatewayAbstractController;
import org.broadleafcommerce.vendor.paypal.api.AgreementToken;
import org.broadleafcommerce.vendor.paypal.service.PayPalAgreementTokenService;
import org.broadleafcommerce.vendor.paypal.service.PayPalPaymentService;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller(value="blPayPalCheckoutController")
@RequestMapping(value={"/paypal-checkout"})
public class BroadleafPayPalCheckoutController
extends PaymentGatewayAbstractController {
    private static final Log LOG = LogFactory.getLog(BroadleafPayPalCheckoutController.class);
    protected static final String GATEWAY_CONTEXT_KEY = "paypal-checkout";
    @Resource(name="blPayPalCheckoutWebResponseService")
    protected PaymentGatewayWebResponseService paymentGatewayWebResponseService;
    @Resource(name="blPayPalCheckoutHostedService")
    protected PaymentGatewayHostedService paymentGatewayHostedService;
    @Resource(name="blPayPalCheckoutConfiguration")
    protected PaymentGatewayConfiguration paymentGatewayConfiguration;
    @Resource(name="blPayPalPaymentService")
    protected PayPalPaymentService paymentService;
    @Resource(name="blPayPalAgreementTokenService")
    protected PayPalAgreementTokenService agreementTokenService;

    public void handleProcessingException(Exception e, RedirectAttributes redirectAttributes) throws PaymentException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"A Processing Exception Occurred for paypal-checkout. Adding Error to Redirect Attributes.");
        }
        redirectAttributes.addAttribute("PAYMENT_PROCESSING_ERROR", (Object)BroadleafPayPalCheckoutController.getProcessingErrorMessage());
    }

    public void handleUnsuccessfulTransaction(Model model, RedirectAttributes redirectAttributes, PaymentResponseDTO responseDTO) throws PaymentException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"The Transaction was unsuccessful for paypal-checkout. Adding Error to Redirect Attributes.");
        }
        redirectAttributes.addAttribute("PAYMENT_PROCESSING_ERROR", (Object)BroadleafPayPalCheckoutController.getProcessingErrorMessage());
    }

    public String getGatewayContextKey() {
        return GATEWAY_CONTEXT_KEY;
    }

    public PaymentGatewayWebResponseService getWebResponseService() {
        return this.paymentGatewayWebResponseService;
    }

    public PaymentGatewayConfiguration getConfiguration() {
        return this.paymentGatewayConfiguration;
    }

    @RequestMapping(value={"/return"}, method={RequestMethod.GET})
    public String returnEndpoint(Model model, HttpServletRequest request, RedirectAttributes redirectAttributes, @PathVariable Map<String, String> pathVars) throws PaymentException {
        if (request.getParameter("CheckoutComplete") != null) {
            request.setAttribute("CheckoutComplete", (Object)true);
        }
        String path = super.process(model, request, redirectAttributes);
        if (this.isAjaxRequest(request) && StringUtils.startsWith((CharSequence)path, (CharSequence)baseRedirect)) {
            return StringUtils.replace((String)path, (String)baseRedirect, (String)"ajaxredirect:");
        }
        return path;
    }

    @RequestMapping(value={"/error"}, method={RequestMethod.GET})
    public String errorEndpoint(Model model, HttpServletRequest request, RedirectAttributes redirectAttributes, @PathVariable Map<String, String> pathVars) throws PaymentException {
        redirectAttributes.addAttribute("PAYMENT_PROCESSING_ERROR", (Object)request.getParameter("PAYMENT_PROCESSING_ERROR"));
        return this.getCartViewRedirect();
    }

    @RequestMapping(value={"/cancel"}, method={RequestMethod.GET})
    public String cancelEndpoint(Model model, HttpServletRequest request, RedirectAttributes redirectAttributes, @PathVariable Map<String, String> pathVars) throws PaymentException {
        return this.getOrderReviewRedirect();
    }

    @RequestMapping(value={"/checkout/complete"}, method={RequestMethod.POST})
    public String completeCheckout() throws PaymentException {
        this.paymentService.updatePayPalPaymentForFulfillment();
        String paymentId = this.paymentService.getPayPalPaymentIdFromCurrentOrder();
        String payerId = this.paymentService.getPayPalPayerIdFromCurrentOrder();
        if (StringUtils.isBlank((CharSequence)paymentId)) {
            throw new PaymentException("Unable to complete checkout because no PayPal payment id was found on the current order");
        }
        if (StringUtils.isBlank((CharSequence)payerId)) {
            throw new PaymentException("Unable to complete checkout because no PayPal payer id was found on the current order");
        }
        return "redirect:/paypal-checkout/return?paymentId=" + paymentId + "&" + "payerId" + "=" + payerId;
    }

    @RequestMapping(value={"/billing-agreement-token/complete"}, method={RequestMethod.POST})
    public String completeBillingAgreementTokenCheckout() throws PaymentException {
        String billingToken = this.agreementTokenService.getPayPalAgreementTokenFromCurrentOrder();
        if (StringUtils.isBlank((CharSequence)billingToken)) {
            throw new PaymentException("Unable to complete checkout because no PayPal Billing Token was found on the current order");
        }
        return "redirect:/paypal-checkout/return?billingToken=" + billingToken + "&" + "CheckoutComplete" + "=true";
    }

    @RequestMapping(value={"/create-payment"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, String> createPayment(@RequestParam(value="performCheckout") Boolean performCheckout) throws PaymentException {
        HashMap<String, String> response = new HashMap<String, String>();
        Payment createdPayment = this.paymentService.createPayPalPaymentForCurrentOrder(performCheckout);
        response.put("id", createdPayment.getId());
        return response;
    }

    @RequestMapping(value={"/create-billing-agreement-token"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, String> createBillingAgreementToken(@RequestParam(value="performCheckout") Boolean performCheckout) throws PaymentException, URISyntaxException {
        HashMap<String, String> response = new HashMap<String, String>();
        AgreementToken agreementToken = this.agreementTokenService.createPayPalAgreementTokenForCurrentOrder(performCheckout);
        response.put("id", agreementToken.getTokenId());
        return response;
    }

    @RequestMapping(value={"/hosted/create-payment"}, method={RequestMethod.POST})
    public String createPaymentHostedJson(HttpServletRequest request, @RequestParam(value="performCheckout") Boolean performCheckout) throws PaymentException {
        Payment createdPayment = this.paymentService.createPayPalPaymentForCurrentOrder(performCheckout);
        String redirect = this.getApprovalLink(createdPayment);
        if (this.isAjaxRequest(request)) {
            return "ajaxredirect:" + redirect;
        }
        return "redirect:" + redirect;
    }

    @RequestMapping(value={"/hosted/create-billing-agreement-token"}, method={RequestMethod.POST})
    public String createBillingAgreementTokenHostedJson(HttpServletRequest request, @RequestParam(value="performCheckout") Boolean performCheckout) throws PaymentException {
        AgreementToken agreementToken = this.agreementTokenService.createPayPalAgreementTokenForCurrentOrder(performCheckout);
        String redirect = this.getApprovalLink(agreementToken);
        if (this.isAjaxRequest(request)) {
            return "ajaxredirect:" + redirect;
        }
        return "redirect:" + redirect;
    }

    protected String getApprovalLink(Payment payment) {
        for (Links links : payment.getLinks()) {
            if (!links.getRel().equals("approval_url")) continue;
            return links.getHref();
        }
        return null;
    }

    protected String getApprovalLink(AgreementToken agreementToken) {
        for (Links links : agreementToken.getLinks()) {
            if (!links.getRel().equals("approval_url")) continue;
            return links.getHref();
        }
        return null;
    }
}

