/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.paypal.service.payment.type;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.broadleafcommerce.common.BroadleafEnumerationType;

public class PayPalShippingDisplayType
implements Serializable,
BroadleafEnumerationType {
    private static final long serialVersionUID = 1L;
    private static final Map<String, PayPalShippingDisplayType> TYPES = new HashMap<String, PayPalShippingDisplayType>();
    public static final PayPalShippingDisplayType PROVIDE_SHIPPING = new PayPalShippingDisplayType("0", "Provide Shipping");
    public static final PayPalShippingDisplayType NO_DISPLAY = new PayPalShippingDisplayType("1", "No Display");
    public static final PayPalShippingDisplayType CAPTURE_SHIPPING = new PayPalShippingDisplayType("2", "Capture Shipping");
    private String type;
    private String friendlyType;

    public static PayPalShippingDisplayType getInstance(String type) {
        return TYPES.get(type);
    }

    public PayPalShippingDisplayType() {
    }

    public PayPalShippingDisplayType(String type, String friendlyType) {
        this.friendlyType = friendlyType;
        this.setType(type);
    }

    public String getType() {
        return this.type;
    }

    public String getFriendlyType() {
        return this.friendlyType;
    }

    private void setType(String type) {
        this.type = type;
        if (!TYPES.containsKey(type)) {
            TYPES.put(type, this);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PayPalShippingDisplayType other = (PayPalShippingDisplayType)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

