/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.paypal.service.payment;

import com.paypal.api.payments.Patch;
import com.paypal.api.payments.Plan;
import com.paypal.base.rest.APIContext;
import com.paypal.base.rest.PayPalRESTException;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalResponse;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalUpdatePlanResponse;

public class PayPalUpdatePlanRequest
extends PayPalRequest {
    protected Plan plan;
    protected List<Patch> patches;

    public PayPalUpdatePlanRequest(Plan plan, List<Patch> patches, APIContext apiContext) {
        super(apiContext);
        this.plan = plan;
        this.patches = patches;
    }

    @Override
    protected PayPalResponse executeInternal() throws PayPalRESTException {
        this.plan.update(this.apiContext, this.patches);
        return new PayPalUpdatePlanResponse();
    }

    @Override
    protected boolean isRequestValid() {
        boolean paymentValid;
        boolean bl = paymentValid = this.plan != null && StringUtils.isNotBlank((CharSequence)this.plan.getId());
        if (paymentValid && CollectionUtils.isNotEmpty(this.patches)) {
            for (Patch patch : this.patches) {
                if (patch == null || StringUtils.isBlank((CharSequence)patch.getPath()) || StringUtils.isBlank((CharSequence)patch.getOp())) {
                    return false;
                }
                if (patch.getOp() == "remove" || patch.getValue() != null) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

