/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.paypal.service.payment;

import com.paypal.api.payments.Patch;
import com.paypal.api.payments.Payment;
import com.paypal.base.rest.APIContext;
import com.paypal.base.rest.PayPalRESTException;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalResponse;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalUpdatePaymentResponse;

public class PayPalUpdatePaymentRequest
extends PayPalRequest {
    protected Payment payment;
    protected List<Patch> patches;

    public PayPalUpdatePaymentRequest(Payment payment, List<Patch> patches, APIContext apiContext) {
        super(apiContext);
        this.payment = payment;
        this.patches = patches;
    }

    @Override
    protected PayPalResponse executeInternal() throws PayPalRESTException {
        this.payment.update(this.apiContext, this.patches);
        return new PayPalUpdatePaymentResponse();
    }

    @Override
    protected boolean isRequestValid() {
        boolean paymentValid;
        boolean bl = paymentValid = this.payment != null && StringUtils.isNotBlank((CharSequence)this.payment.getId());
        if (paymentValid && CollectionUtils.isNotEmpty(this.patches)) {
            for (Patch patch : this.patches) {
                if (patch == null || StringUtils.isBlank((CharSequence)patch.getPath()) || StringUtils.isBlank((CharSequence)patch.getOp())) {
                    return false;
                }
                if (patch.getOp() == "remove" || patch.getValue() != null) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

