/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.paypal.service.payment;

import com.paypal.api.payments.Authorization;
import com.paypal.api.payments.Capture;
import com.paypal.base.rest.APIContext;
import com.paypal.base.rest.PayPalRESTException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalCaptureResponse;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalResponse;

public class PayPalCaptureRequest
extends PayPalRequest {
    protected Authorization authorization;
    protected Capture capture;

    public PayPalCaptureRequest(Authorization authorization, Capture capture, APIContext apiContext) {
        super(apiContext);
        this.authorization = authorization;
        this.capture = capture;
    }

    @Override
    public PayPalResponse executeInternal() throws PayPalRESTException {
        return new PayPalCaptureResponse(this.authorization.capture(this.apiContext, this.capture));
    }

    @Override
    protected boolean isRequestValid() {
        return this.authorization != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.authorization.getId()}) && this.capture != null && this.capture.getAmount() != null && this.capture.getAmount().getDetails() == null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.capture.getAmount().getCurrency()}) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.capture.getAmount().getTotal()}) && NumberUtils.isNumber((String)this.capture.getAmount().getTotal());
    }
}

