/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.paypal.service;

import com.paypal.api.payments.Amount;
import com.paypal.api.payments.ItemList;
import com.paypal.api.payments.Patch;
import com.paypal.api.payments.Payer;
import com.paypal.api.payments.Payment;
import com.paypal.api.payments.RedirectUrls;
import com.paypal.api.payments.Transaction;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.broadleafcommerce.common.payment.dto.PaymentRequestDTO;
import org.broadleafcommerce.common.payment.service.CurrentOrderPaymentRequestService;
import org.broadleafcommerce.common.vendor.service.exception.PaymentException;
import org.broadleafcommerce.payment.service.gateway.ExternalCallPayPalCheckoutService;
import org.broadleafcommerce.vendor.paypal.service.PayPalPaymentService;
import org.broadleafcommerce.vendor.paypal.service.PayPalWebProfileService;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalCreatePaymentRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalCreatePaymentResponse;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalUpdatePaymentRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="blPayPalPaymentService")
public class PayPalPaymentServiceImpl
implements PayPalPaymentService {
    @Resource(name="blExternalCallPayPalCheckoutService")
    protected ExternalCallPayPalCheckoutService externalCallService;
    @Resource(name="blPayPalWebProfileService")
    protected PayPalWebProfileService webProfileService;
    @Autowired(required=false)
    protected CurrentOrderPaymentRequestService currentOrderPaymentRequestService;
    @Value(value="${gateway.paypal.checkout.rest.populate.shipping.create.payment:true}")
    protected boolean shouldPopulateShippingOnPaymentCreation;

    @Override
    public Payment createPayPalPaymentForCurrentOrder(boolean performCheckoutOnReturn) throws PaymentException {
        PaymentRequestDTO paymentRequestDTO = this.getPaymentRequestForCurrentOrder();
        Payer payer = this.constructPayer(paymentRequestDTO);
        RedirectUrls redirectUrls = new RedirectUrls();
        redirectUrls.setCancelUrl(this.externalCallService.getConfiguration().getCancelUrl());
        redirectUrls.setReturnUrl(this.externalCallService.getConfiguration().getReturnUrl());
        Amount amount = this.externalCallService.getPayPalAmountFromOrder(paymentRequestDTO);
        Transaction transaction = new Transaction();
        transaction.setAmount(amount);
        transaction.setDescription(this.externalCallService.getConfiguration().getPaymentDescription());
        transaction.setCustom(paymentRequestDTO.getOrderId() + "|" + performCheckoutOnReturn);
        ItemList itemList = this.externalCallService.getPayPalItemListFromOrder(paymentRequestDTO, this.shouldPopulateShippingOnPaymentCreation);
        if (itemList != null) {
            transaction.setItemList(itemList);
        }
        ArrayList<Transaction> transactions = new ArrayList<Transaction>();
        transactions.add(transaction);
        Payment payment = new Payment();
        payment.setIntent(this.getIntent(performCheckoutOnReturn));
        payment.setPayer(payer);
        payment.setRedirectUrls(redirectUrls);
        payment.setTransactions(transactions);
        String profileId = this.webProfileService.getWebProfileId(paymentRequestDTO);
        if (StringUtils.isNotBlank((CharSequence)profileId)) {
            payment.setExperienceProfileId(profileId);
        }
        return this.createPayment(payment, paymentRequestDTO);
    }

    protected Payer constructPayer(PaymentRequestDTO paymentRequestDTO) {
        Payer payer = new Payer();
        payer.setPaymentMethod("paypal");
        return payer;
    }

    @Override
    public void updatePayPalPaymentForFulfillment() throws PaymentException {
        PaymentRequestDTO paymentRequestDTO = this.getPaymentRequestForCurrentOrder();
        String paymentId = this.getPayPalPaymentIdFromCurrentOrder();
        if (paymentRequestDTO == null) {
            throw new PaymentException("Unable to update the current PayPal payment because the PaymentRequestDTO was null");
        }
        if (StringUtils.isBlank((CharSequence)paymentId)) {
            throw new PaymentException("Unable to update the current PayPal payment because no PayPal payment id was found on the order");
        }
        ArrayList<Patch> patches = new ArrayList<Patch>();
        Patch amountPatch = new Patch();
        amountPatch.setOp("replace");
        amountPatch.setPath("/transactions/0/amount");
        Amount amount = this.externalCallService.getPayPalAmountFromOrder(paymentRequestDTO);
        amountPatch.setValue((Object)amount);
        patches.add(amountPatch);
        ItemList itemList = this.externalCallService.getPayPalItemListFromOrder(paymentRequestDTO, true);
        if (itemList != null) {
            Patch shipToPatch = new Patch();
            shipToPatch.setOp("replace");
            shipToPatch.setPath("/transactions/0/item_list");
            shipToPatch.setValue((Object)itemList);
            patches.add(shipToPatch);
        }
        Patch customPatch = new Patch();
        customPatch.setPath("/transactions/0/custom");
        customPatch.setOp("replace");
        customPatch.setValue((Object)(paymentRequestDTO.getOrderId() + "|" + true));
        patches.add(customPatch);
        Payment paypalPayment = new Payment();
        paypalPayment.setId(paymentId);
        this.updatePayment(paypalPayment, patches, paymentRequestDTO);
    }

    protected Payment createPayment(Payment payment, PaymentRequestDTO paymentRequestDTO) throws PaymentException {
        PayPalCreatePaymentResponse response = (PayPalCreatePaymentResponse)this.externalCallService.call(new PayPalCreatePaymentRequest(payment, this.externalCallService.constructAPIContext(paymentRequestDTO)));
        return response.getPayment();
    }

    protected void updatePayment(Payment payment, List<Patch> patches, PaymentRequestDTO paymentRequestDTO) throws PaymentException {
        this.externalCallService.call(new PayPalUpdatePaymentRequest(payment, patches, this.externalCallService.constructAPIContext(paymentRequestDTO)));
    }

    protected PaymentRequestDTO getPaymentRequestForCurrentOrder() throws PaymentException {
        if (this.currentOrderPaymentRequestService != null) {
            return this.currentOrderPaymentRequestService.getPaymentRequestFromCurrentOrder();
        }
        throw new PaymentException("Unable to get PaymentRequestDTO for current order");
    }

    @Override
    public String getPayPalPaymentIdFromCurrentOrder() throws PaymentException {
        if (this.currentOrderPaymentRequestService != null) {
            return this.currentOrderPaymentRequestService.retrieveOrderAttributeFromCurrentOrder("PAYMENTID");
        }
        throw new PaymentException("Unable to retrieve PayPal payment id for current order");
    }

    @Override
    public String getPayPalPayerIdFromCurrentOrder() throws PaymentException {
        if (this.currentOrderPaymentRequestService != null) {
            return this.currentOrderPaymentRequestService.retrieveOrderAttributeFromCurrentOrder("PAYERID");
        }
        throw new PaymentException("Unable to retrieve PayPal payer id for current order");
    }

    @Override
    public void setPayPalPaymentIdOnCurrentOrder(String paymentId) throws PaymentException {
        if (this.currentOrderPaymentRequestService == null) {
            throw new PaymentException("Unable to set PayPal payment id on current order");
        }
        this.currentOrderPaymentRequestService.addOrderAttributeToCurrentOrder("PAYMENTID", paymentId);
    }

    @Override
    public void setPayPalPayerIdOnCurrentOrder(String payerId) throws PaymentException {
        if (this.currentOrderPaymentRequestService == null) {
            throw new PaymentException("Unable to set PayPal payer id on current order");
        }
        this.currentOrderPaymentRequestService.addOrderAttributeToCurrentOrder("PAYERID", payerId);
    }

    public String getIntent(boolean performCheckoutOnReturn) {
        if (this.externalCallService.getConfiguration().isPerformAuthorizeAndCapture()) {
            return "sale";
        }
        return "authorize";
    }
}

