/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.paypal.service;

import com.paypal.api.payments.Address;
import com.paypal.api.payments.Agreement;
import com.paypal.api.payments.Amount;
import com.paypal.api.payments.Currency;
import com.paypal.api.payments.MerchantPreferences;
import com.paypal.api.payments.Patch;
import com.paypal.api.payments.Payer;
import com.paypal.api.payments.PaymentDefinition;
import com.paypal.api.payments.Plan;
import com.paypal.api.payments.ShippingAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.broadleafcommerce.common.payment.dto.PaymentRequestDTO;
import org.broadleafcommerce.common.payment.service.CurrentOrderPaymentRequestService;
import org.broadleafcommerce.common.vendor.service.exception.PaymentException;
import org.broadleafcommerce.payment.service.gateway.ExternalCallPayPalCheckoutService;
import org.broadleafcommerce.vendor.paypal.service.PayPalBillingAgreementService;
import org.broadleafcommerce.vendor.paypal.service.PayPalWebProfileService;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalCreateBillingAgreementRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalCreateBillingAgreementResponse;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalCreatePlanRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalCreatePlanResponse;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalUpdatePlanRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="blPayPalBillingAgreementService")
public class PayPalBillingAgreementServiceImpl
implements PayPalBillingAgreementService {
    @Resource(name="blExternalCallPayPalCheckoutService")
    protected ExternalCallPayPalCheckoutService externalCallService;
    @Resource(name="blPayPalWebProfileService")
    protected PayPalWebProfileService webProfileService;
    @Autowired(required=false)
    protected CurrentOrderPaymentRequestService currentOrderPaymentRequestService;

    @Override
    public Agreement createPayPalBillingAgreementForCurrentOrder(boolean performCheckoutOnReturn) throws PaymentException {
        PaymentRequestDTO paymentRequestDTO = this.getPaymentRequestForCurrentOrder();
        Plan plan = this.constructPlan(paymentRequestDTO);
        ArrayList<Patch> patchRequestList = new ArrayList<Patch>();
        HashMap<String, String> value = new HashMap<String, String>();
        value.put("state", "ACTIVE");
        Patch patch = new Patch();
        patch.setPath("/");
        patch.setValue(value);
        patch.setOp("replace");
        patchRequestList.add(patch);
        this.updatePlan(plan, patchRequestList, paymentRequestDTO);
        Agreement agreement = this.constructAgreement(paymentRequestDTO, plan);
        return this.createAgreement(agreement, paymentRequestDTO);
    }

    protected Agreement constructAgreement(PaymentRequestDTO paymentRequestDTO, Plan plan) {
        Payer payer = this.constructPayer(paymentRequestDTO);
        Agreement agreement = new Agreement();
        agreement.setName("Billing Agreement");
        agreement.setDescription("Billing Agreement");
        agreement.setPayer(payer);
        Plan agreementPlan = new Plan();
        agreementPlan.setId(plan.getId());
        agreement.setPlan(agreementPlan);
        agreement.setStartDate("2018-12-22T09:13:49Z");
        if (paymentRequestDTO.shipToPopulated()) {
            ShippingAddress address = this.externalCallService.getPayPalShippingAddress(paymentRequestDTO);
            agreement.setShippingAddress((Address)address);
        }
        return agreement;
    }

    protected Payer constructPayer(PaymentRequestDTO paymentRequestDTO) {
        Payer payer = new Payer();
        payer.setPaymentMethod("paypal");
        return payer;
    }

    protected Plan constructPlan(PaymentRequestDTO paymentRequestDTO) throws PaymentException {
        MerchantPreferences merchantPreferences = new MerchantPreferences();
        merchantPreferences.setCancelUrl(this.externalCallService.getConfiguration().getCancelUrl());
        merchantPreferences.setReturnUrl(this.externalCallService.getConfiguration().getReturnUrl());
        Plan plan = new Plan();
        plan.setName("Test Plan");
        plan.setDescription("Test Plan Description");
        plan.setType("INFINITE");
        plan.setMerchantPreferences(merchantPreferences);
        ArrayList<PaymentDefinition> paymentDefinitions = new ArrayList<PaymentDefinition>();
        PaymentDefinition paymentDefinition = new PaymentDefinition();
        paymentDefinition.setName("Test Regular Payment Definition");
        paymentDefinition.setType("REGULAR");
        paymentDefinition.setFrequencyInterval("1");
        paymentDefinition.setFrequency("YEAR");
        paymentDefinition.setCycles("0");
        Amount amt = this.externalCallService.getPayPalAmountFromOrder(paymentRequestDTO);
        paymentDefinition.setAmount(new Currency(amt.getCurrency(), amt.getTotal()));
        paymentDefinitions.add(paymentDefinition);
        plan.setPaymentDefinitions(paymentDefinitions);
        return this.createPlan(plan, paymentRequestDTO);
    }

    protected Plan createPlan(Plan plan, PaymentRequestDTO paymentRequestDTO) throws PaymentException {
        PayPalCreatePlanResponse response = (PayPalCreatePlanResponse)this.externalCallService.call(new PayPalCreatePlanRequest(plan, this.externalCallService.constructAPIContext(paymentRequestDTO)));
        return response.getPlan();
    }

    protected void updatePlan(Plan plan, List<Patch> patches, PaymentRequestDTO paymentRequestDTO) throws PaymentException {
        this.externalCallService.call(new PayPalUpdatePlanRequest(plan, patches, this.externalCallService.constructAPIContext(paymentRequestDTO)));
    }

    protected Agreement createAgreement(Agreement agreement, PaymentRequestDTO paymentRequestDTO) throws PaymentException {
        PayPalCreateBillingAgreementResponse response = (PayPalCreateBillingAgreementResponse)this.externalCallService.call(new PayPalCreateBillingAgreementRequest(agreement, this.externalCallService.constructAPIContext(paymentRequestDTO)));
        return response.getAgreement();
    }

    protected PaymentRequestDTO getPaymentRequestForCurrentOrder() throws PaymentException {
        if (this.currentOrderPaymentRequestService != null) {
            return this.currentOrderPaymentRequestService.getPaymentRequestFromCurrentOrder();
        }
        throw new PaymentException("Unable to get PaymentRequestDTO for current order");
    }

    @Override
    public String getPayPalBillingTokenFromCurrentOrder() throws PaymentException {
        if (this.currentOrderPaymentRequestService != null) {
            return this.currentOrderPaymentRequestService.retrieveOrderAttributeFromCurrentOrder("BILLING_EC_TOKEN");
        }
        throw new PaymentException("Unable to retrieve PayPal Billing EC token for current order");
    }

    @Override
    public void setPayPalBillingTokenOnCurrentOrder(String billingToken) throws PaymentException {
        if (this.currentOrderPaymentRequestService == null) {
            throw new PaymentException("Unable to set PayPal Billing EC token on current order");
        }
        this.currentOrderPaymentRequestService.addOrderAttributeToCurrentOrder("BILLING_EC_TOKEN", billingToken);
    }
}

