/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.payment.service.gateway;

import com.paypal.api.payments.Payment;
import javax.annotation.Resource;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.payment.PaymentType;
import org.broadleafcommerce.common.payment.dto.PaymentRequestDTO;
import org.broadleafcommerce.common.payment.dto.PaymentResponseDTO;
import org.broadleafcommerce.common.payment.service.AbstractPaymentGatewayReportingService;
import org.broadleafcommerce.common.payment.service.PaymentGatewayReportingService;
import org.broadleafcommerce.common.vendor.service.exception.PaymentException;
import org.broadleafcommerce.payment.service.gateway.ExternalCallPayPalCheckoutService;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalCheckoutPaymentGatewayType;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalPaymentRetrievalRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalPaymentRetrievalResponse;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="blPayPalCheckoutReportingService")
public class PayPalCheckoutReportingServiceImpl
extends AbstractPaymentGatewayReportingService
implements PaymentGatewayReportingService {
    private static final Log LOG = LogFactory.getLog(PayPalCheckoutReportingServiceImpl.class);
    @Resource(name="blExternalCallPayPalCheckoutService")
    protected ExternalCallPayPalCheckoutService payPalCheckoutService;

    public PaymentResponseDTO findDetailsByTransaction(PaymentRequestDTO paymentRequestDTO) throws PaymentException {
        Assert.isTrue((boolean)paymentRequestDTO.getAdditionalFields().containsKey("payerId"), (String)"The RequestDTO must contain a payerID");
        Assert.isTrue((boolean)paymentRequestDTO.getAdditionalFields().containsKey("paymentId"), (String)"The RequestDTO must contain a paymentID");
        PayPalPaymentRetrievalResponse response = (PayPalPaymentRetrievalResponse)this.payPalCheckoutService.call(new PayPalPaymentRetrievalRequest((String)paymentRequestDTO.getAdditionalFields().get("paymentId"), this.payPalCheckoutService.constructAPIContext(paymentRequestDTO)));
        Payment payment = response.getPayment();
        PaymentResponseDTO responseDTO = new PaymentResponseDTO(PaymentType.THIRD_PARTY_ACCOUNT, PayPalCheckoutPaymentGatewayType.PAYPAL_CHECKOUT);
        this.payPalCheckoutService.setCommonDetailsResponse(payment, responseDTO);
        responseDTO.responseMap("PAYERID", (String)paymentRequestDTO.getAdditionalFields().get("payerId")).responseMap("PAYMENTID", (String)paymentRequestDTO.getAdditionalFields().get("paymentId"));
        LOG.info((Object)("ResponseDTO created: " + ToStringBuilder.reflectionToString((Object)responseDTO, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE)));
        return responseDTO;
    }
}

