/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.payment.service.gateway;

import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.payment.PaymentTransactionType;
import org.broadleafcommerce.common.payment.dto.PaymentRequestDTO;
import org.broadleafcommerce.common.payment.dto.PaymentResponseDTO;
import org.broadleafcommerce.common.payment.service.AbstractPaymentGatewayHostedService;
import org.broadleafcommerce.common.payment.service.PaymentGatewayHostedService;
import org.broadleafcommerce.common.payment.service.PaymentGatewayTransactionService;
import org.broadleafcommerce.common.vendor.service.exception.PaymentException;
import org.broadleafcommerce.payment.service.gateway.ExternalCallPayPalCheckoutService;
import org.springframework.stereotype.Service;

@Service(value="blPayPalCheckoutHostedService")
public class PayPalCheckoutHostedServiceImpl
extends AbstractPaymentGatewayHostedService
implements PaymentGatewayHostedService {
    protected static final Log LOG = LogFactory.getLog(PayPalCheckoutHostedServiceImpl.class);
    @Resource(name="blExternalCallPayPalCheckoutService")
    protected ExternalCallPayPalCheckoutService payPalCheckoutService;
    @Resource(name="blPayPalCheckoutTransactionService")
    protected PaymentGatewayTransactionService transactionService;

    public PaymentResponseDTO requestHostedEndpoint(PaymentRequestDTO paymentRequestDTO) throws PaymentException {
        PaymentResponseDTO responseDTO;
        if (this.payPalCheckoutService.getConfiguration().isPerformAuthorizeAndCapture()) {
            responseDTO = this.transactionService.authorizeAndCapture(paymentRequestDTO);
            responseDTO.paymentTransactionType(PaymentTransactionType.AUTHORIZE_AND_CAPTURE);
        } else {
            responseDTO = this.transactionService.authorize(paymentRequestDTO);
            responseDTO.paymentTransactionType(PaymentTransactionType.AUTHORIZE);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Request to PayPal Checkout Hosted Endpoint with raw response: " + responseDTO.getRawResponse()));
        }
        return responseDTO;
    }
}

