/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.payment.service.gateway;

import com.paypal.api.payments.Address;
import com.paypal.api.payments.Amount;
import com.paypal.api.payments.Details;
import com.paypal.api.payments.Item;
import com.paypal.api.payments.ItemList;
import com.paypal.api.payments.Payment;
import com.paypal.api.payments.ShippingAddress;
import com.paypal.api.payments.Transaction;
import com.paypal.base.rest.APIContext;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.payment.dto.AddressDTO;
import org.broadleafcommerce.common.payment.dto.LineItemDTO;
import org.broadleafcommerce.common.payment.dto.PaymentRequestDTO;
import org.broadleafcommerce.common.payment.dto.PaymentResponseDTO;
import org.broadleafcommerce.common.payment.service.AbstractExternalPaymentGatewayCall;
import org.broadleafcommerce.common.vendor.service.exception.PaymentException;
import org.broadleafcommerce.payment.service.gateway.ExternalCallPayPalCheckoutService;
import org.broadleafcommerce.payment.service.gateway.PayPalCheckoutConfiguration;
import org.broadleafcommerce.vendor.paypal.api.AgreementToken;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalResponse;
import org.springframework.stereotype.Service;

@Service(value="blExternalCallPayPalCheckoutService")
public class ExternalCallPayPalCheckoutServiceImpl
extends AbstractExternalPaymentGatewayCall<PayPalRequest, PayPalResponse>
implements ExternalCallPayPalCheckoutService {
    @Resource(name="blPayPalCheckoutConfiguration")
    protected PayPalCheckoutConfiguration configuration;

    @Override
    public PayPalCheckoutConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void setCommonDetailsResponse(AgreementToken response, PaymentResponseDTO responseDTO, Money amount, String orderId, boolean checkoutComplete) {
        if (response != null) {
            responseDTO.rawResponse(response.toJSON());
            Address shippingAddress = response.getShippingAddress();
            if (shippingAddress != null) {
                responseDTO.shipTo().addressLine1(shippingAddress.getLine1()).addressLine2(shippingAddress.getLine2()).addressCityLocality(shippingAddress.getCity()).addressStateRegion(shippingAddress.getState()).addressPostalCode(shippingAddress.getPostalCode()).addressCountryCode(shippingAddress.getCountryCode()).addressPhone(shippingAddress.getPhone()).done();
            }
        }
        responseDTO.amount(amount).orderId(orderId).successful(true).valid(true).completeCheckoutOnCallback(checkoutComplete);
    }

    @Override
    public void setCommonDetailsResponse(Payment response, PaymentResponseDTO responseDTO) {
        responseDTO.rawResponse(response.toJSON());
        if (CollectionUtils.isNotEmpty((Collection)response.getTransactions()) && response.getTransactions().get(0) != null && ((Transaction)response.getTransactions().get(0)).getItemList() != null) {
            ShippingAddress shippingAddress = ((Transaction)response.getTransactions().get(0)).getItemList().getShippingAddress();
            String shipPhone = shippingAddress.getPhone();
            String itemListPhone = ((Transaction)response.getTransactions().get(0)).getItemList().getShippingPhoneNumber();
            String payerPhone = response.getPayer().getPayerInfo().getPhone();
            String phone = "";
            if (shipPhone != null) {
                phone = shipPhone;
            } else if (itemListPhone != null) {
                phone = itemListPhone;
            } else if (payerPhone != null) {
                phone = payerPhone;
            }
            responseDTO.shipTo().addressFullName(shippingAddress.getRecipientName()).addressLine1(shippingAddress.getLine1()).addressLine2(shippingAddress.getLine2()).addressCityLocality(shippingAddress.getCity()).addressStateRegion(shippingAddress.getState()).addressPostalCode(shippingAddress.getPostalCode()).addressCountryCode(shippingAddress.getCountryCode()).addressPhone(phone).done();
            if (shippingAddress.getStatus() != null) {
                responseDTO.getShipTo().additionalFields("PAYMENTREQUEST_n_ADDRESSSTATUS", (Object)shippingAddress.getStatus());
            }
            Transaction transaction = (Transaction)response.getTransactions().get(0);
            String itemTotal = "";
            String shippingDiscount = "";
            String shippingTotal = "";
            String totalTax = "";
            String total = "0.00";
            String currency = "USD";
            if (transaction.getAmount() != null && transaction.getAmount().getDetails() != null) {
                Details details = transaction.getAmount().getDetails();
                if (details.getSubtotal() != null) {
                    itemTotal = details.getSubtotal();
                }
                if (details.getShippingDiscount() != null) {
                    shippingDiscount = details.getShippingDiscount();
                }
                if (details.getShipping() != null) {
                    shippingTotal = details.getShipping();
                }
                if (details.getTax() != null) {
                    totalTax = details.getTax();
                }
            }
            if (transaction.getAmount() != null) {
                total = transaction.getAmount().getTotal();
                if (transaction.getAmount().getCurrency() != null) {
                    currency = transaction.getAmount().getCurrency();
                }
            }
            String[] customFields = transaction.getCustom().split("\\|");
            responseDTO.amount(new Money(total, currency)).orderId(customFields[0]).successful(true).valid(true).completeCheckoutOnCallback(Boolean.parseBoolean(customFields[1])).responseMap("PAYMENTREQUEST_n_ALLOWEDPAYMENTMETHOD", response.getPayer().getPaymentMethod()).responseMap("PAYMENTREQUEST_n_TRANSACTIONID", response.getId()).responseMap("PAYMENTREQUEST_n_ITEMAMT", itemTotal).responseMap("PAYMENTREQUEST_n_SHIPDISCAMT", shippingDiscount).responseMap("PAYMENTREQUEST_n_SHIPPINGAMT", shippingTotal).responseMap("PAYMENTREQUEST_n_TAXAMT", totalTax);
            String payerStatus = response.getPayer().getStatus();
            ((PaymentResponseDTO)responseDTO.customer().firstName(response.getPayer().getPayerInfo().getFirstName()).lastName(response.getPayer().getPayerInfo().getLastName()).phone(response.getPayer().getPayerInfo().getPhone()).email(response.getPayer().getPayerInfo().getEmail()).done()).responseMap("NOTE", response.getNoteToPayer()).responseMap("PAYERSTATUS", payerStatus);
        }
    }

    @Override
    public ShippingAddress getPayPalShippingAddress(PaymentRequestDTO paymentRequestDTO) {
        ShippingAddress shipAddress = new ShippingAddress();
        AddressDTO addressDTO = paymentRequestDTO.getShipTo();
        shipAddress.setRecipientName(addressDTO.getAddressFullName());
        shipAddress.setLine1(addressDTO.getAddressLine1());
        shipAddress.setLine2(addressDTO.getAddressLine2());
        shipAddress.setCity(addressDTO.getAddressCityLocality());
        shipAddress.setState(addressDTO.getAddressStateRegion());
        shipAddress.setPostalCode(addressDTO.getAddressPostalCode());
        shipAddress.setCountryCode(addressDTO.getAddressCountryCode());
        if (StringUtils.isNotBlank((CharSequence)addressDTO.getAddressPhone())) {
            shipAddress.setPhone(addressDTO.getAddressPhone());
        }
        return shipAddress;
    }

    @Override
    public ItemList getPayPalItemListFromOrder(PaymentRequestDTO paymentRequestDTO, boolean shouldPopulateShipping) {
        ItemList itemList = new ItemList();
        boolean returnItemList = false;
        if (paymentRequestDTO.shipToPopulated() && shouldPopulateShipping) {
            ShippingAddress address = this.getPayPalShippingAddress(paymentRequestDTO);
            itemList.setShippingAddress(address);
            returnItemList = true;
        }
        if (CollectionUtils.isNotEmpty((Collection)paymentRequestDTO.getLineItems())) {
            ArrayList<Item> items = new ArrayList<Item>();
            for (LineItemDTO lineItem : paymentRequestDTO.getLineItems()) {
                Item item = new Item();
                item.setCategory(lineItem.getCategory());
                item.setDescription(lineItem.getDescription());
                item.setQuantity(lineItem.getQuantity());
                item.setPrice(lineItem.getTotal());
                item.setTax(lineItem.getTax());
                item.setCurrency(paymentRequestDTO.getOrderCurrencyCode());
                item.setName(lineItem.getName());
                items.add(item);
            }
            itemList.setItems(items);
            returnItemList = true;
        }
        return returnItemList ? itemList : null;
    }

    @Override
    public Amount getPayPalAmountFromOrder(PaymentRequestDTO paymentRequestDTO) {
        Details details = new Details();
        details.setShipping(paymentRequestDTO.getShippingTotal());
        details.setSubtotal(paymentRequestDTO.getOrderSubtotal());
        details.setTax(paymentRequestDTO.getTaxTotal());
        Amount amount = new Amount();
        amount.setCurrency(paymentRequestDTO.getOrderCurrencyCode());
        amount.setTotal(paymentRequestDTO.getTransactionTotal());
        amount.setDetails(details);
        return amount;
    }

    public String getServiceName() {
        return this.getClass().getName();
    }

    @Override
    public PayPalResponse call(PayPalRequest paymentRequest) throws PaymentException {
        return (PayPalResponse)super.process((Object)paymentRequest);
    }

    public PayPalResponse communicateWithVendor(PayPalRequest paymentRequest) throws Exception {
        return paymentRequest.execute();
    }

    public Integer getFailureReportingThreshold() {
        return this.configuration.getFailureReportingThreshold();
    }

    @Override
    public APIContext constructAPIContext(PaymentRequestDTO paymentRequestDTO) {
        APIContext context = this.initializeAPIContext();
        if (paymentRequestDTO.getAdditionalFields().containsKey("PayPal-Request-Id")) {
            context.setRequestId((String)paymentRequestDTO.getAdditionalFields().get("PayPal-Request-Id"));
        }
        if (paymentRequestDTO.getAdditionalFields().containsKey("PayPal-Auth-Assertion")) {
            context.addHTTPHeader("PayPal-Auth-Assertion", (String)paymentRequestDTO.getAdditionalFields().get("PayPal-Auth-Assertion"));
        }
        if (paymentRequestDTO.getAdditionalFields().containsKey("PayPal-Client-Metadata-Id")) {
            context.addHTTPHeader("PayPal-Client-Metadata-Id", (String)paymentRequestDTO.getAdditionalFields().get("PayPal-Client-Metadata-Id"));
        }
        if (paymentRequestDTO.getAdditionalFields().containsKey("PayPal-Mock-Response")) {
            context.addHTTPHeader("PayPal-Mock-Response", (String)paymentRequestDTO.getAdditionalFields().get("PayPal-Mock-Response"));
        }
        return context;
    }

    private APIContext initializeAPIContext() {
        APIContext context = new APIContext(this.configuration.getCheckoutRestClientId(), this.configuration.getCheckoutRestSecret(), this.configuration.getCheckoutRestMode());
        context.addHTTPHeader("PayPal-Partner-Attribution-Id", "BroadleafCommerce_SP_1AAuto");
        return context;
    }
}

