/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.paypal.service.payment;

import com.paypal.api.payments.Amount;
import com.paypal.api.payments.Details;
import com.paypal.api.payments.Payment;
import com.paypal.api.payments.Transaction;
import com.paypal.base.rest.APIContext;
import com.paypal.base.rest.PayPalRESTException;
import java.util.Collection;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalCreatePaymentResponse;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalResponse;

public class PayPalCreatePaymentRequest
extends PayPalRequest {
    protected Payment payment;

    public PayPalCreatePaymentRequest(Payment payment, APIContext apiContext) {
        super(apiContext);
        this.payment = payment;
    }

    @Override
    protected PayPalResponse executeInternal() throws PayPalRESTException {
        return new PayPalCreatePaymentResponse(this.payment.create(this.apiContext));
    }

    @Override
    protected boolean isRequestValid() {
        Transaction transaction;
        boolean baseCaseValid;
        boolean bl = baseCaseValid = this.payment != null && this.payment.getPayer() != null && CollectionUtils.isNotEmpty((Collection)this.payment.getTransactions());
        if (baseCaseValid && (transaction = (Transaction)this.payment.getTransactions().get(0)) != null && transaction.getAmount() != null) {
            Amount amount = transaction.getAmount();
            Details details = amount.getDetails();
            boolean amountConditions = (amount.getCurrency() == null || StringUtils.isNotBlank((CharSequence)amount.getCurrency())) && StringUtils.isNotBlank((CharSequence)amount.getTotal());
            boolean detailsConditions = !(details == null || !StringUtils.isNotBlank((CharSequence)details.getSubtotal()) || details.getShipping() != null && !StringUtils.isNotBlank((CharSequence)details.getShipping()) || details.getTax() != null && !StringUtils.isNotBlank((CharSequence)details.getTax()));
            return amountConditions && detailsConditions;
        }
        return false;
    }
}

