/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.payment.service.gateway;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.payment.PaymentTransactionType;
import org.broadleafcommerce.common.payment.PaymentType;
import org.broadleafcommerce.common.payment.dto.PaymentRequestDTO;
import org.broadleafcommerce.common.payment.dto.PaymentResponseDTO;
import org.broadleafcommerce.common.payment.service.AbstractPaymentGatewayWebResponseService;
import org.broadleafcommerce.common.payment.service.PaymentGatewayReportingService;
import org.broadleafcommerce.common.payment.service.PaymentGatewayWebResponsePrintService;
import org.broadleafcommerce.common.payment.service.PaymentGatewayWebResponseService;
import org.broadleafcommerce.common.vendor.service.exception.PaymentException;
import org.broadleafcommerce.payment.service.gateway.ExternalCallPayPalCheckoutService;
import org.broadleafcommerce.vendor.paypal.api.AgreementToken;
import org.broadleafcommerce.vendor.paypal.service.PayPalAgreementTokenService;
import org.broadleafcommerce.vendor.paypal.service.PayPalPaymentService;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalCheckoutPaymentGatewayType;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalExecuteAgreementTokenRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalExecuteAgreementTokenResponse;
import org.springframework.stereotype.Service;

@Service(value="blPayPalCheckoutWebResponseService")
public class PayPalCheckoutWebResponseServiceImpl
extends AbstractPaymentGatewayWebResponseService
implements PaymentGatewayWebResponseService {
    private static final Log LOG = LogFactory.getLog(PayPalCheckoutWebResponseServiceImpl.class);
    @Resource(name="blExternalCallPayPalCheckoutService")
    protected ExternalCallPayPalCheckoutService externalCallService;
    @Resource(name="blPaymentGatewayWebResponsePrintService")
    protected PaymentGatewayWebResponsePrintService webResponsePrintService;
    @Resource(name="blPayPalCheckoutReportingService")
    protected PaymentGatewayReportingService reportingService;
    @Resource(name="blPayPalPaymentService")
    protected PayPalPaymentService paymentService;
    @Resource(name="blPayPalAgreementTokenService")
    protected PayPalAgreementTokenService agreementTokenService;

    public PaymentResponseDTO translateWebResponse(HttpServletRequest request) throws PaymentException {
        boolean completeCheckout = false;
        if (request.getParameter("CheckoutComplete") != null) {
            completeCheckout = Boolean.valueOf(request.getParameter("CheckoutComplete"));
        }
        String paymentId = request.getParameter("paymentId");
        String payerId = request.getParameter("payerId");
        String token = request.getParameter("token");
        String billingToken = request.getParameter("billingToken");
        if (StringUtils.isNotBlank((CharSequence)billingToken)) {
            String billingAgreementId = this.agreementTokenService.getPayPalBillingAgreementIdFromCurrentOrder();
            PaymentRequestDTO requestDTO = this.agreementTokenService.getPaymentRequestForCurrentOrder();
            if (StringUtils.isBlank((CharSequence)billingAgreementId)) {
                AgreementToken agreementToken = new AgreementToken(billingToken);
                agreementToken = this.executeAgreementToken(agreementToken, requestDTO);
                PaymentResponseDTO responseDTO = new PaymentResponseDTO(PaymentType.THIRD_PARTY_ACCOUNT, PayPalCheckoutPaymentGatewayType.PAYPAL_CHECKOUT).paymentTransactionType(PaymentTransactionType.UNCONFIRMED);
                this.externalCallService.setCommonDetailsResponse(agreementToken, responseDTO, new Money(requestDTO.getTransactionTotal()), requestDTO.getOrderId(), completeCheckout);
                responseDTO.responseMap("BILLING_AGREEMENT_ID", agreementToken.getId());
                LOG.info((Object)("ResponseDTO created: " + ToStringBuilder.reflectionToString((Object)responseDTO, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE)));
                this.agreementTokenService.setPayPalAgreementTokenOnCurrentOrder(billingToken);
                this.agreementTokenService.setPayPalBillingAgreementIdOnCurrentOrder(agreementToken.getId());
                return responseDTO;
            }
            PaymentResponseDTO responseDTO = new PaymentResponseDTO(PaymentType.THIRD_PARTY_ACCOUNT, PayPalCheckoutPaymentGatewayType.PAYPAL_CHECKOUT).paymentTransactionType(PaymentTransactionType.UNCONFIRMED);
            this.externalCallService.setCommonDetailsResponse(null, responseDTO, new Money(requestDTO.getTransactionTotal()), requestDTO.getOrderId(), completeCheckout);
            responseDTO.responseMap("BILLING_AGREEMENT_ID", billingAgreementId);
            LOG.info((Object)("ResponseDTO created: " + ToStringBuilder.reflectionToString((Object)responseDTO, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE)));
            return responseDTO;
        }
        if (StringUtils.isNotBlank((CharSequence)token)) {
            throw new UnsupportedOperationException("Billing Agreements and Recurring Subscriptions created via the Payments API is not yet supported.");
        }
        PaymentRequestDTO requestDTO = new PaymentRequestDTO().additionalField("paymentId", (Object)paymentId).additionalField("payerId", (Object)payerId);
        PaymentResponseDTO responseDTO = this.reportingService.findDetailsByTransaction(requestDTO);
        responseDTO.responseMap("HTTP_REQUEST", this.webResponsePrintService.printRequest(request)).paymentTransactionType(PaymentTransactionType.UNCONFIRMED);
        this.paymentService.setPayPalPaymentIdOnCurrentOrder(paymentId);
        this.paymentService.setPayPalPayerIdOnCurrentOrder(payerId);
        return responseDTO;
    }

    protected AgreementToken executeAgreementToken(AgreementToken agreementToken, PaymentRequestDTO requestDTO) throws PaymentException {
        PayPalExecuteAgreementTokenResponse response = (PayPalExecuteAgreementTokenResponse)this.externalCallService.call(new PayPalExecuteAgreementTokenRequest(agreementToken, this.externalCallService.constructAPIContext(requestDTO)));
        return response.getAgreementToken();
    }
}

