/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.payment.service.gateway;

import com.paypal.api.payments.Amount;
import com.paypal.api.payments.Authorization;
import com.paypal.api.payments.Billing;
import com.paypal.api.payments.Capture;
import com.paypal.api.payments.DetailedRefund;
import com.paypal.api.payments.Error;
import com.paypal.api.payments.FundingInstrument;
import com.paypal.api.payments.ItemList;
import com.paypal.api.payments.Payer;
import com.paypal.api.payments.Payment;
import com.paypal.api.payments.PaymentExecution;
import com.paypal.api.payments.RefundRequest;
import com.paypal.api.payments.RelatedResources;
import com.paypal.api.payments.Sale;
import com.paypal.api.payments.Transaction;
import com.paypal.base.rest.PayPalRESTException;
import com.paypal.base.rest.PayPalResource;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.payment.PaymentTransactionType;
import org.broadleafcommerce.common.payment.PaymentType;
import org.broadleafcommerce.common.payment.dto.PaymentRequestDTO;
import org.broadleafcommerce.common.payment.dto.PaymentResponseDTO;
import org.broadleafcommerce.common.payment.service.AbstractPaymentGatewayTransactionService;
import org.broadleafcommerce.common.payment.service.PaymentGatewayTransactionService;
import org.broadleafcommerce.common.vendor.service.exception.PaymentException;
import org.broadleafcommerce.payment.service.gateway.ExternalCallPayPalCheckoutService;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalAuthorizationRetrievalRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalAuthorizationRetrievalResponse;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalAuthorizeRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalAuthorizeResponse;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalCaptureRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalCaptureResponse;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalCaptureRetrievalRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalCaptureRetrievalResponse;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalCheckoutPaymentGatewayType;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalCreatePaymentRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalCreatePaymentResponse;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalRefundRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalRefundResponse;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalSaleRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalSaleResponse;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalSaleRetrievalRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalSaleRetrievalResponse;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalVoidRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalVoidResponse;
import org.springframework.stereotype.Service;

@Service(value="blPayPalCheckoutTransactionService")
public class PayPalCheckoutTransactionServiceImpl
extends AbstractPaymentGatewayTransactionService
implements PaymentGatewayTransactionService {
    protected static final Log LOG = LogFactory.getLog(PayPalCheckoutTransactionServiceImpl.class);
    @Resource(name="blExternalCallPayPalCheckoutService")
    protected ExternalCallPayPalCheckoutService payPalCheckoutService;

    public PaymentResponseDTO authorize(PaymentRequestDTO paymentRequestDTO) throws PaymentException {
        PaymentResponseDTO responseDTO = new PaymentResponseDTO(PaymentType.THIRD_PARTY_ACCOUNT, PayPalCheckoutPaymentGatewayType.PAYPAL_CHECKOUT);
        try {
            PayPalResource auth = this.authorizePayment(paymentRequestDTO);
            if (auth instanceof Payment) {
                Payment payment = (Payment)auth;
                Transaction transaction = (Transaction)payment.getTransactions().get(0);
                if (transaction != null) {
                    Amount amount = transaction.getAmount();
                    responseDTO.successful(true).rawResponse(payment.toJSON()).paymentTransactionType(PaymentTransactionType.AUTHORIZE).responseMap("AUTHORIZATIONID", payment.getId()).amount(new Money(amount.getTotal(), amount.getCurrency()));
                }
            } else {
                Authorization authorization = (Authorization)auth;
                responseDTO.successful(true).rawResponse(authorization.toJSON()).paymentTransactionType(PaymentTransactionType.AUTHORIZE).responseMap("AUTHORIZATIONID", authorization.getId()).amount(new Money(authorization.getAmount().getTotal(), authorization.getAmount().getCurrency()));
            }
        }
        catch (PaymentException ex) {
            if (ex.getCause() instanceof PayPalRESTException) {
                PayPalRESTException restException = (PayPalRESTException)ex.getCause();
                responseDTO.successful(false).rawResponse(restException.toString()).paymentTransactionType(PaymentTransactionType.AUTHORIZE);
                this.populateErrorResponseMap(responseDTO, restException);
                return responseDTO;
            }
            throw ex;
        }
        return responseDTO;
    }

    public PaymentResponseDTO capture(PaymentRequestDTO paymentRequestDTO) throws PaymentException {
        PaymentResponseDTO responseDTO = new PaymentResponseDTO(PaymentType.THIRD_PARTY_ACCOUNT, PayPalCheckoutPaymentGatewayType.PAYPAL_CHECKOUT);
        try {
            Authorization auth = this.getAuthorization(paymentRequestDTO);
            Capture capture = this.capturePayment(paymentRequestDTO, auth);
            responseDTO.successful(true).rawResponse(capture.toJSON()).paymentTransactionType(PaymentTransactionType.CAPTURE).responseMap("CAPTUREID", capture.getId()).amount(new Money(capture.getAmount().getTotal(), capture.getAmount().getCurrency()));
        }
        catch (PaymentException ex) {
            if (ex.getCause() instanceof PayPalRESTException) {
                PayPalRESTException restException = (PayPalRESTException)ex.getCause();
                responseDTO.successful(false).rawResponse(restException.toString()).paymentTransactionType(PaymentTransactionType.CAPTURE);
                this.populateErrorResponseMap(responseDTO, restException);
                return responseDTO;
            }
            throw ex;
        }
        return responseDTO;
    }

    public PaymentResponseDTO authorizeAndCapture(PaymentRequestDTO paymentRequestDTO) throws PaymentException {
        PaymentResponseDTO responseDTO = new PaymentResponseDTO(PaymentType.THIRD_PARTY_ACCOUNT, PayPalCheckoutPaymentGatewayType.PAYPAL_CHECKOUT);
        try {
            PayPalResource sale = this.salePayment(paymentRequestDTO);
            if (sale instanceof Payment) {
                Payment payment = (Payment)sale;
                Transaction transaction = (Transaction)payment.getTransactions().get(0);
                Payer payer = payment.getPayer();
                if (transaction != null && payer != null) {
                    Amount amount = transaction.getAmount();
                    List transactions = payment.getTransactions();
                    String saleId = null;
                    if (transactions != null) {
                        for (Transaction tx : transactions) {
                            List relatedResources = tx.getRelatedResources();
                            if (relatedResources == null) continue;
                            for (RelatedResources rr : relatedResources) {
                                if (rr.getSale() == null) continue;
                                saleId = rr.getSale().getId();
                            }
                        }
                    }
                    String billingAgreementId = null;
                    if (payer.getFundingInstruments() != null) {
                        for (FundingInstrument fi : payer.getFundingInstruments()) {
                            if (fi.getBilling() == null) continue;
                            billingAgreementId = fi.getBilling().getBillingAgreementId();
                        }
                    }
                    String payerEmail = null;
                    String payerFirstName = null;
                    String payerLastName = null;
                    if (payer.getPayerInfo() != null) {
                        payerEmail = payer.getPayerInfo().getEmail();
                        payerFirstName = payer.getPayerInfo().getFirstName();
                        payerLastName = payer.getPayerInfo().getLastName();
                    }
                    responseDTO.successful(true).rawResponse(payment.toJSON()).paymentTransactionType(PaymentTransactionType.AUTHORIZE_AND_CAPTURE).responseMap("PAYMENTID", payment.getId()).responseMap("SALEID", saleId).responseMap("BILLING_AGREEMENT_ID", billingAgreementId).responseMap("PAYPAL_PAYER_INFO_EMAIL", payerEmail).responseMap("PAYPAL_PAYER_INFO_FIRST_NAME", payerFirstName).responseMap("PAYPAL_PAYER_INFO_LAST_NAME", payerLastName).amount(new Money(amount.getTotal(), amount.getCurrency()));
                }
            } else {
                Sale s = (Sale)sale;
                responseDTO.successful(true).rawResponse(sale.toJSON()).paymentTransactionType(PaymentTransactionType.AUTHORIZE_AND_CAPTURE).responseMap("SALEID", s.getId()).responseMap("BILLING_AGREEMENT_ID", s.getBillingAgreementId()).amount(new Money(s.getAmount().getTotal(), s.getAmount().getCurrency()));
            }
        }
        catch (PaymentException ex) {
            if (ex.getCause() instanceof PayPalRESTException) {
                PayPalRESTException restException = (PayPalRESTException)ex.getCause();
                responseDTO.successful(false).rawResponse(restException.toString()).paymentTransactionType(PaymentTransactionType.AUTHORIZE_AND_CAPTURE);
                this.populateErrorResponseMap(responseDTO, restException);
                return responseDTO;
            }
            throw ex;
        }
        return responseDTO;
    }

    public PaymentResponseDTO reverseAuthorize(PaymentRequestDTO paymentRequestDTO) throws PaymentException {
        PaymentResponseDTO responseDTO = new PaymentResponseDTO(PaymentType.THIRD_PARTY_ACCOUNT, PayPalCheckoutPaymentGatewayType.PAYPAL_CHECKOUT);
        try {
            Authorization auth = this.getAuthorization(paymentRequestDTO);
            auth = this.voidAuthorization(auth, paymentRequestDTO);
            responseDTO.successful(true).rawResponse(auth.toJSON()).paymentTransactionType(PaymentTransactionType.REVERSE_AUTH).amount(new Money(auth.getAmount().getTotal(), auth.getAmount().getCurrency()));
        }
        catch (PaymentException ex) {
            if (ex.getCause() instanceof PayPalRESTException) {
                PayPalRESTException restException = (PayPalRESTException)ex.getCause();
                responseDTO.successful(false).rawResponse(restException.toString()).paymentTransactionType(PaymentTransactionType.REVERSE_AUTH);
                this.populateErrorResponseMap(responseDTO, restException);
                return responseDTO;
            }
            throw ex;
        }
        return responseDTO;
    }

    public PaymentResponseDTO refund(PaymentRequestDTO paymentRequestDTO) throws PaymentException {
        PaymentResponseDTO responseDTO = new PaymentResponseDTO(PaymentType.THIRD_PARTY_ACCOUNT, PayPalCheckoutPaymentGatewayType.PAYPAL_CHECKOUT);
        try {
            Capture capture = null;
            Sale sale = null;
            if (this.getCaptureId(paymentRequestDTO) != null) {
                capture = this.getCapture(paymentRequestDTO);
            } else if (this.getSaleId(paymentRequestDTO) != null) {
                sale = this.getSale(paymentRequestDTO);
            }
            if (capture != null) {
                DetailedRefund detailRefund = this.refundPayment(paymentRequestDTO, capture);
                responseDTO.successful(true).rawResponse(detailRefund.toJSON()).paymentTransactionType(PaymentTransactionType.REFUND).responseMap("REFUNDID", detailRefund.getId()).responseMap("CAPTUREID", detailRefund.getCaptureId()).amount(new Money(detailRefund.getAmount().getTotal(), detailRefund.getAmount().getCurrency()));
                return responseDTO;
            }
            if (sale != null) {
                DetailedRefund detailRefund = this.refundPayment(paymentRequestDTO, sale);
                responseDTO.successful(true).rawResponse(detailRefund.toJSON()).paymentTransactionType(PaymentTransactionType.REFUND).responseMap("REFUNDID", detailRefund.getId()).responseMap("SALEID", detailRefund.getSaleId()).amount(new Money(detailRefund.getAmount().getTotal(), detailRefund.getAmount().getCurrency()));
                return responseDTO;
            }
        }
        catch (PaymentException ex) {
            if (ex.getCause() instanceof PayPalRESTException) {
                PayPalRESTException restException = (PayPalRESTException)ex.getCause();
                responseDTO.successful(false).rawResponse(restException.toString()).paymentTransactionType(PaymentTransactionType.REFUND);
                this.populateErrorResponseMap(responseDTO, restException);
                return responseDTO;
            }
            throw ex;
        }
        throw new PaymentException("Unable to perform refund. Unable to find corresponding capture or sale transaction.");
    }

    public PaymentResponseDTO voidPayment(PaymentRequestDTO paymentRequestDTO) throws PaymentException {
        PaymentResponseDTO responseDTO = new PaymentResponseDTO(PaymentType.THIRD_PARTY_ACCOUNT, PayPalCheckoutPaymentGatewayType.PAYPAL_CHECKOUT);
        try {
            Authorization auth = this.getAuthorization(paymentRequestDTO);
            auth = this.voidAuthorization(auth, paymentRequestDTO);
            responseDTO.successful(true).rawResponse(auth.toJSON()).paymentTransactionType(PaymentTransactionType.VOID).amount(new Money(auth.getAmount().getTotal(), auth.getAmount().getCurrency()));
        }
        catch (PaymentException ex) {
            if (ex.getCause() instanceof PayPalRESTException) {
                PayPalRESTException restException = (PayPalRESTException)ex.getCause();
                responseDTO.successful(false).rawResponse(restException.toString()).paymentTransactionType(PaymentTransactionType.VOID);
                this.populateErrorResponseMap(responseDTO, restException);
                return responseDTO;
            }
            throw ex;
        }
        return responseDTO;
    }

    protected Capture capturePayment(PaymentRequestDTO paymentRequestDTO, Authorization auth) throws PaymentException {
        Capture capture = new Capture();
        capture.setIsFinalCapture(Boolean.valueOf(true));
        Amount amount = new Amount();
        amount.setCurrency(paymentRequestDTO.getOrderCurrencyCode());
        amount.setTotal(paymentRequestDTO.getTransactionTotal());
        capture.setAmount(amount);
        PayPalCaptureResponse captureResponse = (PayPalCaptureResponse)this.payPalCheckoutService.call(new PayPalCaptureRequest(auth, capture, this.payPalCheckoutService.constructAPIContext(paymentRequestDTO)));
        return captureResponse.getCapture();
    }

    protected PayPalResource authorizePayment(PaymentRequestDTO paymentRequestDTO) throws PaymentException {
        Payment payment = new Payment();
        payment.setId(this.getPaymentId(paymentRequestDTO));
        payment.setTransactions(this.generateAuthorizeTransactions(paymentRequestDTO));
        PaymentExecution paymentExecution = new PaymentExecution();
        paymentExecution.setPayerId(this.getPayerId(paymentRequestDTO));
        if (this.isBillingAgreementRequest(paymentRequestDTO)) {
            payment.setIntent("authorize");
            payment.setPayer(this.generateAuthorizePayer(paymentRequestDTO));
            PayPalCreatePaymentResponse response = (PayPalCreatePaymentResponse)this.payPalCheckoutService.call(new PayPalCreatePaymentRequest(payment, this.payPalCheckoutService.constructAPIContext(paymentRequestDTO)));
            return response.getPayment();
        }
        PayPalAuthorizeResponse response = (PayPalAuthorizeResponse)this.payPalCheckoutService.call(new PayPalAuthorizeRequest(payment, paymentExecution, this.payPalCheckoutService.constructAPIContext(paymentRequestDTO)));
        return response.getAuthorization();
    }

    protected Payer generateAuthorizePayer(PaymentRequestDTO paymentRequestDTO) {
        if (this.isBillingAgreementRequest(paymentRequestDTO)) {
            return this.generateBillingAgreementPayer(paymentRequestDTO);
        }
        return null;
    }

    protected boolean isBillingAgreementRequest(PaymentRequestDTO paymentRequestDTO) {
        return paymentRequestDTO.getAdditionalFields().containsKey("BILLING_AGREEMENT_ID");
    }

    protected List<Transaction> generateAuthorizeTransactions(PaymentRequestDTO paymentRequestDTO) {
        return this.generateTransactions(paymentRequestDTO);
    }

    protected List<Transaction> generateTransactions(PaymentRequestDTO paymentRequestDTO) {
        Amount amount = this.payPalCheckoutService.getPayPalAmountFromOrder(paymentRequestDTO);
        Transaction transaction = new Transaction();
        transaction.setAmount(amount);
        transaction.setDescription(this.payPalCheckoutService.getConfiguration().getPaymentDescription());
        transaction.setCustom(paymentRequestDTO.getOrderId());
        ItemList itemList = this.payPalCheckoutService.getPayPalItemListFromOrder(paymentRequestDTO, true);
        if (itemList != null) {
            transaction.setItemList(itemList);
        }
        ArrayList<Transaction> transactions = new ArrayList<Transaction>();
        transactions.add(transaction);
        return transactions;
    }

    protected PayPalResource salePayment(PaymentRequestDTO paymentRequestDTO) throws PaymentException {
        Payment payment = new Payment();
        payment.setId(this.getPaymentId(paymentRequestDTO));
        payment.setTransactions(this.generateSaleTransactions(paymentRequestDTO));
        PaymentExecution paymentExecution = new PaymentExecution();
        paymentExecution.setPayerId(this.getPayerId(paymentRequestDTO));
        if (this.isBillingAgreementRequest(paymentRequestDTO)) {
            payment.setIntent("sale");
            payment.setPayer(this.generateSalePayer(paymentRequestDTO));
            PayPalCreatePaymentResponse response = (PayPalCreatePaymentResponse)this.payPalCheckoutService.call(new PayPalCreatePaymentRequest(payment, this.payPalCheckoutService.constructAPIContext(paymentRequestDTO)));
            return response.getPayment();
        }
        PayPalSaleResponse response = (PayPalSaleResponse)this.payPalCheckoutService.call(new PayPalSaleRequest(payment, paymentExecution, this.payPalCheckoutService.constructAPIContext(paymentRequestDTO)));
        return response.getSale();
    }

    protected Payer generateSalePayer(PaymentRequestDTO paymentRequestDTO) {
        if (this.isBillingAgreementRequest(paymentRequestDTO)) {
            return this.generateBillingAgreementPayer(paymentRequestDTO);
        }
        return null;
    }

    protected List<Transaction> generateSaleTransactions(PaymentRequestDTO paymentRequestDTO) {
        return this.generateTransactions(paymentRequestDTO);
    }

    protected Payer generateBillingAgreementPayer(PaymentRequestDTO paymentRequestDTO) {
        Payer payer = new Payer();
        payer.setPaymentMethod("paypal");
        ArrayList<FundingInstrument> fundingInstruments = new ArrayList<FundingInstrument>();
        FundingInstrument billingAgreement = new FundingInstrument();
        Billing billing = new Billing();
        billing.setBillingAgreementId((String)paymentRequestDTO.getAdditionalFields().get("BILLING_AGREEMENT_ID"));
        billingAgreement.setBilling(billing);
        fundingInstruments.add(billingAgreement);
        payer.setFundingInstruments(fundingInstruments);
        return payer;
    }

    protected Authorization voidAuthorization(Authorization auth, PaymentRequestDTO paymentRequestDTO) throws PaymentException {
        PayPalVoidResponse response = (PayPalVoidResponse)this.payPalCheckoutService.call(new PayPalVoidRequest(auth, this.payPalCheckoutService.constructAPIContext(paymentRequestDTO)));
        return response.getVoidedAuthorization();
    }

    protected DetailedRefund refundPayment(PaymentRequestDTO paymentRequestDTO, Capture capture) throws PaymentException {
        RefundRequest refund = new RefundRequest();
        Amount amount = new Amount();
        amount.setCurrency(paymentRequestDTO.getOrderCurrencyCode());
        amount.setTotal(paymentRequestDTO.getTransactionTotal());
        refund.setAmount(amount);
        PayPalRefundResponse response = (PayPalRefundResponse)this.payPalCheckoutService.call(new PayPalRefundRequest(refund, capture, this.payPalCheckoutService.constructAPIContext(paymentRequestDTO)));
        return response.getDetailedRefund();
    }

    protected DetailedRefund refundPayment(PaymentRequestDTO paymentRequestDTO, Sale sale) throws PaymentException {
        RefundRequest refund = new RefundRequest();
        Amount amount = new Amount();
        amount.setCurrency(paymentRequestDTO.getOrderCurrencyCode());
        amount.setTotal(paymentRequestDTO.getTransactionTotal());
        refund.setAmount(amount);
        PayPalRefundResponse response = (PayPalRefundResponse)this.payPalCheckoutService.call(new PayPalRefundRequest(refund, sale, this.payPalCheckoutService.constructAPIContext(paymentRequestDTO)));
        return response.getDetailedRefund();
    }

    protected Authorization getAuthorization(PaymentRequestDTO paymentRequestDTO) throws PaymentException {
        PayPalAuthorizationRetrievalResponse authResponse = (PayPalAuthorizationRetrievalResponse)this.payPalCheckoutService.call(new PayPalAuthorizationRetrievalRequest(this.getAuthorizationId(paymentRequestDTO), this.payPalCheckoutService.constructAPIContext(paymentRequestDTO)));
        return authResponse.getAuthorization();
    }

    protected Sale getSale(PaymentRequestDTO paymentRequestDTO) throws PaymentException {
        PayPalSaleRetrievalResponse saleResponse = (PayPalSaleRetrievalResponse)this.payPalCheckoutService.call(new PayPalSaleRetrievalRequest(this.getSaleId(paymentRequestDTO), this.payPalCheckoutService.constructAPIContext(paymentRequestDTO)));
        return saleResponse.getSale();
    }

    protected Capture getCapture(PaymentRequestDTO paymentRequestDTO) throws PaymentException {
        PayPalCaptureRetrievalResponse response = (PayPalCaptureRetrievalResponse)this.payPalCheckoutService.call(new PayPalCaptureRetrievalRequest(this.getCaptureId(paymentRequestDTO), this.payPalCheckoutService.constructAPIContext(paymentRequestDTO)));
        return response.getCapture();
    }

    protected String getPaymentId(PaymentRequestDTO paymentRequestDTO) {
        return (String)paymentRequestDTO.getAdditionalFields().get("PAYMENTID");
    }

    protected String getPayerId(PaymentRequestDTO paymentRequestDTO) {
        return (String)paymentRequestDTO.getAdditionalFields().get("PAYERID");
    }

    protected String getAuthorizationId(PaymentRequestDTO paymentRequestDTO) {
        return (String)paymentRequestDTO.getAdditionalFields().get("AUTHORIZATIONID");
    }

    protected String getSaleId(PaymentRequestDTO paymentRequestDTO) {
        return (String)paymentRequestDTO.getAdditionalFields().get("SALEID");
    }

    protected String getCaptureId(PaymentRequestDTO paymentRequestDTO) {
        return (String)paymentRequestDTO.getAdditionalFields().get("CAPTUREID");
    }

    protected void populateErrorResponseMap(PaymentResponseDTO responseDTO, PayPalRESTException restException) {
        Error error = restException.getDetails();
        if (error != null) {
            responseDTO.responseMap("EXCEPTION_NAME", error.getName()).responseMap("EXCEPTION_MESSAGE", error.getMessage()).responseMap("EXCEPTION_DEBUG_ID", error.getDebugId());
        }
    }
}

