/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.paypal.service.payment.type;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.broadleafcommerce.common.BroadleafEnumerationType;

public class PayPalPaymentStatusType
implements Serializable,
BroadleafEnumerationType {
    private static final long serialVersionUID = 1L;
    private static final Map<String, PayPalPaymentStatusType> TYPES = new HashMap<String, PayPalPaymentStatusType>();
    public static final PayPalPaymentStatusType NONE = new PayPalPaymentStatusType("None", "None");
    public static final PayPalPaymentStatusType CANCELEDREVERSAL = new PayPalPaymentStatusType("Canceled-Reversal", "Canceled-Reversal");
    public static final PayPalPaymentStatusType COMPLETED = new PayPalPaymentStatusType("Completed", "Completed");
    public static final PayPalPaymentStatusType DENIED = new PayPalPaymentStatusType("Denied", "Denied");
    public static final PayPalPaymentStatusType EXPIRED = new PayPalPaymentStatusType("Expired", "Expired");
    public static final PayPalPaymentStatusType FAILED = new PayPalPaymentStatusType("Failed", "Failed");
    public static final PayPalPaymentStatusType INPROGRESS = new PayPalPaymentStatusType("In-Progress", "In-Progress");
    public static final PayPalPaymentStatusType PARTIALLYREFUNDED = new PayPalPaymentStatusType("Partially-Refunded", "Partially-Refunded");
    public static final PayPalPaymentStatusType PENDING = new PayPalPaymentStatusType("Pending", "Pending");
    public static final PayPalPaymentStatusType REFUNDED = new PayPalPaymentStatusType("Refunded", "Refunded");
    public static final PayPalPaymentStatusType REVERSED = new PayPalPaymentStatusType("Reversed", "Reversed");
    public static final PayPalPaymentStatusType PROCESSED = new PayPalPaymentStatusType("Processed", "Processed");
    public static final PayPalPaymentStatusType VOIDED = new PayPalPaymentStatusType("Voided", "Voided");
    public static final PayPalPaymentStatusType COMPLETEDFUNDSHELD = new PayPalPaymentStatusType("Completed-Funds-Held", "Completed-Funds-Held");
    private String type;
    private String friendlyType;

    public static PayPalPaymentStatusType getInstance(String type) {
        return TYPES.get(type);
    }

    public PayPalPaymentStatusType() {
    }

    public PayPalPaymentStatusType(String type, String friendlyType) {
        this.friendlyType = friendlyType;
        this.setType(type);
    }

    public String getType() {
        return this.type;
    }

    public String getFriendlyType() {
        return this.friendlyType;
    }

    private void setType(String type) {
        this.type = type;
        if (!TYPES.containsKey(type)) {
            TYPES.put(type, this);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PayPalPaymentStatusType other = (PayPalPaymentStatusType)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

