/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.paypal.service.payment;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Currency;
import org.apache.commons.lang.StringUtils;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalResponseGenerator;
import org.broadleafcommerce.vendor.paypal.service.payment.message.ErrorCheckable;
import org.broadleafcommerce.vendor.paypal.service.payment.message.PayPalErrorResponse;
import org.broadleafcommerce.vendor.paypal.service.payment.message.PayPalRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.message.PayPalResponse;
import org.broadleafcommerce.vendor.paypal.service.payment.message.details.PayPalDetailsResponse;
import org.broadleafcommerce.vendor.paypal.service.payment.message.details.PayPalPayerAddress;
import org.broadleafcommerce.vendor.paypal.service.payment.message.details.PayPalPaymentDetails;
import org.broadleafcommerce.vendor.paypal.service.payment.message.details.PayPalPaymentItemDetails;
import org.broadleafcommerce.vendor.paypal.service.payment.message.payment.PayPalPaymentInfo;
import org.broadleafcommerce.vendor.paypal.service.payment.message.payment.PayPalPaymentRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.message.payment.PayPalPaymentResponse;
import org.broadleafcommerce.vendor.paypal.service.payment.message.payment.PayPalRefundInfo;
import org.broadleafcommerce.vendor.paypal.service.payment.type.PayPalAddressStatusType;
import org.broadleafcommerce.vendor.paypal.service.payment.type.PayPalCheckoutStatusType;
import org.broadleafcommerce.vendor.paypal.service.payment.type.PayPalHoldDecisionType;
import org.broadleafcommerce.vendor.paypal.service.payment.type.PayPalMethodType;
import org.broadleafcommerce.vendor.paypal.service.payment.type.PayPalPayerStatusType;
import org.broadleafcommerce.vendor.paypal.service.payment.type.PayPalPaymentStatusType;
import org.broadleafcommerce.vendor.paypal.service.payment.type.PayPalPaymentType;
import org.broadleafcommerce.vendor.paypal.service.payment.type.PayPalPendingReasonType;
import org.broadleafcommerce.vendor.paypal.service.payment.type.PayPalReasonCodeType;
import org.broadleafcommerce.vendor.paypal.service.payment.type.PayPalRefundPendingReasonType;
import org.broadleafcommerce.vendor.paypal.service.payment.type.PayPalRefundStatusType;

public class PayPalResponseGeneratorImpl
implements PayPalResponseGenerator {
    protected String userRedirectUrl;
    protected SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    @Override
    public PayPalResponse buildResponse(String response, PayPalRequest paymentRequest) {
        PayPalResponse payPalResponse;
        if (paymentRequest.getMethodType() == PayPalMethodType.CHECKOUT || paymentRequest.getMethodType() == PayPalMethodType.AUTHORIZATION) {
            payPalResponse = this.buildCheckoutResponse(response, (PayPalPaymentRequest)paymentRequest);
        } else if (paymentRequest.getMethodType() == PayPalMethodType.DETAILS) {
            payPalResponse = this.buildDetailsResponse(response);
        } else if (paymentRequest.getMethodType() == PayPalMethodType.PROCESS) {
            payPalResponse = this.buildCheckoutResponse(response, (PayPalPaymentRequest)paymentRequest);
            this.addPaymentInfoData(response, (PayPalPaymentResponse)payPalResponse);
        } else {
            payPalResponse = this.buildCheckoutResponse(response, (PayPalPaymentRequest)paymentRequest);
            this.addRefundData(response, (PayPalPaymentResponse)payPalResponse);
            this.addCapturePaymentInfoData(response, (PayPalPaymentResponse)payPalResponse);
        }
        return payPalResponse;
    }

    protected PayPalDetailsResponse buildDetailsResponse(String rawResponse) {
        String paymentRequestTotalTax;
        String paymentRequestShippingDiscount;
        String paymentRequestShippingTotal;
        String paymentRequestItemTotal;
        PayPalDetailsResponse response = new PayPalDetailsResponse();
        response.setResponseToken(this.getResponseValue(rawResponse, "TOKEN"));
        response.setPhoneNumber(this.getResponseValue(rawResponse, "PHONENUM"));
        String payPalAdjustment = this.getResponseValue(rawResponse, "PAYPALADJUSTMENT");
        if (!StringUtils.isEmpty((String)payPalAdjustment)) {
            response.setPayPalAdjustment(new Money(payPalAdjustment, Money.defaultCurrency()));
        }
        response.setNote(this.getResponseValue(rawResponse, "NOTE"));
        String checkoutStatus = this.getResponseValue(rawResponse, "CHECKOUTSTATUS");
        if (!StringUtils.isEmpty((String)checkoutStatus)) {
            response.setCheckoutStatusType(PayPalCheckoutStatusType.getInstance(checkoutStatus));
        }
        response.setEmailAddress(this.getResponseValue(rawResponse, "EMAIL"));
        response.setPayerId(this.getResponseValue(rawResponse, "PAYERID"));
        String payerStatus = this.getResponseValue(rawResponse, "PAYERSTATUS");
        if (!StringUtils.isEmpty((String)payerStatus)) {
            response.setPayerStatus(PayPalPayerStatusType.getInstance(payerStatus));
        }
        response.setCountryCode(this.getResponseValue(rawResponse, "COUNTRYCODE"));
        response.setBusiness(this.getResponseValue(rawResponse, "BUSINESS"));
        response.setPayerSalutation(this.getResponseValue(rawResponse, "SALUTATION"));
        response.setPayerFirstName(this.getResponseValue(rawResponse, "FIRSTNAME"));
        response.setPayerLastName(this.getResponseValue(rawResponse, "LASTNAME"));
        response.setPayerMiddleName(this.getResponseValue(rawResponse, "MIDDLENAME"));
        response.setPayerSuffix(this.getResponseValue(rawResponse, "SUFFIX"));
        boolean eof = false;
        int number = 0;
        while (!eof) {
            String street = this.getResponseValue(rawResponse, this.replaceNumericBoundProperty("PAYMENTREQUEST_n_SHIPTOSTREET", new Integer[]{number}, new String[]{"n"}));
            if (!StringUtils.isEmpty((String)street)) {
                PayPalPayerAddress address = new PayPalPayerAddress();
                address.setStreet(street);
                address.setName(this.getResponseValue(rawResponse, this.replaceNumericBoundProperty("PAYMENTREQUEST_n_SHIPTONAME", new Integer[]{number}, new String[]{"n"})));
                address.setStreet2(this.getResponseValue(rawResponse, this.replaceNumericBoundProperty("PAYMENTREQUEST_n_SHIPTOSTREET2", new Integer[]{number}, new String[]{"n"})));
                address.setCity(this.getResponseValue(rawResponse, this.replaceNumericBoundProperty("PAYMENTREQUEST_n_SHIPTOCITY", new Integer[]{number}, new String[]{"n"})));
                address.setState(this.getResponseValue(rawResponse, this.replaceNumericBoundProperty("PAYMENTREQUEST_n_SHIPTOSTATE", new Integer[]{number}, new String[]{"n"})));
                address.setZip(this.getResponseValue(rawResponse, this.replaceNumericBoundProperty("PAYMENTREQUEST_n_SHIPTOZIP", new Integer[]{number}, new String[]{"n"})));
                address.setCountryCode(this.getResponseValue(rawResponse, this.replaceNumericBoundProperty("PAYMENTREQUEST_n_SHIPTOCOUNTRYCODE", new Integer[]{number}, new String[]{"n"})));
                address.setPhoneNumber(this.getResponseValue(rawResponse, this.replaceNumericBoundProperty("PAYMENTREQUEST_n_SHIPTOPHONENUM", new Integer[]{number}, new String[]{"n"})));
                String addressStatus = this.getResponseValue(rawResponse, this.replaceNumericBoundProperty("PAYMENTREQUEST_n_ADDRESSSTATUS", new Integer[]{number}, new String[]{"n"}));
                if (!StringUtils.isEmpty((String)addressStatus)) {
                    address.setAddressStatus(PayPalAddressStatusType.getInstance(addressStatus));
                }
                response.getAddresses().add(address);
            } else {
                eof = true;
            }
            ++number;
        }
        PayPalPaymentDetails paymentDetails = new PayPalPaymentDetails();
        String currencyCode = this.getResponseValue(rawResponse, this.replaceNumericBoundProperty("PAYMENTREQUEST_n_CURRENCYCODE", new Integer[]{0}, new String[]{"n"}));
        paymentDetails.setCurrencyCode(currencyCode);
        String paymentRequestAmount = this.getResponseValue(rawResponse, this.replaceNumericBoundProperty("PAYMENTREQUEST_n_AMT", new Integer[]{0}, new String[]{"n"}));
        if (!StringUtils.isEmpty((String)paymentRequestAmount)) {
            paymentDetails.setAmount(new Money(paymentRequestAmount, Currency.getInstance(currencyCode)));
        }
        if (!StringUtils.isEmpty((String)(paymentRequestItemTotal = this.getResponseValue(rawResponse, this.replaceNumericBoundProperty("PAYMENTREQUEST_n_ITEMAMT", new Integer[]{0}, new String[]{"n"}))))) {
            paymentDetails.setItemTotal(new Money(paymentRequestItemTotal, Currency.getInstance(currencyCode)));
        }
        if (!StringUtils.isEmpty((String)(paymentRequestShippingTotal = this.getResponseValue(rawResponse, this.replaceNumericBoundProperty("PAYMENTREQUEST_n_SHIPPINGAMT", new Integer[]{0}, new String[]{"n"}))))) {
            paymentDetails.setShippingTotal(new Money(paymentRequestShippingTotal, Currency.getInstance(currencyCode)));
        }
        if (!StringUtils.isEmpty((String)(paymentRequestShippingDiscount = this.getResponseValue(rawResponse, this.replaceNumericBoundProperty("PAYMENTREQUEST_n_SHIPDISCAMT", new Integer[]{0}, new String[]{"n"}))))) {
            paymentDetails.setShippingDiscount(new Money(paymentRequestShippingDiscount, Currency.getInstance(currencyCode)));
        }
        if (!StringUtils.isEmpty((String)(paymentRequestTotalTax = this.getResponseValue(rawResponse, this.replaceNumericBoundProperty("PAYMENTREQUEST_n_TAXAMT", new Integer[]{0}, new String[]{"n"}))))) {
            paymentDetails.setTotalTax(new Money(paymentRequestTotalTax, Currency.getInstance(currencyCode)));
        }
        paymentDetails.setReferenceNumber(this.getResponseValue(rawResponse, this.replaceNumericBoundProperty("PAYMENTREQUEST_n_INVNUM", new Integer[]{0}, new String[]{"n"})));
        paymentDetails.setTransactionId(this.getResponseValue(rawResponse, this.replaceNumericBoundProperty("PAYMENTREQUEST_n_TRANSACTIONID", new Integer[]{0}, new String[]{"n"})));
        paymentDetails.setPaymentMethod(this.getResponseValue(rawResponse, this.replaceNumericBoundProperty("PAYMENTREQUEST_n_ALLOWEDPAYMENTMETHOD", new Integer[]{0}, new String[]{"n"})));
        paymentDetails.setPaymentRequestId(this.getResponseValue(rawResponse, this.replaceNumericBoundProperty("PAYMENTREQUEST_n_PAYMENTREQUESTID", new Integer[]{0}, new String[]{"n"})));
        response.setPaymentDetails(paymentDetails);
        eof = false;
        number = 0;
        while (!eof) {
            String paymentRequestItemName = this.getResponseValue(rawResponse, this.replaceNumericBoundProperty("L_PAYMENTREQUEST_n_NAMEm", new Integer[]{0, number}, new String[]{"n", "m"}));
            if (!StringUtils.isEmpty((String)paymentRequestItemName)) {
                String paymentRequestItemTax;
                PayPalPaymentItemDetails itemDetails = new PayPalPaymentItemDetails();
                itemDetails.setName(paymentRequestItemName);
                itemDetails.setDescription(this.getResponseValue(rawResponse, this.replaceNumericBoundProperty("L_PAYMENTREQUEST_n_DESCm", new Integer[]{0, number}, new String[]{"n", "m"})));
                String paymentRequestItemAmount = this.getResponseValue(rawResponse, this.replaceNumericBoundProperty("L_PAYMENTREQUEST_n_AMTm", new Integer[]{0, number}, new String[]{"n", "m"}));
                if (!StringUtils.isEmpty((String)paymentRequestItemAmount)) {
                    itemDetails.setAmount(new Money(paymentRequestItemAmount, Currency.getInstance(currencyCode)));
                }
                itemDetails.setItemNumber(this.getResponseValue(rawResponse, this.replaceNumericBoundProperty("L_PAYMENTREQUEST_n_NUMBERm", new Integer[]{0, number}, new String[]{"n", "m"})));
                String paymentRequestItemQuantity = this.getResponseValue(rawResponse, this.replaceNumericBoundProperty("L_PAYMENTREQUEST_n_QTYm", new Integer[]{0, number}, new String[]{"n", "m"}));
                if (!StringUtils.isEmpty((String)paymentRequestItemQuantity)) {
                    itemDetails.setQuantity(Integer.valueOf(paymentRequestItemQuantity));
                }
                if (!StringUtils.isEmpty((String)(paymentRequestItemTax = this.getResponseValue(rawResponse, this.replaceNumericBoundProperty("L_PAYMENTREQUEST_n_TAXAMTm", new Integer[]{0, number}, new String[]{"n", "m"}))))) {
                    itemDetails.setTax(new Money(paymentRequestItemTax, Currency.getInstance(currencyCode)));
                }
                paymentDetails.getItemDetails().add(itemDetails);
            } else {
                eof = true;
            }
            ++number;
        }
        this.populateDetailErrors(rawResponse, response);
        return response;
    }

    protected void populateDetailErrors(String rawResponse, ErrorCheckable response) {
        boolean eof = false;
        int errorNumber = 0;
        while (!eof) {
            String errorCode = this.getResponseValue(rawResponse, this.replaceNumericBoundProperty("PAYMENTREQUEST_n_ERRORCODE", new Integer[]{errorNumber}, new String[]{"n"}));
            if (errorCode != null) {
                PayPalErrorResponse errorResponse = new PayPalErrorResponse();
                errorResponse.setErrorCode(errorCode);
                errorResponse.setShortMessage(this.getResponseValue(rawResponse, this.replaceNumericBoundProperty("PAYMENTREQUEST_n_SHORTMESSAGE", new Integer[]{errorNumber}, new String[]{"n"})));
                errorResponse.setLongMessage(this.getResponseValue(rawResponse, this.replaceNumericBoundProperty("PAYMENTREQUEST_n_LONGMESSAGE", new Integer[]{errorNumber}, new String[]{"n"})));
                errorResponse.setSeverityCode(this.getResponseValue(rawResponse, this.replaceNumericBoundProperty("PAYMENTREQUEST_n_SEVERITYCODE", new Integer[]{errorNumber}, new String[]{"n"})));
                errorResponse.setAck(this.getResponseValue(rawResponse, this.replaceNumericBoundProperty("PAYMENTREQUEST_n_ACK", new Integer[]{errorNumber}, new String[]{"n"})));
                response.getErrorResponses().add(errorResponse);
            } else {
                eof = true;
            }
            ++errorNumber;
        }
    }

    protected void addRefundData(String rawResponse, PayPalPaymentResponse response) {
        String pendingReason;
        String totalRefundAmount;
        String netRefundAmount;
        String grossRefundAmount;
        PayPalRefundInfo refundInfo = new PayPalRefundInfo();
        response.setRefundInfo(refundInfo);
        String currencyCode = this.getResponseValue(rawResponse, "CURRENCYCODE");
        refundInfo.setCurrencyCode(currencyCode);
        refundInfo.setRefundTransactionId(this.getResponseValue(rawResponse, "REFUNDTRANSACTIONID"));
        String feeRefundAmount = this.getResponseValue(rawResponse, "FEEREFUNDAMT");
        if (!StringUtils.isEmpty((String)feeRefundAmount)) {
            refundInfo.setFeeRefundAmount(new Money(feeRefundAmount, Currency.getInstance(currencyCode)));
        }
        if (!StringUtils.isEmpty((String)(grossRefundAmount = this.getResponseValue(rawResponse, "GROSSREFUNDAMT")))) {
            refundInfo.setGrossRefundAmount(new Money(grossRefundAmount, Currency.getInstance(currencyCode)));
        }
        if (!StringUtils.isEmpty((String)(netRefundAmount = this.getResponseValue(rawResponse, "NETREFUNDAMT")))) {
            refundInfo.setNetRefundAmount(new Money(netRefundAmount, Currency.getInstance(currencyCode)));
        }
        if (!StringUtils.isEmpty((String)(totalRefundAmount = this.getResponseValue(rawResponse, "TOTALREFUNDEDAMT")))) {
            refundInfo.setTotalRefundAmount(new Money(totalRefundAmount, Currency.getInstance(currencyCode)));
        }
        refundInfo.setRefundInfo(this.getResponseValue(rawResponse, "REFUNDINFO"));
        String refundStatus = this.getResponseValue(rawResponse, "REFUNDSTATUS");
        if (!StringUtils.isEmpty((String)refundStatus)) {
            refundInfo.setRefundStatusType(PayPalRefundStatusType.getInstance(refundStatus));
        }
        if (!StringUtils.isEmpty((String)(pendingReason = this.getResponseValue(rawResponse, "PENDINGREASON")))) {
            refundInfo.setPendingReasonType(PayPalRefundPendingReasonType.getInstance(pendingReason));
        }
    }

    protected void addCapturePaymentInfoData(String rawResponse, PayPalPaymentResponse response) {
        String pendingReasonType;
        String paymentStatusType;
        String exchangeRate;
        String taxAmount;
        String settleAmount;
        String feeAmount;
        String amount;
        String orderTime;
        PayPalPaymentInfo paymentInfo = new PayPalPaymentInfo();
        response.setPaymentInfo(paymentInfo);
        String currencyCode = this.getResponseValue(rawResponse, "CURRENCYCODE");
        paymentInfo.setCurrencyCode(currencyCode);
        paymentInfo.setTransactionId(this.getResponseValue(rawResponse, "TRANSACTIONID"));
        paymentInfo.setParentTransactionId(this.getResponseValue(rawResponse, "PARENTTRANSACTIONID"));
        paymentInfo.setReceiptId(this.getResponseValue(rawResponse, "RECEIPTID"));
        String paymentType = this.getResponseValue(rawResponse, "PAYMENTTYPE");
        if (!StringUtils.isEmpty((String)paymentType)) {
            paymentInfo.setPaymentType(PayPalPaymentType.getInstance(paymentType));
        }
        if (!StringUtils.isEmpty((String)(orderTime = this.getResponseValue(rawResponse, "ORDERTIME")))) {
            try {
                paymentInfo.setOrderTime(this.dateFormat.parse(orderTime));
            }
            catch (ParseException e) {
                throw new RuntimeException("Unable to parse the date string (" + orderTime + ")");
            }
        }
        if (!StringUtils.isEmpty((String)(amount = this.getResponseValue(rawResponse, "AMT")))) {
            paymentInfo.setTotalAmount(new Money(amount, Currency.getInstance(currencyCode)));
        }
        if (!StringUtils.isEmpty((String)(feeAmount = this.getResponseValue(rawResponse, "FEEAMT")))) {
            paymentInfo.setFeeAmount(new Money(feeAmount, Currency.getInstance(currencyCode)));
        }
        if (!StringUtils.isEmpty((String)(settleAmount = this.getResponseValue(rawResponse, "SETTLEAMT")))) {
            paymentInfo.setSettleAmount(new Money(settleAmount, Currency.getInstance(currencyCode)));
        }
        if (!StringUtils.isEmpty((String)(taxAmount = this.getResponseValue(rawResponse, "TAXAMT")))) {
            paymentInfo.setTaxAmount(new Money(taxAmount, Currency.getInstance(currencyCode)));
        }
        if (!StringUtils.isEmpty((String)(exchangeRate = this.getResponseValue(rawResponse, "EXCHANGERATE")))) {
            paymentInfo.setExchangeRate(new BigDecimal(exchangeRate));
        }
        if (!StringUtils.isEmpty((String)(paymentStatusType = this.getResponseValue(rawResponse, "PAYMENTSTATUS")))) {
            paymentInfo.setPaymentStatusType(PayPalPaymentStatusType.getInstance(paymentStatusType));
        }
        if (!StringUtils.isEmpty((String)(pendingReasonType = this.getResponseValue(rawResponse, "PENDINGREASON")))) {
            paymentInfo.setPendingReasonType(PayPalPendingReasonType.getInstance(pendingReasonType));
        }
    }

    protected void addPaymentInfoData(String rawResponse, PayPalPaymentResponse response) {
        String holdDecisionType;
        String reasonCodeType;
        String pendingReasonType;
        String paymentStatusType;
        String exchangeRate;
        String taxAmount;
        String settleAmount;
        String feeAmount;
        String amount;
        String orderTime;
        PayPalPaymentInfo paymentInfo = new PayPalPaymentInfo();
        response.setPaymentInfo(paymentInfo);
        String currencyCode = this.getResponseValue(rawResponse, this.replaceNumericBoundProperty("PAYMENTINFO_n_CURRENCYCODE", new Integer[]{0}, new String[]{"n"}));
        paymentInfo.setCurrencyCode(currencyCode);
        paymentInfo.setTransactionId(this.getResponseValue(rawResponse, this.replaceNumericBoundProperty("PAYMENTINFO_n_TRANSACTIONID", new Integer[]{0}, new String[]{"n"})));
        String paymentType = this.getResponseValue(rawResponse, "PAYMENTINFO_n_PAYMENTTYPE");
        if (!StringUtils.isEmpty((String)paymentType)) {
            paymentInfo.setPaymentType(PayPalPaymentType.getInstance(paymentType));
        }
        if (!StringUtils.isEmpty((String)(orderTime = this.getResponseValue(rawResponse, this.replaceNumericBoundProperty("PAYMENTINFO_n_ORDERTIME", new Integer[]{0}, new String[]{"n"}))))) {
            try {
                paymentInfo.setOrderTime(this.dateFormat.parse(orderTime));
            }
            catch (ParseException e) {
                throw new RuntimeException("Unable to parse the date string (" + orderTime + ")");
            }
        }
        if (!StringUtils.isEmpty((String)(amount = this.getResponseValue(rawResponse, this.replaceNumericBoundProperty("PAYMENTINFO_n_AMT", new Integer[]{0}, new String[]{"n"}))))) {
            paymentInfo.setTotalAmount(new Money(amount, Currency.getInstance(currencyCode)));
        }
        if (!StringUtils.isEmpty((String)(feeAmount = this.getResponseValue(rawResponse, this.replaceNumericBoundProperty("PAYMENTINFO_n_FEEAMT", new Integer[]{0}, new String[]{"n"}))))) {
            paymentInfo.setFeeAmount(new Money(feeAmount, Currency.getInstance(currencyCode)));
        }
        if (!StringUtils.isEmpty((String)(settleAmount = this.getResponseValue(rawResponse, this.replaceNumericBoundProperty("PAYMENTINFO_n_SETTLEAMT", new Integer[]{0}, new String[]{"n"}))))) {
            paymentInfo.setSettleAmount(new Money(settleAmount, Currency.getInstance(currencyCode)));
        }
        if (!StringUtils.isEmpty((String)(taxAmount = this.getResponseValue(rawResponse, this.replaceNumericBoundProperty("PAYMENTINFO_n_TAXAMT", new Integer[]{0}, new String[]{"n"}))))) {
            paymentInfo.setTaxAmount(new Money(taxAmount, Currency.getInstance(currencyCode)));
        }
        if (!StringUtils.isEmpty((String)(exchangeRate = this.getResponseValue(rawResponse, this.replaceNumericBoundProperty("PAYMENTINFO_n_EXCHANGERATE", new Integer[]{0}, new String[]{"n"}))))) {
            paymentInfo.setExchangeRate(new BigDecimal(exchangeRate));
        }
        if (!StringUtils.isEmpty((String)(paymentStatusType = this.getResponseValue(rawResponse, this.replaceNumericBoundProperty("PAYMENTINFO_n_PAYMENTSTATUS", new Integer[]{0}, new String[]{"n"}))))) {
            paymentInfo.setPaymentStatusType(PayPalPaymentStatusType.getInstance(paymentStatusType));
        }
        if (!StringUtils.isEmpty((String)(pendingReasonType = this.getResponseValue(rawResponse, this.replaceNumericBoundProperty("PAYMENTINFO_n_PENDINGREASON", new Integer[]{0}, new String[]{"n"}))))) {
            paymentInfo.setPendingReasonType(PayPalPendingReasonType.getInstance(pendingReasonType));
        }
        if (!StringUtils.isEmpty((String)(reasonCodeType = this.getResponseValue(rawResponse, this.replaceNumericBoundProperty("PAYMENTINFO_n_REASONCODE", new Integer[]{0}, new String[]{"n"}))))) {
            paymentInfo.setReasonCodeType(PayPalReasonCodeType.getInstance(reasonCodeType));
        }
        if (!StringUtils.isEmpty((String)(holdDecisionType = this.getResponseValue(rawResponse, this.replaceNumericBoundProperty("PAYMENTINFO_n_HOLDDECISION", new Integer[]{0}, new String[]{"n"}))))) {
            paymentInfo.setHoldDecisionType(PayPalHoldDecisionType.getInstance(holdDecisionType));
        }
        this.populateDetailErrors(rawResponse, response);
    }

    protected PayPalPaymentResponse buildCheckoutResponse(String rawResponse, PayPalPaymentRequest paymentRequest) {
        PayPalPaymentResponse response = new PayPalPaymentResponse();
        response.setTransactionType(paymentRequest.getTransactionType());
        response.setMethodType(paymentRequest.getMethodType());
        response.setCorrelationId(this.getResponseValue(rawResponse, "CORRELATIONID"));
        String ack = this.getResponseValue(rawResponse, "ACK");
        response.setAck(ack);
        if (ack.toLowerCase().equals("success")) {
            response.setErrorDetected(false);
            response.setSuccessful(true);
            response.setResponseToken(this.getResponseValue(rawResponse, "TOKEN"));
        } else if (ack.toLowerCase().equals("successwithwarnings")) {
            response.setSuccessful(true);
            response.setErrorDetected(true);
            response.setResponseToken(this.getResponseValue(rawResponse, "TOKEN"));
        } else {
            response.setSuccessful(false);
            response.setErrorDetected(true);
        }
        if (response.isErrorDetected()) {
            boolean eof = false;
            int errorNumber = 0;
            while (!eof) {
                String errorCode = this.getResponseValue(rawResponse, this.replaceNumericBoundProperty("L_ERRORCODEn", new Integer[]{errorNumber}, new String[]{"n"}));
                if (errorCode != null) {
                    PayPalErrorResponse errorResponse = new PayPalErrorResponse();
                    errorResponse.setErrorCode(errorCode);
                    errorResponse.setShortMessage(this.getResponseValue(rawResponse, this.replaceNumericBoundProperty("L_SHORTMESSAGEn", new Integer[]{errorNumber}, new String[]{"n"})));
                    errorResponse.setLongMessage(this.getResponseValue(rawResponse, this.replaceNumericBoundProperty("L_LONGMESSAGEn", new Integer[]{errorNumber}, new String[]{"n"})));
                    errorResponse.setSeverityCode(this.getResponseValue(rawResponse, this.replaceNumericBoundProperty("L_SEVERITYCODEn", new Integer[]{errorNumber}, new String[]{"n"})));
                    response.getErrorResponses().add(errorResponse);
                } else {
                    eof = true;
                }
                ++errorNumber;
            }
            errorNumber = 0;
            eof = false;
            while (!eof) {
                String passThroughErrorName = this.getResponseValue(rawResponse, this.replaceNumericBoundProperty("L_ERRORPARAMIDn", new Integer[]{errorNumber}, new String[]{"n"}));
                if (passThroughErrorName != null) {
                    response.getPassThroughErrors().put(passThroughErrorName, this.getResponseValue(rawResponse, this.replaceNumericBoundProperty("L_ERRORPARAMVALUEn", new Integer[]{errorNumber}, new String[]{"n"})));
                } else {
                    eof = true;
                }
                ++errorNumber;
            }
        }
        response.setUserRedirectUrl(this.getUserRedirectUrl() + "?cmd=_express-checkout&token=" + response.getResponseToken());
        return response;
    }

    protected String replaceNumericBoundProperty(String property, Integer[] number, String[] positions) {
        int counter = 0;
        for (String position : positions) {
            int pos = property.indexOf(position);
            if (pos < 0) {
                throw new IllegalArgumentException("Property does not contain the specified position value (" + position + ")");
            }
            String newValue = String.valueOf(number[counter]);
            property = property.substring(0, pos) + newValue + property.substring(pos + position.length(), property.length());
            ++counter;
        }
        return property;
    }

    protected String getResponseValue(String resp, String valueName) {
        try {
            int keyBegin = resp.indexOf(valueName);
            if (keyBegin >= 0) {
                int tokenBegin = keyBegin + valueName.length() + 1;
                int tokenEnd = resp.indexOf(38, tokenBegin);
                if (tokenEnd < 0) {
                    tokenEnd = resp.length();
                }
                return URLDecoder.decode(resp.substring(tokenBegin, tokenEnd), "UTF-8");
            }
            return null;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getUserRedirectUrl() {
        return this.userRedirectUrl;
    }

    @Override
    public void setUserRedirectUrl(String userRedirectUrl) {
        this.userRedirectUrl = userRedirectUrl;
    }
}

