/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.paypal.service.payment;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.NameValuePair;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalRequestGenerator;
import org.broadleafcommerce.vendor.paypal.service.payment.message.PayPalRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.message.details.PayPalDetailsRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.message.payment.PayPalItemRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.message.payment.PayPalPaymentRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.type.PayPalMethodType;
import org.broadleafcommerce.vendor.paypal.service.payment.type.PayPalRefundType;

public class PayPalRequestGeneratorImpl
implements PayPalRequestGenerator {
    protected String user;
    protected String password;
    protected String signature;
    protected String libVersion;
    protected String returnUrl;
    protected String cancelUrl;
    protected Map<String, String> additionalConfig;

    @Override
    public List<NameValuePair> buildRequest(PayPalRequest request) {
        ArrayList<NameValuePair> nvps = new ArrayList<NameValuePair>();
        this.setBaseNvps(nvps);
        if (request.getMethodType() == PayPalMethodType.CHECKOUT) {
            this.setNvpsForCheckoutOrAuth(nvps, (PayPalPaymentRequest)request, "Sale");
            nvps.add(new NameValuePair(this.replaceNumericBoundProperty("PAYMENTREQUEST_n_CURRENCYCODE", new Integer[]{0}, new String[]{"n"}), ((PayPalPaymentRequest)request).getCurrency()));
        } else if (request.getMethodType() == PayPalMethodType.AUTHORIZATION) {
            this.setNvpsForCheckoutOrAuth(nvps, (PayPalPaymentRequest)request, "Authorization");
            nvps.add(new NameValuePair(this.replaceNumericBoundProperty("PAYMENTREQUEST_n_CURRENCYCODE", new Integer[]{0}, new String[]{"n"}), ((PayPalPaymentRequest)request).getCurrency()));
        } else if (request.getMethodType() == PayPalMethodType.PROCESS) {
            this.setNvpsForProcess(nvps, (PayPalPaymentRequest)request);
            nvps.add(new NameValuePair(this.replaceNumericBoundProperty("PAYMENTREQUEST_n_CURRENCYCODE", new Integer[]{0}, new String[]{"n"}), ((PayPalPaymentRequest)request).getCurrency()));
        } else if (request.getMethodType() == PayPalMethodType.REFUND) {
            this.setNvpsForRefund(nvps, (PayPalPaymentRequest)request);
            nvps.add(new NameValuePair("CURRENCYCODE", ((PayPalPaymentRequest)request).getCurrency()));
        } else if (request.getMethodType() == PayPalMethodType.CAPTURE) {
            this.setNvpsForCapture(nvps, (PayPalPaymentRequest)request);
            nvps.add(new NameValuePair("CURRENCYCODE", ((PayPalPaymentRequest)request).getCurrency()));
        } else if (request.getMethodType() == PayPalMethodType.VOID) {
            this.setNvpsForVoid(nvps, (PayPalPaymentRequest)request);
        } else if (request.getMethodType() == PayPalMethodType.DETAILS) {
            this.setNvpsForDetails(nvps, (PayPalDetailsRequest)request);
        } else {
            throw new IllegalArgumentException("Method type not supported: " + request.getMethodType().getFriendlyType());
        }
        return nvps;
    }

    protected void setNvpsForDetails(List<NameValuePair> nvps, PayPalDetailsRequest paymentRequest) {
        nvps.add(new NameValuePair("TOKEN", paymentRequest.getToken()));
        nvps.add(new NameValuePair("METHOD", "GetExpressCheckoutDetails"));
    }

    protected void setNvpsForVoid(List<NameValuePair> nvps, PayPalPaymentRequest paymentRequest) {
        nvps.add(new NameValuePair("AUTHORIZATIONID", paymentRequest.getTransactionID()));
        for (Map.Entry<String, String> entry : this.getAdditionalConfig().entrySet()) {
            nvps.add(new NameValuePair(entry.getKey(), entry.getValue()));
        }
        nvps.add(new NameValuePair("METHOD", "DoVoid"));
    }

    protected void setNvpsForCapture(List<NameValuePair> nvps, PayPalPaymentRequest paymentRequest) {
        nvps.add(new NameValuePair("AUTHORIZATIONID", paymentRequest.getTransactionID()));
        nvps.add(new NameValuePair("AMT", paymentRequest.getSummaryRequest().getGrandTotal().toString()));
        nvps.add(new NameValuePair("COMPLETETYPE", "Complete"));
        for (Map.Entry<String, String> entry : this.getAdditionalConfig().entrySet()) {
            nvps.add(new NameValuePair(entry.getKey(), entry.getValue()));
        }
        nvps.add(new NameValuePair("METHOD", "DoCapture"));
    }

    protected void setNvpsForRefund(List<NameValuePair> nvps, PayPalPaymentRequest paymentRequest) {
        nvps.add(new NameValuePair("TRANSACTIONID", paymentRequest.getTransactionID()));
        nvps.add(new NameValuePair("REFUNDTYPE", paymentRequest.getRefundType().getType()));
        if (paymentRequest.getRefundType() != PayPalRefundType.FULL) {
            nvps.add(new NameValuePair("AMT", paymentRequest.getSummaryRequest().getGrandTotal().toString()));
        }
        nvps.add(new NameValuePair("METHOD", "RefundTransaction"));
    }

    protected void setNvpsForProcess(List<NameValuePair> nvps, PayPalPaymentRequest paymentRequest) {
        if (paymentRequest.getSecondaryMethodType() != null && paymentRequest.getSecondaryMethodType() == PayPalMethodType.AUTHORIZATION) {
            nvps.add(new NameValuePair(this.replaceNumericBoundProperty("PAYMENTREQUEST_n_PAYMENTACTION", new Integer[]{0}, new String[]{"n"}), "Authorization"));
        } else {
            nvps.add(new NameValuePair(this.replaceNumericBoundProperty("PAYMENTREQUEST_n_PAYMENTACTION", new Integer[]{0}, new String[]{"n"}), "Sale"));
        }
        nvps.add(new NameValuePair("TOKEN", paymentRequest.getToken()));
        nvps.add(new NameValuePair("PAYERID", paymentRequest.getPayerID()));
        for (Map.Entry<String, String> entry : this.getAdditionalConfig().entrySet()) {
            nvps.add(new NameValuePair(entry.getKey(), entry.getValue()));
        }
        nvps.add(new NameValuePair(this.replaceNumericBoundProperty("PAYMENTREQUEST_n_AMT", new Integer[]{0}, new String[]{"n"}), paymentRequest.getSummaryRequest().getGrandTotal().toString()));
        nvps.add(new NameValuePair("METHOD", "DoExpressCheckoutPayment"));
    }

    protected void setBaseNvps(List<NameValuePair> nvps) {
        nvps.add(new NameValuePair("USER", this.user));
        nvps.add(new NameValuePair("PWD", this.password));
        nvps.add(new NameValuePair("SIGNATURE", this.signature));
        nvps.add(new NameValuePair("VERSION", this.libVersion));
    }

    protected void setNvpsForCheckoutOrAuth(List<NameValuePair> nvps, PayPalPaymentRequest paymentRequest, String payPalAction) {
        nvps.add(new NameValuePair(this.replaceNumericBoundProperty("PAYMENTREQUEST_n_PAYMENTACTION", new Integer[]{0}, new String[]{"n"}), payPalAction));
        nvps.add(new NameValuePair("INVNUM", paymentRequest.getReferenceNumber()));
        this.setCostNvps(nvps, paymentRequest);
        nvps.add(new NameValuePair("RETURNURL", this.getReturnUrl()));
        nvps.add(new NameValuePair("CANCELURL", this.getCancelUrl()));
        for (Map.Entry<String, String> entry : this.getAdditionalConfig().entrySet()) {
            nvps.add(new NameValuePair(entry.getKey(), entry.getValue()));
        }
        nvps.add(new NameValuePair("METHOD", "SetExpressCheckout"));
    }

    protected void setCostNvps(List<NameValuePair> nvps, PayPalPaymentRequest paymentRequest) {
        int counter = 0;
        for (PayPalItemRequest itemRequest : paymentRequest.getItemRequests()) {
            nvps.add(new NameValuePair(this.replaceNumericBoundProperty("L_PAYMENTREQUEST_n_NAMEm", new Integer[]{0, counter}, new String[]{"n", "m"}), itemRequest.getShortDescription()));
            nvps.add(new NameValuePair(this.replaceNumericBoundProperty("L_PAYMENTREQUEST_n_NUMBERm", new Integer[]{0, counter}, new String[]{"n", "m"}), itemRequest.getSystemId()));
            nvps.add(new NameValuePair(this.replaceNumericBoundProperty("L_PAYMENTREQUEST_n_DESCm", new Integer[]{0, counter}, new String[]{"n", "m"}), itemRequest.getDescription()));
            nvps.add(new NameValuePair(this.replaceNumericBoundProperty("L_PAYMENTREQUEST_n_AMTm", new Integer[]{0, counter}, new String[]{"n", "m"}), itemRequest.getUnitPrice().toString()));
            nvps.add(new NameValuePair(this.replaceNumericBoundProperty("L_PAYMENTREQUEST_n_QTYm", new Integer[]{0, counter}, new String[]{"n", "m"}), String.valueOf(itemRequest.getQuantity())));
            ++counter;
        }
        nvps.add(new NameValuePair(this.replaceNumericBoundProperty("PAYMENTREQUEST_n_ITEMAMT", new Integer[]{0}, new String[]{"n"}), paymentRequest.getSummaryRequest().getSubTotal().toString()));
        nvps.add(new NameValuePair(this.replaceNumericBoundProperty("PAYMENTREQUEST_n_TAXAMT", new Integer[]{0}, new String[]{"n"}), paymentRequest.getSummaryRequest().getTotalTax().toString()));
        nvps.add(new NameValuePair(this.replaceNumericBoundProperty("PAYMENTREQUEST_n_SHIPPINGAMT", new Integer[]{0}, new String[]{"n"}), paymentRequest.getSummaryRequest().getTotalShipping().toString()));
        nvps.add(new NameValuePair(this.replaceNumericBoundProperty("PAYMENTREQUEST_n_AMT", new Integer[]{0}, new String[]{"n"}), paymentRequest.getSummaryRequest().getGrandTotal().toString()));
    }

    protected String replaceNumericBoundProperty(String property, Integer[] number, String[] positions) {
        int counter = 0;
        for (String position : positions) {
            int pos = property.indexOf(position);
            if (pos < 0) {
                throw new IllegalArgumentException("Property does not contain the specified position value (" + position + ")");
            }
            String newValue = String.valueOf(number[counter]);
            property = property.substring(0, pos) + newValue + property.substring(pos + position.length(), property.length());
            ++counter;
        }
        return property;
    }

    @Override
    public Map<String, String> getAdditionalConfig() {
        return this.additionalConfig;
    }

    @Override
    public void setAdditionalConfig(Map<String, String> additionalConfig) {
        this.additionalConfig = additionalConfig;
    }

    @Override
    public String getCancelUrl() {
        return this.cancelUrl;
    }

    @Override
    public void setCancelUrl(String cancelUrl) {
        this.cancelUrl = cancelUrl;
    }

    @Override
    public String getLibVersion() {
        return this.libVersion;
    }

    @Override
    public void setLibVersion(String libVersion) {
        this.libVersion = libVersion;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public String getReturnUrl() {
        return this.returnUrl;
    }

    @Override
    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    @Override
    public String getSignature() {
        return this.signature;
    }

    @Override
    public void setSignature(String signature) {
        this.signature = signature;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public void setUser(String user) {
        this.user = user;
    }
}

