/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.paypal.service.payment;

import java.io.IOException;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.vendor.service.exception.PaymentException;
import org.broadleafcommerce.common.vendor.service.monitor.ServiceStatusDetectable;
import org.broadleafcommerce.common.vendor.service.type.ServiceStatusType;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalPaymentService;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalRequestGenerator;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalResponseGenerator;
import org.broadleafcommerce.vendor.paypal.service.payment.message.PayPalRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.message.PayPalResponse;

public class PayPalPaymentServiceImpl
implements PayPalPaymentService,
ServiceStatusDetectable<PayPalRequest> {
    private static final Log LOG = LogFactory.getLog(PayPalPaymentServiceImpl.class);
    protected String serverUrl;
    protected Integer failureReportingThreshold;
    protected Integer failureCount = 0;
    protected Boolean isUp = true;
    protected PayPalRequestGenerator requestGenerator;
    protected PayPalResponseGenerator responseGenerator;

    protected synchronized void clearStatus() {
        this.isUp = true;
        this.failureCount = 0;
    }

    protected synchronized void incrementFailure() {
        if (this.failureCount >= this.failureReportingThreshold) {
            this.isUp = false;
        } else {
            Integer n = this.failureCount;
            Integer n2 = this.failureCount = Integer.valueOf(this.failureCount + 1);
        }
    }

    @Override
    public PayPalResponse process(PayPalRequest paymentRequest) throws PaymentException {
        String response;
        try {
            response = this.communicateWithVendor(paymentRequest);
        }
        catch (Exception e) {
            this.incrementFailure();
            throw new PaymentException((Throwable)e);
        }
        this.clearStatus();
        return this.responseGenerator.buildResponse(response, paymentRequest);
    }

    protected String communicateWithVendor(PayPalRequest paymentRequest) throws IOException {
        HttpClient httpClient = new HttpClient();
        PostMethod postMethod = new PostMethod(this.getServerUrl());
        List<NameValuePair> nvps = this.requestGenerator.buildRequest(paymentRequest);
        postMethod.setRequestBody(nvps.toArray(new NameValuePair[nvps.size()]));
        httpClient.executeMethod((HttpMethod)postMethod);
        return postMethod.getResponseBodyAsString();
    }

    @Override
    public Integer getFailureReportingThreshold() {
        return this.failureReportingThreshold;
    }

    @Override
    public String getServerUrl() {
        return this.serverUrl;
    }

    @Override
    public synchronized ServiceStatusType getServiceStatus() {
        if (this.isUp.booleanValue()) {
            return ServiceStatusType.UP;
        }
        return ServiceStatusType.DOWN;
    }

    @Override
    public void setFailureReportingThreshold(Integer failureReportingThreshold) {
        this.failureReportingThreshold = failureReportingThreshold;
    }

    @Override
    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public String getServiceName() {
        return this.getClass().getName();
    }

    public PayPalRequestGenerator getRequestGenerator() {
        return this.requestGenerator;
    }

    public void setRequestGenerator(PayPalRequestGenerator requestGenerator) {
        this.requestGenerator = requestGenerator;
    }

    public PayPalResponseGenerator getResponseGenerator() {
        return this.responseGenerator;
    }

    public void setResponseGenerator(PayPalResponseGenerator responseGenerator) {
        this.responseGenerator = responseGenerator;
    }
}

