/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.menu.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.CategoryXref;
import org.broadleafcommerce.core.catalog.service.CatalogService;
import org.broadleafcommerce.menu.dao.MenuDao;
import org.broadleafcommerce.menu.domain.Menu;
import org.broadleafcommerce.menu.domain.MenuItem;
import org.broadleafcommerce.menu.dto.MenuItemDTO;
import org.broadleafcommerce.menu.service.MenuService;
import org.broadleafcommerce.menu.type.MenuItemType;
import org.springframework.stereotype.Service;

@Service(value="blMenuService")
public class MenuServiceImpl
implements MenuService {
    @Resource(name="blMenuDao")
    protected MenuDao menuDao;
    @Resource(name="blCatalogService")
    protected CatalogService catalogService;

    @Override
    public Menu findMenuById(Long id) {
        return this.menuDao.readMenuById(id);
    }

    @Override
    public Menu findMenuByName(String menuName) {
        return this.menuDao.readMenuByName(menuName);
    }

    @Override
    public MenuItem findMenuItemById(Long menuItemId) {
        return this.menuDao.readMenuItemById(menuItemId);
    }

    @Override
    public List<MenuItemDTO> constructMenuItemDTOsForMenu(Menu menu) {
        ArrayList<MenuItemDTO> dtos = new ArrayList<MenuItemDTO>();
        if (CollectionUtils.isNotEmpty(menu.getMenuItems())) {
            for (MenuItem menuItem : menu.getMenuItems()) {
                dtos.add(this.convertMenuItemToDTO(menuItem));
            }
        }
        return dtos;
    }

    protected MenuItemDTO convertMenuItemToDTO(MenuItem menuItem) {
        Category category = null;
        if (MenuItemType.CATEGORY.equals(menuItem.getMenuItemType())) {
            category = this.catalogService.findCategoryByURI(menuItem.getActionUrl());
        }
        if (MenuItemType.SUBMENU.equals(menuItem.getMenuItemType()) && menuItem.getLinkedMenu() != null) {
            MenuItemDTO dto = new MenuItemDTO();
            dto.setUrl(menuItem.getDerivedUrl());
            dto.setLabel(menuItem.getDerivedLabel());
            ArrayList<MenuItemDTO> submenu = new ArrayList<MenuItemDTO>();
            List<MenuItem> items = menuItem.getLinkedMenu().getMenuItems();
            if (CollectionUtils.isNotEmpty(items)) {
                for (MenuItem item : items) {
                    submenu.add(this.convertMenuItemToDTO(item));
                }
            }
            dto.setSubmenu(submenu);
            return dto;
        }
        if (category != null) {
            return this.convertCategoryToMenuItemDTO(category);
        }
        MenuItemDTO dto = new MenuItemDTO();
        dto.setUrl(menuItem.getDerivedUrl());
        dto.setLabel(menuItem.getDerivedLabel());
        if (menuItem.getImage() != null) {
            dto.setImageUrl(menuItem.getImage().getUrl());
            dto.setAltText(menuItem.getAltText());
        }
        return dto;
    }

    protected MenuItemDTO convertCategoryToMenuItemDTO(Category category) {
        MenuItemDTO dto = new MenuItemDTO();
        dto.setLabel(category.getName());
        dto.setUrl(category.getUrl());
        List categoryXrefs = category.getChildCategoryXrefs();
        if (CollectionUtils.isNotEmpty((Collection)categoryXrefs)) {
            ArrayList<MenuItemDTO> submenu = new ArrayList<MenuItemDTO>();
            for (CategoryXref xref : categoryXrefs) {
                submenu.add(this.convertCategoryToMenuItemDTO(xref.getSubCategory()));
            }
            dto.setSubmenu(submenu);
        }
        return dto;
    }
}

