/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.menu.processor;

import javax.annotation.Resource;
import org.broadleafcommerce.common.web.dialect.AbstractModelVariableModifierProcessor;
import org.broadleafcommerce.menu.domain.Menu;
import org.broadleafcommerce.menu.processor.MenuProcessorExtensionHandler;
import org.broadleafcommerce.menu.processor.MenuProcessorExtensionManager;
import org.broadleafcommerce.menu.service.MenuService;
import org.springframework.stereotype.Component;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;

@Component(value="blMenuProcessor")
public class MenuProcessor
extends AbstractModelVariableModifierProcessor {
    @Resource(name="blMenuService")
    protected MenuService menuService;
    @Resource(name="blMenuProcessorExtensionManager")
    protected MenuProcessorExtensionManager extensionManager;

    public MenuProcessor() {
        super("menu");
    }

    public int getPrecedence() {
        return 1000;
    }

    protected void modifyModelAttributes(Arguments arguments, Element element) {
        String resultVar = element.getAttributeValue("resultVar");
        String menuName = element.getAttributeValue("menuName");
        String menuId = element.getAttributeValue("menuId");
        Menu menu = menuId != null ? this.menuService.findMenuById(Long.parseLong(menuId)) : this.menuService.findMenuByName(menuName);
        if (menu != null) {
            this.addToModel(arguments, resultVar, this.menuService.constructMenuItemDTOsForMenu(menu));
            ((MenuProcessorExtensionHandler)this.extensionManager.getProxy()).addAdditionalFieldsToModel(arguments, element);
        }
    }
}

