/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.menu.dao;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.broadleafcommerce.common.util.dao.TypedQueryBuilder;
import org.broadleafcommerce.menu.dao.MenuDao;
import org.broadleafcommerce.menu.domain.Menu;
import org.broadleafcommerce.menu.domain.MenuImpl;
import org.broadleafcommerce.menu.domain.MenuItem;
import org.broadleafcommerce.menu.domain.MenuItemImpl;
import org.springframework.stereotype.Repository;

@Repository(value="blMenuDao")
public class MenuDaoImpl
implements MenuDao {
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;

    @Override
    public List<Menu> readAllMenus() {
        TypedQuery q = new TypedQueryBuilder(Menu.class, "m").toQuery(this.em);
        return q.getResultList();
    }

    @Override
    public List<MenuItem> readAllMenuItems() {
        TypedQuery q = new TypedQueryBuilder(MenuItem.class, "mi").toQuery(this.em);
        return q.getResultList();
    }

    @Override
    public Menu readMenuById(Long menuId) {
        return (Menu)this.em.find(MenuImpl.class, (Object)menuId);
    }

    @Override
    public MenuItem readMenuItemById(Long menuItemId) {
        return (MenuItem)this.em.find(MenuItemImpl.class, (Object)menuItemId);
    }

    @Override
    public Menu readMenuByName(String menuName) {
        TypedQuery query = this.em.createNamedQuery("BC_READ_MENU_BY_NAME", Menu.class);
        query.setParameter("menuName", (Object)menuName);
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)"query.Cms");
        List results = query.getResultList();
        if (!results.isEmpty()) {
            return (Menu)results.get(0);
        }
        return null;
    }

    @Override
    public Menu saveMenu(Menu menu) {
        return (Menu)this.em.merge((Object)menu);
    }

    @Override
    public MenuItem saveMenuItem(MenuItem menuItem) {
        return (MenuItem)this.em.merge((Object)menuItem);
    }
}

