/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.menu.admin.server.handler;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.exception.ServiceException;
import org.broadleafcommerce.common.presentation.client.SupportedFieldType;
import org.broadleafcommerce.common.presentation.client.VisibilityEnum;
import org.broadleafcommerce.menu.domain.MenuItem;
import org.broadleafcommerce.menu.domain.MenuItemImpl;
import org.broadleafcommerce.menu.service.MenuService;
import org.broadleafcommerce.openadmin.dto.BasicFieldMetadata;
import org.broadleafcommerce.openadmin.dto.ClassMetadata;
import org.broadleafcommerce.openadmin.dto.CriteriaTransferObject;
import org.broadleafcommerce.openadmin.dto.DynamicResultSet;
import org.broadleafcommerce.openadmin.dto.Entity;
import org.broadleafcommerce.openadmin.dto.MergedPropertyType;
import org.broadleafcommerce.openadmin.dto.PersistencePackage;
import org.broadleafcommerce.openadmin.dto.PersistencePerspective;
import org.broadleafcommerce.openadmin.dto.Property;
import org.broadleafcommerce.openadmin.server.dao.DynamicEntityDao;
import org.broadleafcommerce.openadmin.server.service.handler.CustomPersistenceHandlerAdapter;
import org.broadleafcommerce.openadmin.server.service.persistence.module.BasicPersistenceModule;
import org.broadleafcommerce.openadmin.server.service.persistence.module.InspectHelper;
import org.broadleafcommerce.openadmin.server.service.persistence.module.RecordHelper;
import org.springframework.stereotype.Component;

@Component(value="blMenuItemCustomPersistenceHandler")
public class MenuItemCustomPersistenceHandler
extends CustomPersistenceHandlerAdapter {
    private static final Log LOG = LogFactory.getLog(MenuItemCustomPersistenceHandler.class);
    public static final String DERIVED_LABEL_FIELD_NAME = "derivedLabel";
    @Resource(name="blMenuService")
    protected MenuService menuService;

    public Boolean canHandleInspect(PersistencePackage persistencePackage) {
        String ceilingEntityFullyQualifiedClassname = persistencePackage.getCeilingEntityFullyQualifiedClassname();
        try {
            Class<?> testClass = Class.forName(ceilingEntityFullyQualifiedClassname);
            return MenuItem.class.isAssignableFrom(testClass);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public Boolean canHandleFetch(PersistencePackage persistencePackage) {
        return this.canHandleInspect(persistencePackage);
    }

    public DynamicResultSet inspect(PersistencePackage persistencePackage, DynamicEntityDao dynamicEntityDao, InspectHelper helper) throws ServiceException {
        try {
            PersistencePerspective persistencePerspective = persistencePackage.getPersistencePerspective();
            HashMap<MergedPropertyType, Map> allMergedProperties = new HashMap<MergedPropertyType, Map>();
            Map properties = helper.getSimpleMergedProperties(MenuItem.class.getName(), persistencePerspective);
            BasicFieldMetadata derivedLabelMetadata = new BasicFieldMetadata();
            derivedLabelMetadata.setFieldType(SupportedFieldType.STRING);
            derivedLabelMetadata.setMutable(Boolean.valueOf(false));
            derivedLabelMetadata.setInheritedFromType(MenuItemImpl.class.getName());
            derivedLabelMetadata.setAvailableToTypes(new String[]{MenuItemImpl.class.getName()});
            derivedLabelMetadata.setForeignKeyCollection(Boolean.valueOf(false));
            derivedLabelMetadata.setMergedPropertyType(MergedPropertyType.PRIMARY);
            derivedLabelMetadata.setName(DERIVED_LABEL_FIELD_NAME);
            derivedLabelMetadata.setFriendlyName("MenuItemImpl_Derived_Label");
            derivedLabelMetadata.setExplicitFieldType(SupportedFieldType.STRING);
            derivedLabelMetadata.setProminent(Boolean.valueOf(true));
            derivedLabelMetadata.setReadOnly(Boolean.valueOf(true));
            derivedLabelMetadata.setOrder(Integer.valueOf(500));
            derivedLabelMetadata.setGridOrder(Integer.valueOf(500));
            derivedLabelMetadata.setVisibility(VisibilityEnum.FORM_HIDDEN);
            derivedLabelMetadata.setExcluded(Boolean.valueOf(false));
            properties.put(DERIVED_LABEL_FIELD_NAME, derivedLabelMetadata);
            allMergedProperties.put(MergedPropertyType.PRIMARY, properties);
            Class[] entityClasses = dynamicEntityDao.getAllPolymorphicEntitiesFromCeiling(MenuItem.class);
            ClassMetadata mergedMetadata = helper.getMergedClassMetadata(entityClasses, allMergedProperties);
            return new DynamicResultSet(mergedMetadata, null, null);
        }
        catch (Exception e) {
            String className = persistencePackage.getCeilingEntityFullyQualifiedClassname();
            ServiceException ex = new ServiceException("Unable to retrieve inspection results for " + className, (Throwable)e);
            LOG.error((Object)("Unable to retrieve inspection results for " + className), (Throwable)ex);
            throw ex;
        }
    }

    public DynamicResultSet fetch(PersistencePackage persistencePackage, CriteriaTransferObject cto, DynamicEntityDao dynamicEntityDao, RecordHelper helper) throws ServiceException {
        DynamicResultSet drs = ((BasicPersistenceModule)helper).fetch(persistencePackage, cto);
        for (Entity entity : drs.getRecords()) {
            MenuItem menuItem;
            Property menuItemId = entity.findProperty("id");
            if (menuItemId == null || (menuItem = this.menuService.findMenuItemById(Long.parseLong(menuItemId.getValue()))) == null) continue;
            Property derivedLabel = new Property();
            derivedLabel.setName(DERIVED_LABEL_FIELD_NAME);
            derivedLabel.setValue(menuItem.getDerivedLabel());
            entity.addProperty(derivedLabel);
        }
        return drs;
    }
}

