/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.menu.type;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class MenuItemType
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Map<String, MenuItemType> TYPES = new HashMap<String, MenuItemType>();
    public static final MenuItemType LINK = new MenuItemType("LINK", "Link");
    public static final MenuItemType CATEGORY = new MenuItemType("CATEGORY", "Category");
    public static final MenuItemType PAGE = new MenuItemType("PAGE", "Page");
    public static final MenuItemType SUBMENU = new MenuItemType("SUBMENU", "Sub Menu");
    public static final MenuItemType PRODUCT = new MenuItemType("PRODUCT", "Product");
    public static final MenuItemType CUSTOM = new MenuItemType("CUSTOM", "Custom");
    private String type;
    private String friendlyType;

    public static MenuItemType getInstance(String type) {
        return TYPES.get(type);
    }

    public MenuItemType() {
    }

    public MenuItemType(String type, String friendlyType) {
        this.friendlyType = friendlyType;
        this.setType(type);
    }

    public String getType() {
        return this.type;
    }

    public String getFriendlyType() {
        return this.friendlyType;
    }

    private void setType(String type) {
        this.type = type;
        if (!TYPES.containsKey(type)) {
            TYPES.put(type, this);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MenuItemType other = (MenuItemType)obj;
        return this.type.equals(other.type);
    }
}

