/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.menu.domain;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import org.broadleafcommerce.common.admin.domain.AdminMainEntity;
import org.broadleafcommerce.common.copy.CreateResponse;
import org.broadleafcommerce.common.copy.MultiTenantCopyContext;
import org.broadleafcommerce.common.extensibility.jpa.copy.DirectCopyTransform;
import org.broadleafcommerce.common.extensibility.jpa.copy.DirectCopyTransformMember;
import org.broadleafcommerce.common.i18n.domain.TranslatedEntity;
import org.broadleafcommerce.common.i18n.service.DynamicTranslationProvider;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.AdminPresentationClass;
import org.broadleafcommerce.common.presentation.AdminPresentationCollection;
import org.broadleafcommerce.common.presentation.client.AddMethodType;
import org.broadleafcommerce.menu.domain.Menu;
import org.broadleafcommerce.menu.domain.MenuItem;
import org.broadleafcommerce.menu.domain.MenuItemImpl;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_CMS_MENU")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blCMSElements")
@AdminPresentationClass(friendlyName="MenuImpl")
@DirectCopyTransform(value={@DirectCopyTransformMember(templateTokens={"sandbox"}, skipOverlaps=true), @DirectCopyTransformMember(templateTokens={"multiTenantSite"})})
public class MenuImpl
implements Menu,
AdminMainEntity {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="MenuId")
    @GenericGenerator(name="MenuId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="segment_value", value="MenuImpl"), @Parameter(name="entity_name", value="org.broadleafcommerce.menu.domain.MenuImpl")})
    @Column(name="MENU_ID")
    protected Long id;
    @Column(name="NAME", nullable=false)
    @AdminPresentation(friendlyName="MenuImpl_Name", order=1000, gridOrder=1000, prominent=true, translatable=true)
    protected String name;
    @OneToMany(mappedBy="parentMenu", targetEntity=MenuItemImpl.class, cascade={CascadeType.ALL}, orphanRemoval=true)
    @AdminPresentationCollection(friendlyName="MenuItemImpl_MenuItems", sortProperty="sequence", addType=AddMethodType.PERSIST)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blCMSElements")
    @BatchSize(size=50)
    @OrderBy(value="sequence")
    protected List<MenuItem> menuItems = new ArrayList<MenuItem>(20);

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return DynamicTranslationProvider.getValue((Object)this, (String)"name", (String)this.name);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public List<MenuItem> getMenuItems() {
        return this.menuItems;
    }

    @Override
    public void setMenuItems(List<MenuItem> menuItems) {
        this.menuItems = menuItems;
    }

    public String getMainEntityName() {
        return this.getName();
    }

    public <G extends Menu> CreateResponse<G> createOrRetrieveCopyInstance(MultiTenantCopyContext context) throws CloneNotSupportedException {
        CreateResponse createResponse = context.createOrRetrieveCopyInstance((Object)this);
        if (createResponse.isAlreadyPopulated()) {
            return createResponse;
        }
        Menu cloned = (Menu)createResponse.getClone();
        cloned.setName(this.name);
        for (MenuItem item : this.menuItems) {
            cloned.getMenuItems().add((MenuItem)item.createOrRetrieveCopyInstance(context).getClone());
        }
        return createResponse;
    }

    static {
        new TranslatedEntity("org.broadleafcommerce.menu.domain.Menu", "Menu");
    }

    public static class Presentation {
        private Presentation() {
        }

        public static class FieldOrder {
            public static final int NAME = 1000;

            private FieldOrder() {
            }
        }
    }
}

