/*
 * #%L
 * BroadleafCommerce Menu
 * %%
 * Copyright (C) 2009 - 2014 Broadleaf Commerce
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *       http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */
package org.broadleafcommerce.menu.admin.web;

import org.broadleafcommerce.openadmin.web.controller.entity.AdminBasicEntityController;
import org.springframework.ui.Model;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @author Elbert Bautista (elbertbautista)
 */
@RequestMapping("/" + AdminMenuController.SECTION_KEY)
public class AdminMenuController extends AdminBasicEntityController {

    protected static final String SECTION_KEY = "menu";

    @Override
    protected String getSectionKey(Map<String, String> pathVars) {
        //allow external links to work for ToOne items
        if (super.getSectionKey(pathVars) != null) {
            return super.getSectionKey(pathVars);
        }
        return SECTION_KEY;
    }

    @Override
    @RequestMapping(value = "/{id}/{collectionField:.*}/add", method = RequestMethod.GET)
    public String showAddCollectionItem(HttpServletRequest request, HttpServletResponse response, Model model,
                                        @PathVariable Map<String, String> pathVars,
                                        @PathVariable(value = "id") String id,
                                        @PathVariable(value = "collectionField") String collectionField,
                                        @RequestParam MultiValueMap<String, String> requestParams) throws Exception {
        String view = super.showAddCollectionItem(request, response, model, pathVars, id, collectionField, requestParams);
        model.addAttribute("additionalControllerClasses", "menu-item-form");

        return view;
    }

    @Override
    @RequestMapping(value = "/{id}/{collectionField:.*}/{collectionItemId}", method = RequestMethod.GET)
    public String showUpdateCollectionItem(HttpServletRequest request, HttpServletResponse response, Model model,
                                           @PathVariable  Map<String, String> pathVars,
                                           @PathVariable(value="id") String id,
                                           @PathVariable(value="collectionField") String collectionField,
                                           @PathVariable(value="collectionItemId") String collectionItemId) throws Exception {
        String view = super.showUpdateCollectionItem(request, response, model, pathVars, id, collectionField, collectionItemId);
        model.addAttribute("additionalControllerClasses", "menu-item-form");

        return view;
    }


}
