/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.service;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.broadleafcommerce.common.sitemap.domain.SiteMapGeneratorConfiguration;
import org.broadleafcommerce.common.sitemap.domain.SiteMapGeneratorConfigurationImpl;
import org.broadleafcommerce.common.sitemap.exception.SiteMapException;
import org.broadleafcommerce.common.sitemap.service.SiteMapGenerator;
import org.broadleafcommerce.common.sitemap.service.SiteMapGeneratorTest;
import org.broadleafcommerce.common.sitemap.service.type.SiteMapChangeFreqType;
import org.broadleafcommerce.common.sitemap.service.type.SiteMapGeneratorType;
import org.broadleafcommerce.common.sitemap.service.type.SiteMapPriorityType;
import org.broadleafcommerce.core.catalog.dao.SkuDao;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.ProductImpl;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.catalog.domain.SkuImpl;
import org.broadleafcommerce.core.catalog.service.SkuSiteMapGenerator;
import org.easymock.EasyMock;
import org.junit.Test;

public class SkuSiteMapGeneratorTest
extends SiteMapGeneratorTest {
    @Test
    public void testSkuSiteMapGenerator() throws SiteMapException, IOException {
        ProductImpl p1 = new ProductImpl();
        p1.setUrl("/hot-sauces/sudden_death_sauce");
        SkuImpl s1 = new SkuImpl();
        p1.setDefaultSku((Sku)s1);
        ProductImpl p2 = new ProductImpl();
        p2.setUrl("/merchandise/hawt_like_a_habanero_mens");
        SkuImpl s2 = new SkuImpl();
        s2.setUrlKey("/black_s");
        s2.setProduct((Product)p2);
        SkuImpl s3 = new SkuImpl();
        s3.setUrlKey("/black_m");
        s3.setProduct((Product)p2);
        SkuImpl s4 = new SkuImpl();
        s4.setUrlKey("/black_l");
        s4.setProduct((Product)p2);
        ArrayList<SkuImpl> skus = new ArrayList<SkuImpl>();
        skus.add(s1);
        skus.add(s2);
        skus.add(s3);
        skus.add(s4);
        SkuDao skuDao = (SkuDao)EasyMock.createMock(SkuDao.class);
        EasyMock.expect((Object)skuDao.readAllActiveSkus(EasyMock.eq((int)0), EasyMock.eq((int)5))).andReturn(skus);
        EasyMock.replay((Object[])new Object[]{skuDao});
        SkuSiteMapGenerator ssmg = new SkuSiteMapGenerator();
        ssmg.setSkuDao(skuDao);
        ssmg.setPageSize(5);
        SiteMapGeneratorConfigurationImpl smgc = new SiteMapGeneratorConfigurationImpl();
        smgc.setDisabled(Boolean.valueOf(false));
        smgc.setSiteMapGeneratorType(SiteMapGeneratorType.SKU);
        smgc.setSiteMapChangeFreq(SiteMapChangeFreqType.HOURLY);
        smgc.setSiteMapPriority(SiteMapPriorityType.POINT5);
        this.testGenerator((SiteMapGeneratorConfiguration)smgc, (SiteMapGenerator)ssmg);
        File file1 = this.fileService.getResource("/sitemap_index.xml");
        File file2 = this.fileService.getResource("/sitemap1.xml");
        File file3 = this.fileService.getResource("/sitemap2.xml");
        this.compareFiles(file1, "src/test/resources/org/broadleafcommerce/sitemap/sku/sitemap_index.xml");
        this.compareFiles(file2, "src/test/resources/org/broadleafcommerce/sitemap/sku/sitemap1.xml");
        this.compareFiles(file3, "src/test/resources/org/broadleafcommerce/sitemap/sku/sitemap2.xml");
    }
}

