/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.service;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.broadleafcommerce.common.sitemap.exception.SiteMapException;
import org.broadleafcommerce.common.sitemap.service.SiteMapGenerator;
import org.broadleafcommerce.common.sitemap.service.SiteMapGeneratorTest;
import org.broadleafcommerce.common.sitemap.service.type.SiteMapChangeFreqType;
import org.broadleafcommerce.common.sitemap.service.type.SiteMapGeneratorType;
import org.broadleafcommerce.common.sitemap.service.type.SiteMapPriorityType;
import org.broadleafcommerce.core.catalog.dao.CategoryDao;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.CategoryImpl;
import org.broadleafcommerce.core.catalog.domain.CategorySiteMapGeneratorConfigurationImpl;
import org.broadleafcommerce.core.catalog.service.CategorySiteMapGenerator;
import org.easymock.EasyMock;
import org.junit.Test;

public class CategorySiteMapGeneratorTest
extends SiteMapGeneratorTest {
    @Test
    public void testCategorySiteMapGenerator() throws SiteMapException, IOException {
        CategoryImpl c1 = new CategoryImpl();
        c1.setUrl("/");
        c1.setId(Long.valueOf(1L));
        CategoryImpl c2 = new CategoryImpl();
        c2.setUrl("/hot-sauces");
        c2.setId(Long.valueOf(2L));
        CategoryImpl c3 = new CategoryImpl();
        c3.setUrl("merchandise");
        c3.setId(Long.valueOf(3L));
        CategoryImpl c4 = new CategoryImpl();
        c4.setUrl("/clearance");
        c4.setId(Long.valueOf(4L));
        CategoryImpl c5 = new CategoryImpl();
        c5.setUrl("/mens");
        c5.setId(Long.valueOf(5L));
        CategoryImpl c6 = new CategoryImpl();
        c6.setUrl("/womens");
        c6.setId(Long.valueOf(6L));
        ArrayList<CategoryImpl> merchandiseSubcategories = new ArrayList<CategoryImpl>();
        merchandiseSubcategories.add(c5);
        merchandiseSubcategories.add(c6);
        CategoryDao categoryDao = (CategoryDao)EasyMock.createMock(CategoryDao.class);
        EasyMock.expect((Object)categoryDao.readActiveSubCategoriesByCategory((Category)c1, 5, 0)).andReturn(new ArrayList()).atLeastOnce();
        EasyMock.expect((Object)categoryDao.readCategoryById(c1.getId())).andReturn((Object)c1).atLeastOnce();
        EasyMock.expect((Object)categoryDao.readActiveSubCategoriesByCategory((Category)c2, 5, 0)).andReturn(new ArrayList()).atLeastOnce();
        EasyMock.expect((Object)categoryDao.readCategoryById(c2.getId())).andReturn((Object)c2).atLeastOnce();
        EasyMock.expect((Object)categoryDao.readActiveSubCategoriesByCategory((Category)c3, 5, 0)).andReturn(merchandiseSubcategories).atLeastOnce();
        EasyMock.expect((Object)categoryDao.readCategoryById(c3.getId())).andReturn((Object)c3).atLeastOnce();
        EasyMock.expect((Object)categoryDao.readActiveSubCategoriesByCategory((Category)c4, 5, 0)).andReturn(new ArrayList()).atLeastOnce();
        EasyMock.expect((Object)categoryDao.readCategoryById(c4.getId())).andReturn((Object)c4).atLeastOnce();
        EasyMock.expect((Object)categoryDao.readActiveSubCategoriesByCategory((Category)c5, 5, 0)).andReturn(new ArrayList()).atLeastOnce();
        EasyMock.expect((Object)categoryDao.readCategoryById(c5.getId())).andReturn((Object)c5).atLeastOnce();
        EasyMock.expect((Object)categoryDao.readActiveSubCategoriesByCategory((Category)c6, 5, 0)).andReturn(new ArrayList()).atLeastOnce();
        EasyMock.expect((Object)categoryDao.readCategoryById(c6.getId())).andReturn((Object)c6).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{categoryDao});
        CategorySiteMapGenerator csmg = new CategorySiteMapGenerator();
        csmg.setCategoryDao(categoryDao);
        csmg.setRowLimit(5);
        ArrayList<CategorySiteMapGeneratorConfigurationImpl> smgcList = new ArrayList<CategorySiteMapGeneratorConfigurationImpl>();
        CategorySiteMapGeneratorConfigurationImpl c1CSMGC = new CategorySiteMapGeneratorConfigurationImpl();
        c1CSMGC.setDisabled(Boolean.valueOf(false));
        c1CSMGC.setSiteMapGeneratorType(SiteMapGeneratorType.CATEGORY);
        c1CSMGC.setSiteMapChangeFreq(SiteMapChangeFreqType.HOURLY);
        c1CSMGC.setSiteMapPriority(SiteMapPriorityType.POINT5);
        c1CSMGC.setRootCategory((Category)c1);
        c1CSMGC.setStartingDepth(0);
        c1CSMGC.setEndingDepth(1);
        smgcList.add(c1CSMGC);
        CategorySiteMapGeneratorConfigurationImpl c2CSMGC = new CategorySiteMapGeneratorConfigurationImpl();
        c2CSMGC.setDisabled(Boolean.valueOf(false));
        c2CSMGC.setSiteMapGeneratorType(SiteMapGeneratorType.CATEGORY);
        c2CSMGC.setSiteMapChangeFreq(SiteMapChangeFreqType.HOURLY);
        c2CSMGC.setSiteMapPriority(SiteMapPriorityType.POINT5);
        c2CSMGC.setRootCategory((Category)c2);
        c2CSMGC.setStartingDepth(0);
        c2CSMGC.setEndingDepth(1);
        smgcList.add(c2CSMGC);
        CategorySiteMapGeneratorConfigurationImpl c3CSMGC = new CategorySiteMapGeneratorConfigurationImpl();
        c3CSMGC.setDisabled(Boolean.valueOf(false));
        c3CSMGC.setSiteMapGeneratorType(SiteMapGeneratorType.CATEGORY);
        c3CSMGC.setSiteMapChangeFreq(SiteMapChangeFreqType.HOURLY);
        c3CSMGC.setSiteMapPriority(SiteMapPriorityType.POINT5);
        c3CSMGC.setRootCategory((Category)c3);
        c3CSMGC.setStartingDepth(0);
        c3CSMGC.setEndingDepth(1);
        smgcList.add(c3CSMGC);
        CategorySiteMapGeneratorConfigurationImpl c4CSMGC = new CategorySiteMapGeneratorConfigurationImpl();
        c4CSMGC.setDisabled(Boolean.valueOf(false));
        c4CSMGC.setSiteMapGeneratorType(SiteMapGeneratorType.CATEGORY);
        c4CSMGC.setSiteMapChangeFreq(SiteMapChangeFreqType.HOURLY);
        c4CSMGC.setSiteMapPriority(SiteMapPriorityType.POINT5);
        c4CSMGC.setRootCategory((Category)c4);
        c4CSMGC.setStartingDepth(0);
        c4CSMGC.setEndingDepth(1);
        smgcList.add(c4CSMGC);
        this.testGenerator(smgcList, (SiteMapGenerator)csmg, 2);
        File file1 = this.fileService.getResource("/sitemap_index.xml");
        File file2 = this.fileService.getResource("/sitemap1.xml");
        File file3 = this.fileService.getResource("/sitemap2.xml");
        File file4 = this.fileService.getResource("/sitemap3.xml");
        this.compareFiles(file1, "src/test/resources/org/broadleafcommerce/sitemap/category/sitemap_index.xml");
        this.compareFiles(file2, "src/test/resources/org/broadleafcommerce/sitemap/category/sitemap1.xml");
        this.compareFiles(file3, "src/test/resources/org/broadleafcommerce/sitemap/category/sitemap2.xml");
        this.compareFiles(file4, "src/test/resources/org/broadleafcommerce/sitemap/category/sitemap3.xml");
        this.testGenerator(smgcList, (SiteMapGenerator)csmg, 50000);
        File file5 = this.fileService.getResource("/sitemap.xml");
        this.compareFiles(file5, "src/test/resources/org/broadleafcommerce/sitemap/category/sitemap.xml");
    }
}

