/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.util.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.time.SystemTime;
import org.broadleafcommerce.common.util.TransactionUtils;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.service.OrderService;
import org.broadleafcommerce.core.order.service.type.OrderStatus;
import org.broadleafcommerce.core.util.dao.ResourcePurgeDao;
import org.broadleafcommerce.core.util.service.ResourcePurgeService;
import org.broadleafcommerce.core.util.service.type.PurgeCartVariableNames;
import org.broadleafcommerce.core.util.service.type.PurgeCustomerVariableNames;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.service.CustomerService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;

@Service(value="blResourcePurgeService")
public class ResourcePurgeServiceImpl
implements ResourcePurgeService {
    private static final Log LOG = LogFactory.getLog(ResourcePurgeServiceImpl.class);
    private static final Long BATCH_SIZE = 50L;
    private static final Long PURGE_ERROR_CACHE_RETRY_SECONDS = System.currentTimeMillis() - 172800L;
    protected PurgeErrorCache customerPurgeErrors = new PurgeErrorCache();
    protected PurgeErrorCache cartPurgeErrors = new PurgeErrorCache();
    @Resource(name="blTransactionManager")
    protected PlatformTransactionManager transactionManager;
    @Resource(name="blResourcePurgeDao")
    protected ResourcePurgeDao resourcePurgeDao;
    @Resource(name="blOrderService")
    protected OrderService orderService;
    @Resource(name="blCustomerService")
    protected CustomerService customerService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purgeCarts(Map<String, String> config) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Purging carts");
        }
        if (MapUtils.isEmpty(config)) {
            throw new IllegalArgumentException("Cannot purge carts since there was no configuration provided. In the absence of config params, all carts would be candidates for deletion.");
        }
        CartPurgeParams purgeParams = new CartPurgeParams(config).invoke();
        int processedCount = 0;
        int batchCount = 0;
        PurgeErrorCache purgeErrorCache = this.cartPurgeErrors;
        synchronized (purgeErrorCache) {
            Set<Long> failedCartIds = this.getCartsInErrorToIgnore(purgeParams);
            batchCount = this.getCartsToPurgeLength(purgeParams, new ArrayList<Long>(failedCartIds)).intValue();
            List<Order> carts = this.getCartsToPurge(purgeParams, 0, batchCount, new ArrayList<Long>(failedCartIds));
            for (Order cart : carts) {
                TransactionStatus status = TransactionUtils.createTransaction((String)"Cart Purge", (int)0, (PlatformTransactionManager)this.transactionManager, (boolean)false);
                try {
                    this.deleteCart(cart);
                    TransactionUtils.finalizeTransaction((TransactionStatus)status, (PlatformTransactionManager)this.transactionManager, (boolean)false);
                    ++processedCount;
                }
                catch (Exception e) {
                    if (!status.isCompleted()) {
                        TransactionUtils.finalizeTransaction((TransactionStatus)status, (PlatformTransactionManager)this.transactionManager, (boolean)true);
                    }
                    LOG.error((Object)String.format("Not able to purge Cart ID: %d", cart.getId()), (Throwable)e);
                    this.cartPurgeErrors.add(cart.getId());
                }
            }
        }
        LOG.info((Object)String.format("Cart purge batch processed.  Purged %d from total batch size of %d, %d failures cached", processedCount, batchCount, this.cartPurgeErrors.size()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purgeCustomers(Map<String, String> config) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Purging customers");
        }
        if (MapUtils.isEmpty(config)) {
            throw new IllegalArgumentException("Cannot purge customers since there was no configuration provided. In the absence of config params, all customers would be candidates for deletion.");
        }
        CustomerPurgeParams purgeParams = new CustomerPurgeParams(config).invoke();
        int processedCount = 0;
        int batchCount = 0;
        PurgeErrorCache purgeErrorCache = this.customerPurgeErrors;
        synchronized (purgeErrorCache) {
            Set<Long> failedCustomerIds = this.getCustomersInErrorToIgnore(purgeParams);
            batchCount = this.getCustomersToPurgeLength(purgeParams, new ArrayList<Long>(failedCustomerIds)).intValue();
            List<Customer> customers = this.getCustomersToPurge(purgeParams, 0, batchCount, new ArrayList<Long>(failedCustomerIds));
            for (Customer customer : customers) {
                TransactionStatus status = TransactionUtils.createTransaction((String)"Customer Purge", (int)0, (PlatformTransactionManager)this.transactionManager, (boolean)false);
                try {
                    this.deleteCustomer(customer);
                    TransactionUtils.finalizeTransaction((TransactionStatus)status, (PlatformTransactionManager)this.transactionManager, (boolean)false);
                    ++processedCount;
                }
                catch (Exception e) {
                    if (!status.isCompleted()) {
                        TransactionUtils.finalizeTransaction((TransactionStatus)status, (PlatformTransactionManager)this.transactionManager, (boolean)true);
                    }
                    LOG.error((Object)String.format("Not able to purge Customer ID: %d", customer.getId()), (Throwable)e);
                    this.customerPurgeErrors.add(customer.getId());
                }
            }
        }
        LOG.info((Object)String.format("Customer purge batch processed.  Purged %d from total batch size of %d, %d failures cached", processedCount, batchCount, this.customerPurgeErrors.size()));
    }

    protected Set<Long> getCartsInErrorToIgnore(CartPurgeParams purgeParams) {
        long ignoreFailedExpiration = purgeParams.getFailedRetryTime();
        Set<Long> ignoreFailedCartIds = this.cartPurgeErrors.getEntriesSince(ignoreFailedExpiration);
        return ignoreFailedCartIds;
    }

    protected List<Order> getCartsToPurge(CartPurgeParams purgeParams, int startPos, int length, List<Long> cartsInError) {
        String[] nameArray = purgeParams.getNameArray();
        OrderStatus[] statusArray = purgeParams.getStatusArray();
        Date dateCreatedMinThreshold = purgeParams.getDateCreatedMinThreshold();
        Boolean isPreview = purgeParams.getIsPreview();
        return this.resourcePurgeDao.findCarts(nameArray, statusArray, dateCreatedMinThreshold, isPreview, startPos, length, cartsInError);
    }

    protected Long getCartsToPurgeLength(CartPurgeParams purgeParams, List<Long> cartsInError) {
        String[] nameArray = purgeParams.getNameArray();
        OrderStatus[] statusArray = purgeParams.getStatusArray();
        Date dateCreatedMinThreshold = purgeParams.getDateCreatedMinThreshold();
        Boolean isPreview = purgeParams.getIsPreview();
        Long cartBatchSize = purgeParams.getBatchSize();
        Long orderCount = this.resourcePurgeDao.findCartsCount(nameArray, statusArray, dateCreatedMinThreshold, isPreview, cartsInError);
        return cartBatchSize != null && cartBatchSize < orderCount ? cartBatchSize : orderCount;
    }

    protected void deleteCart(Order cart) {
        this.orderService.deleteOrder(cart);
    }

    protected Set<Long> getCustomersInErrorToIgnore(CustomerPurgeParams purgeParams) {
        long ignoreFailedExpiration = purgeParams.getFailedRetryTime();
        Set<Long> ignoreFailedCustomerIds = this.customerPurgeErrors.getEntriesSince(ignoreFailedExpiration);
        return ignoreFailedCustomerIds;
    }

    protected List<Customer> getCustomersToPurge(CustomerPurgeParams purgeParams, int startPos, int length, List<Long> customersInError) {
        Boolean isRegistered = purgeParams.getIsRegistered();
        Boolean isDeactivated = purgeParams.getIsDeactivated();
        Date dateCreatedMinThreshold = purgeParams.getDateCreatedMinThreshold();
        Boolean isPreview = purgeParams.getIsPreview();
        return this.resourcePurgeDao.findCustomers(dateCreatedMinThreshold, isRegistered, isDeactivated, isPreview, startPos, length, customersInError);
    }

    protected Long getCustomersToPurgeLength(CustomerPurgeParams purgeParams, List<Long> customersInError) {
        Boolean isRegistered = purgeParams.getIsRegistered();
        Boolean isDeactivated = purgeParams.getIsDeactivated();
        Date dateCreatedMinThreshold = purgeParams.getDateCreatedMinThreshold();
        Boolean isPreview = purgeParams.getIsPreview();
        Long customerBatchSize = purgeParams.getBatchSize();
        Long customersCount = this.resourcePurgeDao.findCustomersCount(dateCreatedMinThreshold, isRegistered, isDeactivated, isPreview, customersInError);
        return customerBatchSize != null && customerBatchSize < customersCount ? customerBatchSize : customersCount;
    }

    protected void deleteCustomer(Customer customer) {
        this.customerService.deleteCustomer(customer);
    }

    private class PurgeErrorCache {
        private Map<Long, Long> cache = new HashMap<Long, Long>();

        private PurgeErrorCache() {
        }

        public Long add(Long entry) {
            if (!this.cache.containsKey(entry)) {
                return this.cache.put(entry, new Long(System.currentTimeMillis()));
            }
            return null;
        }

        public Set<Long> getEntriesSince(long expiredTime) {
            Iterator<Map.Entry<Long, Long>> item = this.cache.entrySet().iterator();
            while (item.hasNext()) {
                Map.Entry<Long, Long> entry = item.next();
                if (entry.getValue() >= expiredTime) continue;
                item.remove();
            }
            return this.cache.keySet();
        }

        public int size() {
            return this.cache.size();
        }
    }

    private class CustomerPurgeParams {
        private Map<String, String> config;
        private Date dateCreatedMinThreshold;
        private Boolean isPreview;
        private Boolean isRegistered;
        private Boolean isDeactivated;
        private Long batchSize;
        private Long failedRetryTime;

        public CustomerPurgeParams(Map<String, String> config) {
            this.config = config;
        }

        public Date getDateCreatedMinThreshold() {
            return this.dateCreatedMinThreshold;
        }

        public Boolean getIsPreview() {
            return this.isPreview;
        }

        public Boolean getIsRegistered() {
            return this.isRegistered;
        }

        public Boolean getIsDeactivated() {
            return this.isDeactivated;
        }

        public Long getBatchSize() {
            return this.batchSize;
        }

        public Long getFailedRetryTime() {
            return this.failedRetryTime;
        }

        public CustomerPurgeParams invoke() {
            this.isRegistered = null;
            this.isDeactivated = null;
            this.dateCreatedMinThreshold = null;
            this.isPreview = null;
            this.batchSize = BATCH_SIZE;
            this.failedRetryTime = PURGE_ERROR_CACHE_RETRY_SECONDS;
            for (Map.Entry<String, String> entry : this.config.entrySet()) {
                if (PurgeCustomerVariableNames.SECONDS_OLD.toString().equals(entry.getKey())) {
                    Long secondsOld = Long.parseLong(entry.getValue());
                    this.dateCreatedMinThreshold = new Date(SystemTime.asMillis() - secondsOld * 1000L);
                }
                if (PurgeCustomerVariableNames.IS_REGISTERED.toString().equals(entry.getKey())) {
                    this.isRegistered = Boolean.parseBoolean(entry.getValue());
                }
                if (PurgeCustomerVariableNames.IS_DEACTIVATED.toString().equals(entry.getKey())) {
                    this.isDeactivated = Boolean.parseBoolean(entry.getValue());
                }
                if (PurgeCustomerVariableNames.IS_PREVIEW.toString().equals(entry.getKey())) {
                    this.isPreview = Boolean.parseBoolean(entry.getValue());
                }
                if (PurgeCustomerVariableNames.BATCH_SIZE.toString().equals(entry.getKey())) {
                    this.batchSize = Long.parseLong(entry.getValue());
                }
                if (!PurgeCustomerVariableNames.RETRY_FAILED_SECONDS.toString().equals(entry.getKey())) continue;
                this.failedRetryTime = System.currentTimeMillis() - Long.parseLong(entry.getValue()) * 1000L;
            }
            return this;
        }
    }

    private class CartPurgeParams {
        private Map<String, String> config;
        private String[] nameArray;
        private OrderStatus[] statusArray;
        private Date dateCreatedMinThreshold;
        private Boolean isPreview;
        private Long batchSize;
        private Long failedRetryTime;

        public CartPurgeParams(Map<String, String> config) {
            this.config = config;
        }

        public String[] getNameArray() {
            return this.nameArray;
        }

        public OrderStatus[] getStatusArray() {
            return this.statusArray;
        }

        public Date getDateCreatedMinThreshold() {
            return this.dateCreatedMinThreshold;
        }

        public Boolean getIsPreview() {
            return this.isPreview;
        }

        public Long getBatchSize() {
            return this.batchSize;
        }

        public Long getFailedRetryTime() {
            return this.failedRetryTime;
        }

        public CartPurgeParams invoke() {
            this.nameArray = null;
            this.statusArray = null;
            this.dateCreatedMinThreshold = null;
            this.isPreview = null;
            this.batchSize = BATCH_SIZE;
            this.failedRetryTime = PURGE_ERROR_CACHE_RETRY_SECONDS;
            for (Map.Entry<String, String> entry : this.config.entrySet()) {
                if (PurgeCartVariableNames.STATUS.toString().equals(entry.getKey())) {
                    String[] temp = entry.getValue().split(",");
                    this.statusArray = new OrderStatus[temp.length];
                    int index = 0;
                    for (String name : temp) {
                        OrderStatus orderStatus;
                        this.statusArray[index] = orderStatus = OrderStatus.getInstance(name);
                        ++index;
                    }
                }
                if (PurgeCartVariableNames.NAME.toString().equals(entry.getKey())) {
                    this.nameArray = entry.getValue().split(",");
                }
                if (PurgeCartVariableNames.SECONDS_OLD.toString().equals(entry.getKey())) {
                    Long secondsOld = Long.parseLong(entry.getValue());
                    this.dateCreatedMinThreshold = new Date(SystemTime.asMillis() - secondsOld * 1000L);
                }
                if (PurgeCartVariableNames.IS_PREVIEW.toString().equals(entry.getKey())) {
                    this.isPreview = Boolean.parseBoolean(entry.getValue());
                }
                if (PurgeCartVariableNames.BATCH_SIZE.toString().equals(entry.getKey())) {
                    this.batchSize = Long.parseLong(entry.getValue());
                }
                if (!PurgeCartVariableNames.RETRY_FAILED_SECONDS.toString().equals(entry.getKey())) continue;
                this.failedRetryTime = System.currentTimeMillis() - Long.parseLong(entry.getValue()) * 1000L;
            }
            return this;
        }
    }
}

