/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.search.service.solr;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Resource;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.impl.CloudSolrServer;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.broadleafcommerce.common.exception.ServiceException;
import org.broadleafcommerce.common.locale.domain.Locale;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.broadleafcommerce.core.catalog.dao.ProductDao;
import org.broadleafcommerce.core.catalog.dao.SkuDao;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.search.dao.FieldDao;
import org.broadleafcommerce.core.search.dao.SearchFacetDao;
import org.broadleafcommerce.core.search.domain.CategorySearchFacet;
import org.broadleafcommerce.core.search.domain.Field;
import org.broadleafcommerce.core.search.domain.FieldEntity;
import org.broadleafcommerce.core.search.domain.SearchCriteria;
import org.broadleafcommerce.core.search.domain.SearchFacet;
import org.broadleafcommerce.core.search.domain.SearchFacetDTO;
import org.broadleafcommerce.core.search.domain.SearchFacetRange;
import org.broadleafcommerce.core.search.domain.SearchResult;
import org.broadleafcommerce.core.search.domain.solr.FieldType;
import org.broadleafcommerce.core.search.service.SearchService;
import org.broadleafcommerce.core.search.service.solr.SolrContext;
import org.broadleafcommerce.core.search.service.solr.SolrHelperService;
import org.broadleafcommerce.core.search.service.solr.SolrIndexService;
import org.broadleafcommerce.core.search.service.solr.SolrSearchServiceExtensionHandler;
import org.broadleafcommerce.core.search.service.solr.SolrSearchServiceExtensionManager;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.xml.sax.SAXException;

public class SolrSearchServiceImpl
implements SearchService,
InitializingBean,
DisposableBean {
    private static final Log LOG = LogFactory.getLog(SolrSearchServiceImpl.class);
    @Value(value="${solr.index.use.sku}")
    protected boolean useSku;
    @Value(value="${solr.cloud.configName}")
    protected String solrCloudConfigName = "blc";
    @Value(value="${solr.cloud.defaultNumShards}")
    protected int solrCloudNumShards = 2;
    @Resource(name="blProductDao")
    protected ProductDao productDao;
    @Resource(name="blSkuDao")
    protected SkuDao skuDao;
    @Resource(name="blFieldDao")
    protected FieldDao fieldDao;
    @Resource(name="blSearchFacetDao")
    protected SearchFacetDao searchFacetDao;
    @Resource(name="blSolrHelperService")
    protected SolrHelperService shs;
    @Resource(name="blSolrIndexService")
    protected SolrIndexService solrIndexService;
    @Resource(name="blSolrSearchServiceExtensionManager")
    protected SolrSearchServiceExtensionManager extensionManager;
    protected String solrHomePath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SolrSearchServiceImpl(String solrServer) throws IOException, ParserConfigurationException, SAXException {
        if ("solrhome".equals(solrServer)) {
            String baseTempPath = System.getProperty("java.io.tmpdir");
            File tempDir = new File(baseTempPath + File.separator + System.getProperty("user.name") + File.separator + "solrhome-4.10.3");
            if (System.getProperty("tmpdir.solrhome") != null) {
                tempDir = new File(System.getProperty("tmpdir.solrhome"));
            }
            if (!tempDir.exists()) {
                tempDir.mkdirs();
            }
            solrServer = tempDir.getAbsolutePath();
        }
        this.solrHomePath = solrServer;
        File solrXml = new File(new File(solrServer), "solr.xml");
        if (!solrXml.exists()) {
            this.copyConfigToSolrHome(this.getClass().getResourceAsStream("/solr-default.xml"), solrXml);
        }
        this.buildSolrCoreDirectories(solrServer);
        LOG.debug((Object)String.format("Using [%s] as solrhome", solrServer));
        LOG.debug((Object)String.format("Using [%s] as solr.xml", solrXml.getAbsoluteFile()));
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"Contents of solr.xml:");
            BufferedReader br = null;
            try {
                String line;
                br = new BufferedReader(new FileReader(solrXml));
                while ((line = br.readLine()) != null) {
                    LOG.trace((Object)line);
                }
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (Throwable line) {}
                }
            }
            LOG.trace((Object)"Done printing solr.xml");
        }
        CoreContainer coreContainer = CoreContainer.createAndLoad((String)solrServer, (File)solrXml);
        EmbeddedSolrServer primaryServer = new EmbeddedSolrServer(coreContainer, "primary");
        EmbeddedSolrServer reindexServer = new EmbeddedSolrServer(coreContainer, "reindex");
        SolrContext.setPrimaryServer((SolrServer)primaryServer);
        SolrContext.setReindexServer((SolrServer)reindexServer);
    }

    public String getSolrHomePath() {
        return this.solrHomePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyConfigToSolrHome(InputStream configIs, File destFile) throws IOException {
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            bis = new BufferedInputStream(configIs);
            bos = new BufferedOutputStream(new FileOutputStream(destFile, false));
            boolean eof = false;
            while (!eof) {
                int temp = bis.read();
                if (temp == -1) {
                    eof = true;
                    continue;
                }
                ((BufferedOutputStream)bos).write(temp);
            }
            ((BufferedOutputStream)bos).flush();
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Throwable throwable) {}
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    protected void buildSolrCoreDirectories(String solrServer) throws IOException {
        File reindexConfDir;
        File reindexCoreFile;
        File reindexCoreDir;
        File primaryConfDir;
        File primaryCoreFile;
        File primaryCoreDir;
        File cores = new File(new File(solrServer), "cores");
        if (!cores.exists() || !cores.isDirectory()) {
            cores.mkdirs();
        }
        if (!(primaryCoreDir = new File(cores, "primary")).exists() || !primaryCoreDir.isDirectory()) {
            primaryCoreDir.mkdirs();
        }
        if (!(primaryCoreFile = new File(primaryCoreDir, "core.properties")).exists()) {
            FileOutputStream os = new FileOutputStream(primaryCoreFile);
            Properties prop = new Properties();
            prop.put("name", "primary");
            prop.store(os, "Generated Solr core properties file");
            IOUtils.closeQuietly((OutputStream)os);
        }
        if (!(primaryConfDir = new File(primaryCoreDir, "conf")).exists() || !primaryConfDir.isDirectory()) {
            primaryConfDir.mkdirs();
        }
        if (!(reindexCoreDir = new File(cores, "reindex")).exists() || !reindexCoreDir.isDirectory()) {
            reindexCoreDir.mkdirs();
        }
        if (!(reindexCoreFile = new File(reindexCoreDir, "core.properties")).exists()) {
            FileOutputStream os = new FileOutputStream(reindexCoreFile);
            Properties prop = new Properties();
            prop.put("name", "reindex");
            prop.store(os, "Generated Solr core properties file");
            IOUtils.closeQuietly((OutputStream)os);
        }
        if (!(reindexConfDir = new File(reindexCoreDir, "conf")).exists() || !reindexConfDir.isDirectory()) {
            reindexConfDir.mkdirs();
        }
    }

    public SolrSearchServiceImpl(SolrServer solrServer) {
        SolrContext.setPrimaryServer(solrServer);
    }

    public SolrSearchServiceImpl(String solrServer, String reindexServer) throws IOException, ParserConfigurationException, SAXException {
        this(solrServer);
    }

    public SolrSearchServiceImpl(String solrServer, String reindexServer, String adminServer) throws IOException, ParserConfigurationException, SAXException {
        this(solrServer);
    }

    public SolrSearchServiceImpl(SolrServer solrServer, SolrServer reindexServer) {
        SolrContext.setPrimaryServer(solrServer);
        SolrContext.setReindexServer(reindexServer);
    }

    public SolrSearchServiceImpl(SolrServer solrServer, SolrServer reindexServer, SolrServer adminServer) {
        SolrContext.setPrimaryServer(solrServer);
        SolrContext.setReindexServer(reindexServer);
        SolrContext.setAdminServer(adminServer);
    }

    @Override
    public void rebuildIndex() throws ServiceException, IOException {
        this.solrIndexService.rebuildIndex();
    }

    public void afterPropertiesSet() throws Exception {
        if (SolrContext.isSolrCloudMode()) {
            int i;
            String collectionName;
            Aliases aliases;
            Map aliasCollectionMap;
            CloudSolrServer primary = (CloudSolrServer)SolrContext.getServer();
            CloudSolrServer reindex = (CloudSolrServer)SolrContext.getReindexServer();
            if (primary == null || reindex == null) {
                throw new IllegalStateException("The primary and reindex CloudSolrServers must not be null. Check your configuration and ensure that you are passing a different instance for each to the constructor of " + this.getClass().getName() + " and ensure that each has a null (empty)" + " defaultCollection property, or ensure that defaultCollection is unique between" + " the two instances. All other things, like Zookeeper addresses should be the same.");
            }
            if (primary == reindex) {
                throw new IllegalStateException("The primary and reindex CloudSolrServers must be different instances and their defaultCollection property must be unique or null.  All other things like the Zookeeper addresses should be the same.");
            }
            if (StringUtils.isEmpty((String)primary.getDefaultCollection())) {
                primary.setDefaultCollection("primary");
            }
            if (StringUtils.isEmpty((String)reindex.getDefaultCollection())) {
                reindex.setDefaultCollection("reindex");
            }
            if (primary.getDefaultCollection().equals(reindex.getDefaultCollection())) {
                throw new IllegalStateException("The primary and reindex CloudSolrServers must have a null (empty) or unique defaultCollection property.  All other things like the Zookeeper addresses should be the same.");
            }
            primary.connect();
            Set collectionNames = primary.getZkStateReader().getClusterState().getCollections();
            if (collectionNames == null) {
                collectionNames = new HashSet();
            }
            if ((aliasCollectionMap = (aliases = primary.getZkStateReader().getAliases()).getCollectionAliasMap()) == null || !aliasCollectionMap.containsKey(primary.getDefaultCollection())) {
                collectionName = null;
                for (i = 0; i < 1000 && collectionNames.contains(collectionName = "blcCollection" + i); ++i) {
                    collectionName = null;
                }
                CollectionAdminRequest.createCollection((String)collectionName, (Integer)this.solrCloudNumShards, (String)this.solrCloudConfigName, (SolrServer)primary);
                CollectionAdminRequest.createAlias((String)primary.getDefaultCollection(), (String)collectionName, (SolrServer)primary);
            } else {
                collectionName = (String)aliasCollectionMap.get(primary.getDefaultCollection());
                if (!collectionNames.contains(collectionName = collectionName.split(",")[0])) {
                    CollectionAdminRequest.createCollection((String)collectionName, (Integer)this.solrCloudNumShards, (String)this.solrCloudConfigName, (SolrServer)primary);
                }
            }
            collectionNames = primary.getZkStateReader().getClusterState().getCollections();
            if (collectionNames == null) {
                collectionNames = new HashSet();
            }
            if ((aliasCollectionMap = (aliases = primary.getZkStateReader().getAliases()).getCollectionAliasMap()) == null || !aliasCollectionMap.containsKey(reindex.getDefaultCollection())) {
                collectionName = null;
                for (i = 0; i < 1000 && collectionNames.contains(collectionName = "blcCollection" + i); ++i) {
                    collectionName = null;
                }
                CollectionAdminRequest.createCollection((String)collectionName, (Integer)this.solrCloudNumShards, (String)this.solrCloudConfigName, (SolrServer)primary);
                CollectionAdminRequest.createAlias((String)reindex.getDefaultCollection(), (String)collectionName, (SolrServer)primary);
            } else {
                collectionName = (String)aliasCollectionMap.get(reindex.getDefaultCollection());
                if (!collectionNames.contains(collectionName = collectionName.split(",")[0])) {
                    CollectionAdminRequest.createCollection((String)collectionName, (Integer)this.solrCloudNumShards, (String)this.solrCloudConfigName, (SolrServer)primary);
                }
            }
        }
    }

    public void destroy() throws Exception {
        try {
            if (SolrContext.getServer() != null) {
                SolrContext.getServer().shutdown();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error shutting down primary SolrServer (client).", (Throwable)e);
        }
        try {
            if (SolrContext.getReindexServer() != null && SolrContext.getReindexServer() != SolrContext.getServer()) {
                SolrContext.getReindexServer().shutdown();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error shutting down reindex SolrServer (client).", (Throwable)e);
        }
        try {
            if (SolrContext.getAdminServer() != null && SolrContext.getAdminServer() != SolrContext.getServer() && SolrContext.getAdminServer() != SolrContext.getReindexServer()) {
                SolrContext.getAdminServer().shutdown();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error shutting down admin SolrServer (client).", (Throwable)e);
        }
    }

    @Override
    public SearchResult findExplicitSearchResultsByCategory(Category category, SearchCriteria searchCriteria) throws ServiceException {
        List<SearchFacetDTO> facets = this.getCategoryFacets(category);
        String query = this.shs.getExplicitCategoryFieldName() + ":\"" + this.shs.getCategoryId(category) + "\"";
        return this.findSearchResults("*:*", facets, searchCriteria, this.shs.getCategorySortFieldName(category) + " asc", query);
    }

    @Override
    public SearchResult findSearchResultsByCategory(Category category, SearchCriteria searchCriteria) throws ServiceException {
        List<SearchFacetDTO> facets = this.getCategoryFacets(category);
        String query = this.shs.getCategoryFieldName() + ":\"" + this.shs.getCategoryId(category) + "\"";
        return this.findSearchResults("*:*", facets, searchCriteria, this.shs.getCategorySortFieldName(category) + " asc", query);
    }

    @Override
    public SearchResult findSearchResultsByQuery(String query, SearchCriteria searchCriteria) throws ServiceException {
        List<SearchFacetDTO> facets = this.getSearchFacets();
        query = "(" + this.sanitizeQuery(query) + ")";
        return this.findSearchResults(query, facets, searchCriteria, null);
    }

    @Override
    public SearchResult findSearchResultsByCategoryAndQuery(Category category, String query, SearchCriteria searchCriteria) throws ServiceException {
        List<SearchFacetDTO> facets = this.getSearchFacets();
        String catFq = this.shs.getCategoryFieldName() + ":\"" + this.shs.getCategoryId(category) + "\"";
        query = "(" + this.sanitizeQuery(query) + ")";
        return this.findSearchResults(query, facets, searchCriteria, null, catFq);
    }

    public String getLocalePrefix() {
        Locale locale;
        if (BroadleafRequestContext.getBroadleafRequestContext() != null && (locale = BroadleafRequestContext.getBroadleafRequestContext().getLocale()) != null) {
            return locale.getLocaleCode() + "_";
        }
        return "";
    }

    protected String buildQueryFieldsString() {
        StringBuilder queryBuilder = new StringBuilder();
        List<Field> fields = null;
        fields = this.useSku ? this.fieldDao.readAllSkuFields() : this.fieldDao.readAllProductFields();
        for (Field currentField : fields) {
            if (!currentField.getSearchable().booleanValue()) continue;
            this.appendFieldToQuery(queryBuilder, currentField);
        }
        return queryBuilder.toString();
    }

    protected void appendFieldToQuery(StringBuilder queryBuilder, Field currentField) {
        List<FieldType> searchableFieldTypes = this.shs.getSearchableFieldTypes(currentField);
        for (FieldType currentType : searchableFieldTypes) {
            queryBuilder.append(this.shs.getPropertyNameForFieldSearchable(currentField, currentType)).append(" ");
        }
    }

    @Deprecated
    protected SearchResult findSearchResults(String qualifiedSolrQuery, List<SearchFacetDTO> facets, SearchCriteria searchCriteria, String defaultSort) throws ServiceException {
        return this.findSearchResults(qualifiedSolrQuery, facets, searchCriteria, defaultSort, null);
    }

    protected SearchResult findSearchResults(String qualifiedSolrQuery, List<SearchFacetDTO> facets, SearchCriteria searchCriteria, String defaultSort, String ... filterQueries) throws ServiceException {
        List<SolrDocument> responseDocuments;
        QueryResponse response;
        Map<String, SearchFacetDTO> namedFacetMap = this.getNamedFacetMap(facets, searchCriteria);
        int start = searchCriteria.getPage() <= 0 ? 0 : searchCriteria.getPage() - 1;
        SolrQuery solrQuery = new SolrQuery().setQuery(qualifiedSolrQuery).setRows(searchCriteria.getPageSize()).setStart(Integer.valueOf(start * searchCriteria.getPageSize()));
        solrQuery.setParam("collection", new String[]{"primary"});
        if (this.useSku) {
            solrQuery.setFields(new String[]{this.shs.getSkuIdFieldName()});
        } else {
            solrQuery.setFields(new String[]{this.shs.getProductIdFieldName()});
        }
        if (filterQueries != null) {
            solrQuery.setFilterQueries(filterQueries);
        }
        solrQuery.addFilterQuery(new String[]{this.shs.getNamespaceFieldName() + ":(\"" + this.shs.getCurrentNamespace() + "\")"});
        solrQuery.set("defType", new String[]{"edismax"});
        solrQuery.set("qf", new String[]{this.buildQueryFieldsString()});
        this.attachSortClause(solrQuery, searchCriteria, defaultSort);
        this.attachActiveFacetFilters(solrQuery, namedFacetMap, searchCriteria);
        this.attachFacets(solrQuery, namedFacetMap);
        this.modifySolrQuery(solrQuery, qualifiedSolrQuery, facets, searchCriteria, defaultSort);
        ((SolrSearchServiceExtensionHandler)this.extensionManager.getProxy()).modifySolrQuery(solrQuery, qualifiedSolrQuery, facets, searchCriteria, defaultSort);
        if (LOG.isTraceEnabled()) {
            try {
                LOG.trace((Object)URLDecoder.decode(solrQuery.toString(), "UTF-8"));
            }
            catch (Exception e) {
                LOG.trace((Object)("Couldn't UTF-8 URL Decode: " + solrQuery.toString()));
            }
        }
        int numResults = 0;
        try {
            response = SolrContext.getServer().query((SolrParams)solrQuery, this.getSolrQueryMethod());
            responseDocuments = this.getResponseDocuments(response);
            numResults = (int)response.getResults().getNumFound();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)response.toString());
                for (SolrDocument doc : responseDocuments) {
                    LOG.trace((Object)doc);
                }
            }
        }
        catch (SolrServerException e) {
            throw new ServiceException("Could not perform search", (Throwable)e);
        }
        this.setFacetResults(namedFacetMap, response);
        this.sortFacetResults(namedFacetMap);
        SearchResult result = new SearchResult();
        result.setFacets(facets);
        this.setPagingAttributes(result, numResults, searchCriteria);
        if (this.useSku) {
            List<Sku> skus = this.getSkus(responseDocuments);
            result.setSkus(skus);
        } else {
            List<Product> products = this.getProducts(responseDocuments);
            result.setProducts(products);
        }
        return result;
    }

    protected void modifySolrQuery(SolrQuery query, String qualifiedSolrQuery, List<SearchFacetDTO> facets, SearchCriteria searchCriteria, String defaultSort) {
    }

    protected List<SolrDocument> getResponseDocuments(QueryResponse response) {
        return this.shs.getResponseDocuments(response);
    }

    @Override
    public List<SearchFacetDTO> getSearchFacets() {
        if (this.useSku) {
            return this.buildSearchFacetDTOs(this.searchFacetDao.readAllSearchFacets(FieldEntity.SKU));
        }
        return this.buildSearchFacetDTOs(this.searchFacetDao.readAllSearchFacets(FieldEntity.PRODUCT));
    }

    @Override
    public List<SearchFacetDTO> getCategoryFacets(Category category) {
        List<CategorySearchFacet> categorySearchFacets = category.getCumulativeSearchFacets();
        ArrayList<SearchFacet> searchFacets = new ArrayList<SearchFacet>();
        for (CategorySearchFacet categorySearchFacet : categorySearchFacets) {
            searchFacets.add(categorySearchFacet.getSearchFacet());
        }
        return this.buildSearchFacetDTOs(searchFacets);
    }

    protected void attachSortClause(SolrQuery query, SearchCriteria searchCriteria, String defaultSort) {
        List<Field> fields = null;
        fields = this.useSku ? this.fieldDao.readAllSkuFields() : this.fieldDao.readAllProductFields();
        this.shs.attachSortClause(query, searchCriteria, defaultSort, fields);
    }

    protected void attachActiveFacetFilters(SolrQuery query, Map<String, SearchFacetDTO> namedFacetMap, SearchCriteria searchCriteria) {
        this.shs.attachActiveFacetFilters(query, namedFacetMap, searchCriteria);
    }

    protected String scrubFacetValue(String facetValue) {
        return this.shs.scrubFacetValue(facetValue);
    }

    protected void attachFacets(SolrQuery query, Map<String, SearchFacetDTO> namedFacetMap) {
        this.shs.attachFacets(query, namedFacetMap);
    }

    protected void setFacetResults(Map<String, SearchFacetDTO> namedFacetMap, QueryResponse response) {
        this.shs.setFacetResults(namedFacetMap, response);
    }

    protected void sortFacetResults(Map<String, SearchFacetDTO> namedFacetMap) {
        this.shs.sortFacetResults(namedFacetMap);
    }

    public void setPagingAttributes(SearchResult result, int numResults, SearchCriteria searchCriteria) {
        result.setTotalResults(numResults);
        result.setPage(searchCriteria.getPage());
        result.setPageSize(searchCriteria.getPageSize());
    }

    protected List<Product> getProducts(List<SolrDocument> responseDocuments) {
        final ArrayList<Long> productIds = new ArrayList<Long>();
        for (SolrDocument doc : responseDocuments) {
            productIds.add((Long)doc.getFieldValue(this.shs.getProductIdFieldName()));
        }
        List<Product> products = this.productDao.readProductsByIds(productIds);
        ((SolrSearchServiceExtensionHandler)this.extensionManager.getProxy()).batchFetchCatalogData(products);
        if (products != null) {
            Collections.sort(products, new Comparator<Product>(){

                @Override
                public int compare(Product o1, Product o2) {
                    Long o1id = SolrSearchServiceImpl.this.shs.getProductId(o1);
                    Long o2id = SolrSearchServiceImpl.this.shs.getProductId(o2);
                    return new Integer(productIds.indexOf(o1id)).compareTo(productIds.indexOf(o2id));
                }
            });
        }
        return products;
    }

    protected List<Sku> getSkus(List<SolrDocument> responseDocuments) {
        final ArrayList<Long> skuIds = new ArrayList<Long>();
        for (SolrDocument doc : responseDocuments) {
            skuIds.add((Long)doc.getFieldValue(this.shs.getSkuIdFieldName()));
        }
        List<Sku> skus = this.skuDao.readSkusByIds(skuIds);
        if (skus != null) {
            Collections.sort(skus, new Comparator<Sku>(){

                @Override
                public int compare(Sku o1, Sku o2) {
                    return new Integer(skuIds.indexOf(o1.getId())).compareTo(skuIds.indexOf(o2.getId()));
                }
            });
        }
        return skus;
    }

    protected List<SearchFacetDTO> buildSearchFacetDTOs(List<SearchFacet> searchFacets) {
        return this.shs.buildSearchFacetDTOs(searchFacets);
    }

    protected boolean facetIsAvailable(SearchFacet facet, Map<String, String[]> params) {
        return this.shs.isFacetAvailable(facet, params);
    }

    protected String sanitizeQuery(String query) {
        return this.shs.sanitizeQuery(query);
    }

    protected String getSolrTaggedFieldString(String indexField, String tag, SearchFacetRange range) {
        return this.shs.getSolrTaggedFieldString(indexField, tag, range);
    }

    protected String getSolrFieldTag(String tagField, String tag, SearchFacetRange range) {
        return this.shs.getSolrFieldTag(tagField, tag, range);
    }

    protected String getSolrRangeString(String fieldName, BigDecimal minValue, BigDecimal maxValue) {
        return this.shs.getSolrRangeString(fieldName, minValue, maxValue);
    }

    protected String getSolrRangeFunctionString(BigDecimal minValue, BigDecimal maxValue) {
        return this.shs.getSolrRangeFunctionString(minValue, maxValue);
    }

    protected Map<String, SearchFacetDTO> getNamedFacetMap(List<SearchFacetDTO> facets, SearchCriteria searchCriteria) {
        return this.shs.getNamedFacetMap(facets, searchCriteria);
    }

    protected Map<String, String> getSolrFieldKeyMap(SearchCriteria searchCriteria) {
        List<Field> fields = null;
        fields = this.useSku ? this.fieldDao.readAllSkuFields() : this.fieldDao.readAllProductFields();
        return this.shs.getSolrFieldKeyMap(searchCriteria, fields);
    }

    protected SolrRequest.METHOD getSolrQueryMethod() {
        return SolrRequest.METHOD.POST;
    }
}

