/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.search.service.solr;

import java.util.List;
import javax.annotation.Resource;
import org.broadleafcommerce.core.search.service.solr.IndexStatusInfo;
import org.broadleafcommerce.core.search.service.solr.IndexStatusInfoImpl;
import org.broadleafcommerce.core.search.service.solr.SolrIndexStatusProvider;
import org.broadleafcommerce.core.search.service.solr.SolrIndexStatusService;
import org.springframework.stereotype.Service;

@Service(value="blSolrIndexStatusService")
public class SolrIndexStatusServiceImpl
implements SolrIndexStatusService {
    @Resource(name="blSolrIndexStatusProviders")
    List<SolrIndexStatusProvider> providers;

    @Override
    public synchronized void setIndexStatus(IndexStatusInfo status) {
        for (SolrIndexStatusProvider provider : this.providers) {
            provider.handleUpdateIndexStatus(status);
        }
    }

    @Override
    public synchronized IndexStatusInfo getIndexStatus() {
        IndexStatusInfo status = this.getSeedStatusInstance();
        for (SolrIndexStatusProvider provider : this.providers) {
            provider.readIndexStatus(status);
        }
        return status;
    }

    @Override
    public IndexStatusInfo getSeedStatusInstance() {
        return new IndexStatusInfoImpl();
    }
}

