/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.search.service.solr;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.SolrInputDocument;
import org.broadleafcommerce.common.exception.ExceptionHelper;
import org.broadleafcommerce.common.exception.ServiceException;
import org.broadleafcommerce.common.extension.ExtensionResultStatusType;
import org.broadleafcommerce.common.locale.domain.Locale;
import org.broadleafcommerce.common.locale.service.LocaleService;
import org.broadleafcommerce.common.sandbox.SandBoxHelper;
import org.broadleafcommerce.common.util.BLCCollectionUtils;
import org.broadleafcommerce.common.util.StopWatch;
import org.broadleafcommerce.common.util.TransactionUtils;
import org.broadleafcommerce.common.util.Tuple;
import org.broadleafcommerce.common.util.TypedTransformer;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.broadleafcommerce.core.catalog.dao.CategoryDao;
import org.broadleafcommerce.core.catalog.dao.ProductDao;
import org.broadleafcommerce.core.catalog.dao.SkuDao;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.CategoryProductXref;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.ProductBundle;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.catalog.service.dynamic.DynamicSkuActiveDatesService;
import org.broadleafcommerce.core.catalog.service.dynamic.DynamicSkuPricingService;
import org.broadleafcommerce.core.catalog.service.dynamic.SkuActiveDateConsiderationContext;
import org.broadleafcommerce.core.catalog.service.dynamic.SkuPricingConsiderationContext;
import org.broadleafcommerce.core.search.dao.CatalogStructure;
import org.broadleafcommerce.core.search.dao.FieldDao;
import org.broadleafcommerce.core.search.dao.SolrIndexDao;
import org.broadleafcommerce.core.search.domain.Field;
import org.broadleafcommerce.core.search.domain.solr.FieldType;
import org.broadleafcommerce.core.search.service.solr.SolrContext;
import org.broadleafcommerce.core.search.service.solr.SolrHelperService;
import org.broadleafcommerce.core.search.service.solr.SolrIndexCachedOperation;
import org.broadleafcommerce.core.search.service.solr.SolrIndexService;
import org.broadleafcommerce.core.search.service.solr.SolrSearchServiceExtensionHandler;
import org.broadleafcommerce.core.search.service.solr.SolrSearchServiceExtensionManager;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;

@Service(value="blSolrIndexService")
public class SolrIndexServiceImpl
implements SolrIndexService {
    private static final Log LOG = LogFactory.getLog(SolrIndexServiceImpl.class);
    protected final Object LOCK_OBJECT = new Object();
    protected boolean IS_LOCKED = false;
    @Value(value="${solr.index.errorOnConcurrentReIndex}")
    protected boolean errorOnConcurrentReIndex = false;
    @Value(value="${solr.index.product.pageSize}")
    protected int pageSize;
    @Value(value="${solr.index.use.sku}")
    protected boolean useSku;
    @Value(value="${solr.index.commit}")
    protected boolean commit;
    @Value(value="${solr.index.softCommit}")
    protected boolean softCommit;
    @Value(value="${solr.index.waitSearcher}")
    protected boolean waitSearcher;
    @Value(value="${solr.index.waitFlush}")
    protected boolean waitFlush;
    @Resource(name="blProductDao")
    protected ProductDao productDao;
    @Resource(name="blSkuDao")
    protected SkuDao skuDao;
    @Resource(name="blCategoryDao")
    protected CategoryDao categoryDao;
    @Resource(name="blFieldDao")
    protected FieldDao fieldDao;
    @Resource(name="blLocaleService")
    protected LocaleService localeService;
    @Resource(name="blSolrHelperService")
    protected SolrHelperService shs;
    @Resource(name="blSolrSearchServiceExtensionManager")
    protected SolrSearchServiceExtensionManager extensionManager;
    @Resource(name="blTransactionManager")
    protected PlatformTransactionManager transactionManager;
    @Resource(name="blSolrIndexDao")
    protected SolrIndexDao solrIndexDao;
    @Resource(name="blSandBoxHelper")
    protected SandBoxHelper sandBoxHelper;

    @Override
    public void performCachedOperation(SolrIndexCachedOperation.CacheOperation cacheOperation) throws ServiceException {
        try {
            CatalogStructure cache = new CatalogStructure();
            SolrIndexCachedOperation.setCache(cache);
            cacheOperation.execute();
        }
        finally {
            SolrIndexCachedOperation.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isReindexInProcess() {
        Object object = this.LOCK_OBJECT;
        synchronized (object) {
            return this.IS_LOCKED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rebuildIndex() throws ServiceException, IOException {
        Object object = this.LOCK_OBJECT;
        synchronized (object) {
            if (this.IS_LOCKED) {
                if (this.errorOnConcurrentReIndex) {
                    throw new IllegalStateException("More than one thread attempting to concurrently reindex Solr.");
                }
                LOG.warn((Object)"There is more than one thread attempting to concurrently reindex Solr. Failing additional threads gracefully. Check your configuration.");
                return;
            }
            this.IS_LOCKED = true;
        }
        try {
            LOG.info((Object)"Rebuilding the solr index...");
            StopWatch s = new StopWatch();
            LOG.info((Object)"Deleting the reindex core prior to rebuilding the index");
            this.deleteAllReindexCoreDocuments();
            Object[] pack = this.saveState();
            try {
                final Long numItemsToIndex = this.useSku ? this.skuDao.readCountAllActiveSkus() : this.productDao.readCountAllActiveProducts();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("There are at most " + numItemsToIndex + " items to index"));
                }
                this.performCachedOperation(new SolrIndexCachedOperation.CacheOperation(){

                    @Override
                    public void execute() throws ServiceException {
                        int page = 0;
                        while ((long)(page * SolrIndexServiceImpl.this.pageSize) < numItemsToIndex) {
                            LOG.info((Object)String.format("Building page number %s", page));
                            SolrIndexServiceImpl.this.buildIncrementalIndex(page, SolrIndexServiceImpl.this.pageSize);
                            ++page;
                        }
                    }
                });
                this.optimizeIndex(SolrContext.getReindexServer());
            }
            finally {
                this.restoreState(pack);
            }
            this.shs.swapActiveCores();
            LOG.info((Object)String.format("Finished building index in %s", s.toLapString()));
        }
        finally {
            object = this.LOCK_OBJECT;
            synchronized (object) {
                this.IS_LOCKED = false;
            }
        }
    }

    @Deprecated
    protected void deleteAllDocuments() throws ServiceException {
        this.deleteAllReindexCoreDocuments();
    }

    protected void deleteAllReindexCoreDocuments() throws ServiceException {
        try {
            String deleteQuery = this.shs.getNamespaceFieldName() + ":(\"" + this.shs.getCurrentNamespace() + "\")";
            LOG.debug((Object)("Deleting by query: " + deleteQuery));
            SolrContext.getReindexServer().deleteByQuery(deleteQuery);
            SolrContext.getReindexServer().commit();
        }
        catch (Exception e) {
            if (ServiceException.class.isAssignableFrom(e.getClass())) {
                throw (ServiceException)e;
            }
            throw new ServiceException("Could not delete documents", (Throwable)e);
        }
    }

    protected void buildIncrementalIndex(int page, int pageSize) throws ServiceException {
        this.buildIncrementalIndex(page, pageSize, true);
    }

    @Override
    public void buildIncrementalProductIndex(List<Product> products, boolean useReindexServer) throws ServiceException {
        TransactionStatus status = TransactionUtils.createTransaction((String)"executeIncrementalProductIndex", (int)0, (PlatformTransactionManager)this.transactionManager, (boolean)true);
        if (SolrIndexCachedOperation.getCache() == null) {
            LOG.warn((Object)"Consider using SolrIndexService.performCachedOperation() in combination with SolrIndexService.buildIncrementalIndex() for better caching performance during solr indexing");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Building incremental product index - pageSize: [%s]...", products.size()));
        }
        StopWatch s = new StopWatch();
        boolean cacheOperationManaged = false;
        try {
            ((SolrSearchServiceExtensionHandler)this.extensionManager.getProxy()).startBatchEvent(products);
            ArrayList<SolrInputDocument> documents = new ArrayList<SolrInputDocument>();
            List<Locale> locales = this.getAllLocales();
            CatalogStructure cache = SolrIndexCachedOperation.getCache();
            if (cache != null) {
                cacheOperationManaged = true;
            } else {
                cache = new CatalogStructure();
                SolrIndexCachedOperation.setCache(cache);
            }
            List<Field> fields = this.fieldDao.readAllProductFields();
            List productIds = BLCCollectionUtils.collectList(products, (TypedTransformer)new TypedTransformer<Long>(){

                public Long transform(Object input) {
                    return SolrIndexServiceImpl.this.shs.getProductId((Product)input);
                }
            });
            this.solrIndexDao.populateProductCatalogStructure(productIds, SolrIndexCachedOperation.getCache());
            for (Product product : products) {
                SolrInputDocument doc = this.buildDocument(product, fields, locales);
                if (doc == null) continue;
                documents.add(doc);
            }
            ((SolrSearchServiceExtensionHandler)this.extensionManager.getProxy()).modifyBuiltDocuments(documents, products, fields, locales);
            this.logDocuments(documents);
            if (!CollectionUtils.isEmpty(documents)) {
                SolrServer server = useReindexServer ? SolrContext.getReindexServer() : SolrContext.getServer();
                server.add(documents);
                this.commit(server);
            }
            TransactionUtils.finalizeTransaction((TransactionStatus)status, (PlatformTransactionManager)this.transactionManager, (boolean)false);
        }
        catch (SolrServerException e) {
            TransactionUtils.finalizeTransaction((TransactionStatus)status, (PlatformTransactionManager)this.transactionManager, (boolean)true);
            throw new ServiceException("Could not rebuild index", (Throwable)e);
        }
        catch (IOException e) {
            TransactionUtils.finalizeTransaction((TransactionStatus)status, (PlatformTransactionManager)this.transactionManager, (boolean)true);
            throw new ServiceException("Could not rebuild index", (Throwable)e);
        }
        catch (RuntimeException e) {
            TransactionUtils.finalizeTransaction((TransactionStatus)status, (PlatformTransactionManager)this.transactionManager, (boolean)true);
            throw e;
        }
        finally {
            if (!cacheOperationManaged) {
                SolrIndexCachedOperation.clearCache();
            }
            ((SolrSearchServiceExtensionHandler)this.extensionManager.getProxy()).endBatchEvent();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Built incremental product index - pageSize: [%s] in [%s]", products.size(), s.toLapString()));
        }
    }

    @Override
    public void buildIncrementalSkuIndex(List<Sku> skus, boolean useReindexServer) throws ServiceException {
        TransactionStatus status = TransactionUtils.createTransaction((String)"executeIncrementalSkuIndex", (int)0, (PlatformTransactionManager)this.transactionManager, (boolean)true);
        if (SolrIndexCachedOperation.getCache() == null) {
            LOG.warn((Object)"Consider using SolrIndexService.performCachedOperation() in combination with SolrIndexService.buildIncrementalIndex() for better caching performance during solr indexing");
        }
        StopWatch s = new StopWatch();
        boolean cacheOperationManaged = false;
        try {
            ArrayList<SolrInputDocument> documents = new ArrayList<SolrInputDocument>();
            List<Locale> locales = this.getAllLocales();
            CatalogStructure cache = SolrIndexCachedOperation.getCache();
            if (cache != null) {
                cacheOperationManaged = true;
            } else {
                cache = new CatalogStructure();
                SolrIndexCachedOperation.setCache(cache);
            }
            List<Field> fields = this.fieldDao.readAllSkuFields();
            ArrayList<Long> productIds = new ArrayList<Long>();
            for (Sku sku : skus) {
                productIds.add(sku.getProduct().getId());
            }
            this.solrIndexDao.populateProductCatalogStructure(productIds, SolrIndexCachedOperation.getCache());
            for (Sku sku : skus) {
                SolrInputDocument doc = this.buildDocument(sku, fields, locales);
                if (doc == null) continue;
                documents.add(doc);
            }
            this.logDocuments(documents);
            if (!CollectionUtils.isEmpty(documents)) {
                SolrServer server = useReindexServer ? SolrContext.getReindexServer() : SolrContext.getServer();
                server.add(documents);
                this.commit(server);
            }
            TransactionUtils.finalizeTransaction((TransactionStatus)status, (PlatformTransactionManager)this.transactionManager, (boolean)false);
        }
        catch (SolrServerException e) {
            TransactionUtils.finalizeTransaction((TransactionStatus)status, (PlatformTransactionManager)this.transactionManager, (boolean)true);
            throw new ServiceException("Could not rebuild index", (Throwable)e);
        }
        catch (IOException e) {
            TransactionUtils.finalizeTransaction((TransactionStatus)status, (PlatformTransactionManager)this.transactionManager, (boolean)true);
            throw new ServiceException("Could not rebuild index", (Throwable)e);
        }
        catch (RuntimeException e) {
            TransactionUtils.finalizeTransaction((TransactionStatus)status, (PlatformTransactionManager)this.transactionManager, (boolean)true);
            throw e;
        }
        finally {
            if (!cacheOperationManaged) {
                SolrIndexCachedOperation.clearCache();
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Built incremental sku index - pageSize: [%s] in [%s]", skus.size(), s.toLapString()));
        }
    }

    @Override
    public void buildIncrementalIndex(int page, int pageSize, boolean useReindexServer) throws ServiceException {
        TransactionStatus status = TransactionUtils.createTransaction((String)"readItemsToIndex", (int)0, (PlatformTransactionManager)this.transactionManager, (boolean)true);
        if (SolrIndexCachedOperation.getCache() == null) {
            LOG.warn((Object)"Consider using SolrIndexService.performCachedOperation() in combination with SolrIndexService.buildIncrementalIndex() for better caching performance during solr indexing");
        }
        try {
            if (this.useSku) {
                List<Sku> skus = this.readAllActiveSkus(page, pageSize);
                this.buildIncrementalSkuIndex(skus, useReindexServer);
            } else {
                List<Product> products = this.readAllActiveProducts(page, pageSize);
                this.buildIncrementalProductIndex(products, useReindexServer);
            }
            TransactionUtils.finalizeTransaction((TransactionStatus)status, (PlatformTransactionManager)this.transactionManager, (boolean)false);
        }
        catch (RuntimeException e) {
            TransactionUtils.finalizeTransaction((TransactionStatus)status, (PlatformTransactionManager)this.transactionManager, (boolean)true);
            throw e;
        }
    }

    protected List<Product> readAllActiveProducts() {
        return this.productDao.readAllActiveProducts();
    }

    protected List<Product> readAllActiveProducts(int page, int pageSize) {
        return this.productDao.readAllActiveProducts(page, pageSize);
    }

    protected List<Sku> readAllActiveSkus(int page, int pageSize) {
        List<Sku> skus = this.skuDao.readAllActiveSkus(page, pageSize);
        ArrayList<Sku> skusToIndex = new ArrayList<Sku>();
        if (skus != null && !skus.isEmpty()) {
            for (Sku sku : skus) {
                if (!sku.isActive() || sku.getDefaultProduct() != null && !sku.getProduct().getCanSellWithoutOptions().booleanValue() && !sku.getProduct().getAdditionalSkus().isEmpty() || sku.getDefaultProduct() instanceof ProductBundle) continue;
                skusToIndex.add(sku);
            }
        }
        return skusToIndex;
    }

    @Override
    public List<Locale> getAllLocales() {
        List allLocales = this.localeService.findAllLocales();
        HashMap<String, Locale> processedLocales = new HashMap<String, Locale>();
        for (Locale locale : allLocales) {
            String localeCode = locale.getLocaleCode();
            int underscoreLocation = localeCode.indexOf("_");
            if (underscoreLocation > 0 && Boolean.FALSE.equals(locale.getUseCountryInSearchIndex())) {
                String localeCodeWithoutCountry = localeCode.substring(0, underscoreLocation);
                if (processedLocales.containsKey(localeCodeWithoutCountry)) continue;
                processedLocales.put(localeCodeWithoutCountry, locale);
                continue;
            }
            processedLocales.put(locale.getLocaleCode(), locale);
        }
        return new ArrayList<Locale>(processedLocales.values());
    }

    @Override
    public SolrInputDocument buildDocument(Sku sku, List<Field> fields, List<Locale> locales) {
        SolrInputDocument document = new SolrInputDocument();
        this.attachBasicDocumentFields(sku, document);
        ArrayList<String> addedProperties = new ArrayList<String>();
        for (Field field : fields) {
            try {
                FieldType facetType;
                if (field.getSearchable().booleanValue()) {
                    List<FieldType> searchableFieldTypes = this.shs.getSearchableFieldTypes(field);
                    for (FieldType sft : searchableFieldTypes) {
                        Map<String, Object> propertyValues = this.getPropertyValues(sku, field, sft, locales);
                        for (Map.Entry<String, Object> entry : propertyValues.entrySet()) {
                            String prefix = entry.getKey();
                            prefix = StringUtils.isBlank((CharSequence)prefix) ? prefix : prefix + "_";
                            String solrPropertyName = this.shs.getPropertyNameForFieldSearchable(field, sft, prefix);
                            Object value = entry.getValue();
                            document.addField(solrPropertyName, value);
                            addedProperties.add(solrPropertyName);
                        }
                    }
                }
                if ((facetType = field.getFacetFieldType()) == null) continue;
                Map<String, Object> propertyValues = this.getPropertyValues(sku, field, facetType, locales);
                for (Map.Entry<String, Object> entry : propertyValues.entrySet()) {
                    String prefix = entry.getKey();
                    prefix = StringUtils.isBlank((CharSequence)prefix) ? prefix : prefix + "_";
                    String solrFacetPropertyName = this.shs.getPropertyNameForFieldFacet(field, prefix);
                    Object value = entry.getValue();
                    if (addedProperties.contains(solrFacetPropertyName)) continue;
                    document.addField(solrFacetPropertyName, value);
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Could not get value for property[" + field.getQualifiedFieldName() + "] for sku id[" + sku.getId() + "]"), (Throwable)e);
            }
        }
        this.attachAdditionalDocumentFields(sku, document);
        return document;
    }

    @Override
    public SolrInputDocument buildDocument(Product product, List<Field> fields, List<Locale> locales) {
        SolrInputDocument document = new SolrInputDocument();
        this.attachBasicDocumentFields(product, document);
        ArrayList<String> addedProperties = new ArrayList<String>();
        for (Field field : fields) {
            try {
                FieldType facetType;
                if (field.getSearchable().booleanValue()) {
                    List<FieldType> searchableFieldTypes = this.shs.getSearchableFieldTypes(field);
                    for (FieldType sft : searchableFieldTypes) {
                        Map<String, Object> propertyValues = this.getPropertyValues(product, field, sft, locales);
                        for (Map.Entry<String, Object> entry : propertyValues.entrySet()) {
                            String prefix = entry.getKey();
                            prefix = StringUtils.isBlank((CharSequence)prefix) ? prefix : prefix + "_";
                            String solrPropertyName = this.shs.getPropertyNameForFieldSearchable(field, sft, prefix);
                            Object value = entry.getValue();
                            document.addField(solrPropertyName, value);
                            addedProperties.add(solrPropertyName);
                        }
                    }
                }
                if ((facetType = field.getFacetFieldType()) == null) continue;
                Map<String, Object> propertyValues = this.getPropertyValues(product, field, facetType, locales);
                for (Map.Entry<String, Object> entry : propertyValues.entrySet()) {
                    String prefix = entry.getKey();
                    prefix = StringUtils.isBlank((CharSequence)prefix) ? prefix : prefix + "_";
                    String solrFacetPropertyName = this.shs.getPropertyNameForFieldFacet(field, prefix);
                    Object value = entry.getValue();
                    if (addedProperties.contains(solrFacetPropertyName)) continue;
                    document.addField(solrFacetPropertyName, value);
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Could not get value for property[" + field.getQualifiedFieldName() + "] for product id[" + product.getId() + "]"), (Throwable)e);
                throw ExceptionHelper.refineException((Throwable)e);
            }
        }
        this.attachAdditionalDocumentFields(product, document);
        return document;
    }

    protected void attachAdditionalDocumentFields(Sku sku, SolrInputDocument document) {
    }

    protected void attachAdditionalDocumentFields(Product product, SolrInputDocument document) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void attachBasicDocumentFields(Sku sku, SolrInputDocument document) {
        Boolean cacheOperationManaged = false;
        Product product = sku.getProduct();
        try {
            Tuple<CatalogStructure, Boolean> managedCache = this.getStructuredCache(product);
            CatalogStructure cache = (CatalogStructure)managedCache.getFirst();
            cacheOperationManaged = (Boolean)managedCache.getSecond();
            document.addField(this.shs.getNamespaceFieldName(), (Object)this.shs.getCurrentNamespace());
            document.addField(this.shs.getIdFieldName(), (Object)this.shs.getSolrDocumentId(document, sku));
            document.addField(this.shs.getSkuIdFieldName(), (Object)this.shs.getSkuId(sku));
            ((SolrSearchServiceExtensionHandler)this.extensionManager.getProxy()).attachAdditionalBasicFields(sku, document, this.shs);
            if (cache.getParentCategoriesByProduct().containsKey(this.shs.getProductId(product))) {
                for (Long categoryId : cache.getParentCategoriesByProduct().get(this.shs.getProductId(product))) {
                    this.buildCategoryDocument(categoryId, product, document, cache);
                }
            }
        }
        finally {
            if (!cacheOperationManaged.booleanValue()) {
                SolrIndexCachedOperation.clearCache();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void attachBasicDocumentFields(Product product, SolrInputDocument document) {
        Boolean cacheOperationManaged = false;
        try {
            Tuple<CatalogStructure, Boolean> managedCache = this.getStructuredCache(product);
            CatalogStructure cache = (CatalogStructure)managedCache.getFirst();
            cacheOperationManaged = (Boolean)managedCache.getSecond();
            document.addField(this.shs.getNamespaceFieldName(), (Object)this.shs.getCurrentNamespace());
            document.addField(this.shs.getIdFieldName(), (Object)this.shs.getSolrDocumentId(document, product));
            document.addField(this.shs.getProductIdFieldName(), (Object)this.shs.getProductId(product));
            ((SolrSearchServiceExtensionHandler)this.extensionManager.getProxy()).attachAdditionalBasicFields(product, document, this.shs);
            Long originalId = this.sandBoxHelper.getOriginalId((Object)product);
            Long l = originalId = originalId == null ? product.getId() : originalId;
            if (cache.getParentCategoriesByProduct().containsKey(originalId)) {
                for (Long categoryId : cache.getParentCategoriesByProduct().get(originalId)) {
                    this.buildCategoryDocument(categoryId, product, document, cache);
                }
            }
        }
        finally {
            if (!cacheOperationManaged.booleanValue()) {
                SolrIndexCachedOperation.clearCache();
            }
        }
    }

    protected void buildCategoryDocument(Long categoryId, Product product, SolrInputDocument document, CatalogStructure cache) {
        document.addField(this.shs.getExplicitCategoryFieldName(), (Object)this.shs.getCategoryId(categoryId));
        String categorySortFieldName = this.shs.getCategorySortFieldName(this.shs.getCategoryId(categoryId));
        Long displayOrder = this.determineDisplayOrderValue(cache, categoryId, product);
        if (document.getField(categorySortFieldName) == null) {
            document.addField(categorySortFieldName, (Object)displayOrder);
        }
        this.buildFullCategoryHierarchy(document, cache, categoryId, new HashSet<Long>());
    }

    protected Tuple<CatalogStructure, Boolean> getStructuredCache(Product product) {
        CatalogStructure cache = SolrIndexCachedOperation.getCache();
        Boolean cacheOperationManage = false;
        if (cache != null) {
            cacheOperationManage = true;
        } else {
            cache = new CatalogStructure();
            SolrIndexCachedOperation.setCache(cache);
            this.solrIndexDao.populateProductCatalogStructure(Arrays.asList(product.getId()), SolrIndexCachedOperation.getCache());
        }
        return new Tuple((Object)cache, (Object)cacheOperationManage);
    }

    protected Long determineDisplayOrderValue(CatalogStructure cache, Long categoryId, Product product) {
        String displayOrderKey = categoryId + "-" + this.shs.getProductId(product);
        BigDecimal rawDisplayOrder = cache.getDisplayOrdersByCategoryProduct().get(displayOrderKey);
        if (rawDisplayOrder == null) {
            Category category = this.categoryDao.readCategoryById(categoryId);
            List<CategoryProductXref> categoryProductXrefs = category.getAllProductXrefs();
            for (CategoryProductXref xref : categoryProductXrefs) {
                if (!product.equals(xref.getProduct())) continue;
                rawDisplayOrder = xref.getDisplayOrder();
            }
        }
        Long displayOrder = this.convertDisplayOrderToLong(rawDisplayOrder);
        return displayOrder;
    }

    protected void buildFullCategoryHierarchy(SolrInputDocument document, CatalogStructure cache, Long categoryId, Set<Long> indexedParents) {
        Long catIdToAdd = this.shs.getCategoryId(categoryId);
        Collection existingValues = document.getFieldValues(this.shs.getCategoryFieldName());
        if (existingValues == null || !existingValues.contains(catIdToAdd)) {
            document.addField(this.shs.getCategoryFieldName(), (Object)catIdToAdd);
        }
        Set<Long> parents = cache.getParentCategoriesByCategory().get(categoryId);
        for (Long parent : parents) {
            if (indexedParents.contains(parent)) continue;
            indexedParents.add(parent);
            this.buildFullCategoryHierarchy(document, cache, parent, indexedParents);
        }
    }

    protected Map<String, Object> getPropertyValues(Object indexedItem, Field field, FieldType fieldType, List<Locale> locales) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object propertyValue;
        String propertyName = field.getPropertyName();
        HashMap<String, Object> values = new HashMap<String, Object>();
        ExtensionResultStatusType extensionResult = ExtensionResultStatusType.NOT_HANDLED;
        if (this.extensionManager != null) {
            if (Product.class.isAssignableFrom(indexedItem.getClass())) {
                extensionResult = ((SolrSearchServiceExtensionHandler)this.extensionManager.getProxy()).addPropertyValues((Product)indexedItem, field, fieldType, values, propertyName, locales);
            } else if (Sku.class.isAssignableFrom(indexedItem.getClass())) {
                extensionResult = ((SolrSearchServiceExtensionHandler)this.extensionManager.getProxy()).addPropertyValues((Sku)indexedItem, field, fieldType, values, propertyName, locales);
            }
        }
        if (ExtensionResultStatusType.NOT_HANDLED.equals((Object)extensionResult) && (propertyValue = this.shs.getPropertyValue(indexedItem, field)) != null) {
            values.put("", propertyValue);
        }
        return values;
    }

    @Deprecated
    protected String convertToMappedProperty(String propertyName, String listPropertyName, String mapPropertyName) {
        String[] splitName = StringUtils.split((String)propertyName, (String)"\\.");
        StringBuilder convertedProperty = new StringBuilder();
        for (int i = 0; i < splitName.length; ++i) {
            if (convertedProperty.length() > 0) {
                convertedProperty.append(".");
            }
            if (splitName[i].equals(listPropertyName)) {
                convertedProperty.append(mapPropertyName).append("(");
                convertedProperty.append(splitName[i + 1]).append(").value");
                ++i;
                continue;
            }
            convertedProperty.append(splitName[i]);
        }
        return convertedProperty.toString();
    }

    @Override
    public Object[] saveState() {
        return new Object[]{BroadleafRequestContext.getBroadleafRequestContext(), SkuPricingConsiderationContext.getSkuPricingConsiderationContext(), SkuPricingConsiderationContext.getSkuPricingService(), SkuActiveDateConsiderationContext.getSkuActiveDatesService()};
    }

    @Override
    public void restoreState(Object[] pack) {
        BroadleafRequestContext.setBroadleafRequestContext((BroadleafRequestContext)((BroadleafRequestContext)pack[0]));
        SkuPricingConsiderationContext.setSkuPricingConsiderationContext((HashMap)pack[1]);
        SkuPricingConsiderationContext.setSkuPricingService((DynamicSkuPricingService)pack[2]);
        SkuActiveDateConsiderationContext.setSkuActiveDatesService((DynamicSkuActiveDatesService)pack[3]);
    }

    @Override
    public void optimizeIndex(SolrServer server) throws ServiceException, IOException {
        this.shs.optimizeIndex(server);
    }

    @Override
    public void commit(SolrServer server) throws ServiceException, IOException {
        if (this.commit) {
            this.commit(server, this.softCommit, this.waitSearcher, this.waitFlush);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"The flag / property \"solr.index.commit\" is false. Not committing! Ensure autoCommit is configured.");
        }
    }

    @Override
    public void commit(SolrServer server, boolean softCommit, boolean waitSearcher, boolean waitFlush) throws ServiceException, IOException {
        try {
            if (!this.commit) {
                LOG.warn((Object)"The flag / property \"solr.index.commit\" is set to false but a commit is being forced via the API.");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Committing changes to Solr index: softCommit: " + softCommit + ", waitSearcher: " + waitSearcher + ", waitFlush: " + waitFlush));
            }
            server.commit(waitFlush, waitSearcher, softCommit);
        }
        catch (SolrServerException e) {
            throw new ServiceException("Could not commit changes to Solr index", (Throwable)e);
        }
    }

    @Override
    public void logDocuments(Collection<SolrInputDocument> documents) {
        if (LOG.isTraceEnabled()) {
            for (SolrInputDocument document : documents) {
                LOG.trace((Object)document);
            }
        }
    }

    protected Long convertDisplayOrderToLong(BigDecimal displayOrder) {
        if (displayOrder != null) {
            return displayOrder.multiply(BigDecimal.valueOf(1000000L)).longValue();
        }
        return null;
    }
}

