/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.search.service.solr;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrInputDocument;
import org.broadleafcommerce.common.exception.ServiceException;
import org.broadleafcommerce.common.locale.domain.Locale;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.search.domain.Field;
import org.broadleafcommerce.core.search.domain.SearchCriteria;
import org.broadleafcommerce.core.search.domain.SearchFacet;
import org.broadleafcommerce.core.search.domain.SearchFacetDTO;
import org.broadleafcommerce.core.search.domain.SearchFacetRange;
import org.broadleafcommerce.core.search.domain.solr.FieldType;

public interface SolrHelperService {
    public void swapActiveCores() throws ServiceException;

    public String getCurrentNamespace();

    public String getGlobalFacetTagField();

    public String getPropertyNameForFieldSearchable(Field var1, FieldType var2, String var3);

    public String getPropertyNameForFieldFacet(Field var1, String var2);

    public List<FieldType> getSearchableFieldTypes(Field var1);

    public String getPropertyNameForFieldSearchable(Field var1, FieldType var2);

    public String getPropertyNameForFieldFacet(Field var1);

    public String getSolrDocumentId(SolrInputDocument var1, Product var2);

    public String getSolrDocumentId(SolrInputDocument var1, Sku var2);

    public String getNamespaceFieldName();

    public String getIdFieldName();

    public String getProductIdFieldName();

    public String getSkuIdFieldName();

    public String getCategoryFieldName();

    public String getExplicitCategoryFieldName();

    public String getCatalogFieldName();

    public String getCatalogOverridesFieldName();

    public String getSandBoxFieldName();

    public String getSandBoxPriorityFieldName();

    public String getSandBoxChangeTypeFieldName();

    public String getCategorySortFieldName(Category var1);

    public String getCategorySortFieldName(Long var1);

    public String getLocalePrefix();

    public String getDefaultLocalePrefix();

    public Locale getDefaultLocale();

    public Long getCategoryId(Category var1);

    public Long getCategoryId(Long var1);

    public Long getProductId(Product var1);

    public Long getSkuId(Sku var1);

    public Object getPropertyValue(Object var1, Field var2) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException;

    public Object getPropertyValue(Object var1, String var2) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException;

    public void optimizeIndex(SolrServer var1) throws ServiceException, IOException;

    public String scrubFacetValue(String var1);

    public String sanitizeQuery(String var1);

    public List<SearchFacetDTO> buildSearchFacetDTOs(List<SearchFacet> var1);

    public boolean isFacetAvailable(SearchFacet var1, Map<String, String[]> var2);

    public String getSolrRangeString(String var1, BigDecimal var2, BigDecimal var3);

    public String getSolrRangeFunctionString(BigDecimal var1, BigDecimal var2);

    public String getSolrFieldTag(String var1, String var2, SearchFacetRange var3);

    public void setFacetResults(Map<String, SearchFacetDTO> var1, QueryResponse var2);

    public void sortFacetResults(Map<String, SearchFacetDTO> var1);

    public void attachFacets(SolrQuery var1, Map<String, SearchFacetDTO> var2);

    public String getSolrTaggedFieldString(String var1, String var2, SearchFacetRange var3);

    public List<SolrDocument> getResponseDocuments(QueryResponse var1);

    public void attachSortClause(SolrQuery var1, SearchCriteria var2, String var3, List<Field> var4);

    public Map<String, String> getSolrFieldKeyMap(SearchCriteria var1, List<Field> var2);

    public Map<String, SearchFacetDTO> getNamedFacetMap(List<SearchFacetDTO> var1, SearchCriteria var2);

    public void attachActiveFacetFilters(SolrQuery var1, Map<String, SearchFacetDTO> var2, SearchCriteria var3);
}

