/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.search.service.solr;

import org.apache.commons.lang.StringUtils;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.impl.CloudSolrServer;

public class SolrContext {
    public static final String PRIMARY = "primary";
    public static final String REINDEX = "reindex";
    protected static SolrServer adminServer = null;
    protected static SolrServer primaryServer = null;
    protected static SolrServer reindexServer = null;

    public static void setPrimaryServer(SolrServer server) {
        if (server != null && CloudSolrServer.class.isAssignableFrom(server.getClass())) {
            CloudSolrServer cs = (CloudSolrServer)server;
            if (StringUtils.isBlank((String)cs.getDefaultCollection())) {
                cs.setDefaultCollection(PRIMARY);
            }
            if (reindexServer != null) {
                if (server == reindexServer) {
                    throw new IllegalArgumentException("The primary and reindex CloudSolrServers are the same instances. They must be different instances. Each instance must have a different defaultCollection or the defaultCollection must be unspecified and Broadleaf will set it.");
                }
                if (CloudSolrServer.class.isAssignableFrom(reindexServer.getClass()) && cs.getDefaultCollection().equals(((CloudSolrServer)reindexServer).getDefaultCollection())) {
                    throw new IllegalStateException("Primary and Reindex servers cannot have the same defaultCollection: " + cs.getDefaultCollection());
                }
            }
        }
        primaryServer = server;
    }

    public static void setReindexServer(SolrServer server) {
        if (server != null && CloudSolrServer.class.isAssignableFrom(server.getClass())) {
            CloudSolrServer cs = (CloudSolrServer)server;
            if (StringUtils.isBlank((String)cs.getDefaultCollection())) {
                cs.setDefaultCollection(REINDEX);
            }
            if (primaryServer != null) {
                if (server == primaryServer) {
                    throw new IllegalArgumentException("The primary and reindex CloudSolrServers are the same instances. They must be different instances. Each instance must have a different defaultCollection or the defaultCollection must be unspecified and Broadleaf will set it.");
                }
                if (CloudSolrServer.class.isAssignableFrom(primaryServer.getClass()) && cs.getDefaultCollection().equals(((CloudSolrServer)primaryServer).getDefaultCollection())) {
                    throw new IllegalStateException("Primary and Reindex servers cannot have the same defaultCollection: " + cs.getDefaultCollection());
                }
            }
        }
        reindexServer = server;
    }

    public static void setAdminServer(SolrServer server) {
        adminServer = server;
    }

    public static SolrServer getAdminServer() {
        if (adminServer != null) {
            return adminServer;
        }
        return SolrContext.getServer();
    }

    public static SolrServer getServer() {
        return primaryServer;
    }

    public static SolrServer getReindexServer() {
        return SolrContext.isSingleCoreMode() ? primaryServer : reindexServer;
    }

    public static boolean isSingleCoreMode() {
        return reindexServer == null;
    }

    public static boolean isSolrCloudMode() {
        return CloudSolrServer.class.isAssignableFrom(SolrContext.getServer().getClass());
    }
}

