/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.search.service.solr;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Map;
import javax.annotation.Resource;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.broadleafcommerce.common.exception.ExceptionHelper;
import org.broadleafcommerce.core.search.service.SearchService;
import org.broadleafcommerce.core.search.service.solr.IndexStatusInfo;
import org.broadleafcommerce.core.search.service.solr.SolrIndexStatusProvider;
import org.broadleafcommerce.core.search.service.solr.SolrSearchServiceImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FileSystemSolrIndexStatusProviderImpl
implements SolrIndexStatusProvider {
    @Resource(name="blSearchService")
    protected SearchService searchService;
    protected DocumentBuilder builder;
    protected XPath xPath;
    protected SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");

    public FileSystemSolrIndexStatusProviderImpl() {
        XPathFactory factory = XPathFactory.newInstance();
        this.xPath = factory.newXPath();
    }

    @Override
    public synchronized void handleUpdateIndexStatus(IndexStatusInfo status) {
        try {
            if (this.searchService instanceof SolrSearchServiceImpl) {
                Element indexElement;
                Document document;
                File statusFile = this.getStatusFile((SolrSearchServiceImpl)this.searchService);
                boolean exists = statusFile.exists();
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setIgnoringElementContentWhitespace(true);
                dbf.setNamespaceAware(true);
                if (this.builder == null) {
                    this.builder = dbf.newDocumentBuilder();
                }
                if (exists) {
                    document = this.builder.parse(statusFile);
                    NodeList temp1 = (NodeList)this.xPath.evaluate("/status/index", document, XPathConstants.NODESET);
                    indexElement = (Element)temp1.item(0);
                } else {
                    document = this.builder.newDocument();
                    Element root = document.createElement("status");
                    document.appendChild(root);
                    indexElement = document.createElement("index");
                    indexElement.setAttribute("dateProcessed", "");
                    root.appendChild(indexElement);
                }
                String dateString = this.format.format(status.getLastIndexDate());
                if (!dateString.equals(indexElement.getAttribute("dateProcessed"))) {
                    int j;
                    indexElement.setAttribute("dateProcessed", dateString);
                    Object children = (NodeList)this.xPath.evaluate("info", indexElement, XPathConstants.NODESET);
                    for (j = 0; j < children.getLength(); ++j) {
                        indexElement.removeChild(children.item(j));
                    }
                    children = indexElement.getChildNodes();
                    for (j = 0; j < children.getLength(); ++j) {
                        if (!children.item(j).getNodeName().equalsIgnoreCase("#text")) continue;
                        indexElement.removeChild(children.item(j));
                    }
                }
                for (Map.Entry<String, String> entry : status.getAdditionalInfo().entrySet()) {
                    NodeList infos = (NodeList)this.xPath.evaluate("info[@key='" + entry.getKey() + "']", indexElement, XPathConstants.NODESET);
                    if (infos.getLength() != 0) continue;
                    Element addlInfo = document.createElement("info");
                    addlInfo.setAttribute("key", entry.getKey());
                    addlInfo.setAttribute("val", entry.getValue());
                    indexElement.appendChild(addlInfo);
                }
                TransformerFactory tFactory = TransformerFactory.newInstance();
                Transformer xmlTransformer = tFactory.newTransformer();
                xmlTransformer.setOutputProperty("version", "1.0");
                xmlTransformer.setOutputProperty("encoding", "UTF-8");
                xmlTransformer.setOutputProperty("method", "xml");
                xmlTransformer.setOutputProperty("indent", "yes");
                DOMSource source = new DOMSource(document);
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(statusFile, false), "UTF-8"));
                StreamResult result = new StreamResult(writer);
                xmlTransformer.transform(source, result);
            }
        }
        catch (ParserConfigurationException e) {
            throw ExceptionHelper.refineException((Throwable)e);
        }
        catch (SAXException e) {
            throw ExceptionHelper.refineException((Throwable)e);
        }
        catch (IOException e) {
            throw ExceptionHelper.refineException((Throwable)e);
        }
        catch (XPathExpressionException e) {
            throw ExceptionHelper.refineException((Throwable)e);
        }
        catch (TransformerException e) {
            throw ExceptionHelper.refineException((Throwable)e);
        }
    }

    @Override
    public synchronized IndexStatusInfo readIndexStatus(IndexStatusInfo status) {
        try {
            File statusFile;
            boolean exists;
            if (this.searchService instanceof SolrSearchServiceImpl && (exists = (statusFile = this.getStatusFile((SolrSearchServiceImpl)this.searchService)).exists())) {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                if (this.builder == null) {
                    this.builder = dbf.newDocumentBuilder();
                }
                Document document = this.builder.parse(statusFile);
                NodeList temp1 = (NodeList)this.xPath.evaluate("/status/index", document, XPathConstants.NODESET);
                Element indexElement = (Element)temp1.item(0);
                status.setLastIndexDate(this.format.parse(indexElement.getAttribute("dateProcessed")));
                NodeList infos = (NodeList)this.xPath.evaluate("info", indexElement, XPathConstants.NODESET);
                for (int j = 0; j < infos.getLength(); ++j) {
                    Element info = (Element)infos.item(j);
                    status.getAdditionalInfo().put(info.getAttribute("key"), info.getAttribute("val"));
                }
            }
        }
        catch (ParserConfigurationException e) {
            throw ExceptionHelper.refineException((Throwable)e);
        }
        catch (SAXException e) {
            throw ExceptionHelper.refineException((Throwable)e);
        }
        catch (IOException e) {
            throw ExceptionHelper.refineException((Throwable)e);
        }
        catch (XPathExpressionException e) {
            throw ExceptionHelper.refineException((Throwable)e);
        }
        catch (ParseException e) {
            throw ExceptionHelper.refineException((Throwable)e);
        }
        return status;
    }

    protected File getStatusFile(SolrSearchServiceImpl searchService) {
        String statusDirectory = this.getStatusDirectory(searchService);
        File statusFile = new File(new File(statusDirectory), "solr_status.xml");
        return statusFile;
    }

    protected String getStatusDirectory(SolrSearchServiceImpl searchService) {
        String solrHome = searchService.getSolrHomePath();
        if (solrHome == null) {
            return System.getProperty("java.io.tmpdir");
        }
        return solrHome;
    }
}

