/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.search.redirect.dao;

import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.broadleafcommerce.common.time.SystemTime;
import org.broadleafcommerce.core.search.redirect.dao.SearchRedirectDao;
import org.broadleafcommerce.core.search.redirect.domain.SearchRedirect;
import org.springframework.stereotype.Repository;

@Repository(value="blSearchRedirectDao")
public class SearchRedirectDaoImpl
implements SearchRedirectDao {
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    protected Long currentDateResolution = 10000L;
    protected Date cachedDate = SystemTime.asDate();

    protected Date getCurrentDateAfterFactoringInDateResolution() {
        Date returnDate = SystemTime.getCurrentDateWithinTimeResolution((Date)this.cachedDate, (Long)this.currentDateResolution);
        if (returnDate != this.cachedDate && SystemTime.shouldCacheDate()) {
            this.cachedDate = returnDate;
        }
        return returnDate;
    }

    @Override
    public SearchRedirect findSearchRedirectBySearchTerm(String searchTerm) {
        Query query = this.em.createNamedQuery("BC_READ_SEARCH_URL");
        query.setParameter("searchTerm", (Object)searchTerm);
        query.setParameter("now", (Object)this.getCurrentDateAfterFactoringInDateResolution());
        query.setMaxResults(1);
        query.setHint("org.hibernate.cacheable", (Object)true);
        List results = query.getResultList();
        if (results != null && !results.isEmpty()) {
            return (SearchRedirect)results.get(0);
        }
        return null;
    }

    public Long getCurrentDateResolution() {
        return this.currentDateResolution;
    }

    public void setCurrentDateResolution(Long currentDateResolution) {
        this.currentDateResolution = currentDateResolution;
    }
}

