/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.search.domain;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.broadleafcommerce.common.copy.CreateResponse;
import org.broadleafcommerce.common.copy.MultiTenantCopyContext;
import org.broadleafcommerce.common.extensibility.jpa.copy.DirectCopyTransform;
import org.broadleafcommerce.common.extensibility.jpa.copy.DirectCopyTransformMember;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.AdminPresentationClass;
import org.broadleafcommerce.common.presentation.PopulateToOneFieldsEnum;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.CategoryImpl;
import org.broadleafcommerce.core.search.domain.CategoryExcludedSearchFacet;
import org.broadleafcommerce.core.search.domain.SearchFacet;
import org.broadleafcommerce.core.search.domain.SearchFacetImpl;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_CAT_SEARCH_FACET_EXCL_XREF")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blCategories")
@AdminPresentationClass(populateToOneFields=PopulateToOneFieldsEnum.TRUE)
@DirectCopyTransform(value={@DirectCopyTransformMember(templateTokens={"sandbox"}, skipOverlaps=true), @DirectCopyTransformMember(templateTokens={"multiTenantCatalog"})})
public class CategoryExcludedSearchFacetImpl
implements CategoryExcludedSearchFacet,
Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="CategoryExcludedSearchFacetId")
    @GenericGenerator(name="CategoryExcludedSearchFacetId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="segment_value", value="CategoryExcludedSearchFacetImpl"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.search.domain.CategoryExcludedSearchFacetImpl")})
    @Column(name="CAT_EXCL_SEARCH_FACET_ID")
    protected Long id;
    @ManyToOne(targetEntity=CategoryImpl.class, cascade={CascadeType.REFRESH})
    @JoinColumn(name="CATEGORY_ID")
    protected Category category;
    @ManyToOne(targetEntity=SearchFacetImpl.class)
    @JoinColumn(name="SEARCH_FACET_ID")
    protected SearchFacet searchFacet;
    @Column(name="SEQUENCE")
    @AdminPresentation(friendlyName="CategorySearchFacetImpl_sequence")
    protected BigDecimal sequence;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Category getCategory() {
        return this.category;
    }

    @Override
    public void setCategory(Category category) {
        this.category = category;
    }

    @Override
    public SearchFacet getSearchFacet() {
        return this.searchFacet;
    }

    @Override
    public void setSearchFacet(SearchFacet searchFacet) {
        this.searchFacet = searchFacet;
    }

    @Override
    public BigDecimal getSequence() {
        return this.sequence;
    }

    @Override
    public void setSequence(BigDecimal sequence) {
        this.sequence = sequence;
    }

    public <G extends CategoryExcludedSearchFacet> CreateResponse<G> createOrRetrieveCopyInstance(MultiTenantCopyContext context) throws CloneNotSupportedException {
        CreateResponse createResponse = context.createOrRetrieveCopyInstance((Object)this);
        if (createResponse.isAlreadyPopulated()) {
            return createResponse;
        }
        CategoryExcludedSearchFacet cloned = (CategoryExcludedSearchFacet)createResponse.getClone();
        if (this.searchFacet != null) {
            cloned.setSearchFacet((SearchFacet)this.searchFacet.createOrRetrieveCopyInstance(context).getClone());
        }
        cloned.setSequence(this.sequence);
        if (this.category != null) {
            cloned.setCategory((Category)this.category.createOrRetrieveCopyInstance(context).getClone());
        }
        return createResponse;
    }
}

