/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.rating.dao;

import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.broadleafcommerce.common.persistence.EntityConfiguration;
import org.broadleafcommerce.core.rating.dao.ReviewDetailDao;
import org.broadleafcommerce.core.rating.domain.ReviewDetail;
import org.broadleafcommerce.core.rating.domain.ReviewDetailImpl;
import org.broadleafcommerce.core.rating.domain.ReviewFeedback;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.springframework.stereotype.Repository;

@Repository(value="blReviewDetailDao")
public class ReviewDetailDaoImpl
implements ReviewDetailDao {
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;

    @Override
    public ReviewDetail readReviewDetailById(Long reviewId) {
        return (ReviewDetail)this.em.find(ReviewDetailImpl.class, (Object)reviewId);
    }

    @Override
    public ReviewDetail saveReviewDetail(ReviewDetail reviewDetail) {
        return (ReviewDetail)this.em.merge((Object)reviewDetail);
    }

    @Override
    public ReviewDetail readReviewByCustomerAndItem(Customer customer, String itemId) {
        Query query = this.em.createNamedQuery("BC_READ_REVIEW_DETAIL_BY_CUSTOMER_ID_AND_ITEM_ID");
        query.setParameter("customerId", (Object)customer.getId());
        query.setParameter("itemId", (Object)itemId);
        ReviewDetail reviewDetail = null;
        try {
            reviewDetail = (ReviewDetail)query.getSingleResult();
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
        return reviewDetail;
    }

    @Override
    public ReviewDetail create() {
        return (ReviewDetail)this.entityConfiguration.createEntityInstance(ReviewDetail.class.getName());
    }

    @Override
    public ReviewFeedback createFeedback() {
        return (ReviewFeedback)this.entityConfiguration.createEntityInstance(ReviewFeedback.class.getName());
    }
}

