/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.pricing.service.workflow;

import java.util.List;
import javax.annotation.Resource;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferCode;
import org.broadleafcommerce.core.offer.service.OfferService;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.service.OrderService;
import org.broadleafcommerce.core.workflow.BaseActivity;
import org.broadleafcommerce.core.workflow.ProcessContext;

public class OfferActivity
extends BaseActivity<ProcessContext<Order>> {
    @Resource(name="blOfferService")
    protected OfferService offerService;
    @Resource(name="blOrderService")
    protected OrderService orderService;

    @Override
    public ProcessContext<Order> execute(ProcessContext<Order> context) throws Exception {
        Order order = context.getSeedData();
        List<OfferCode> offerCodes = this.offerService.buildOfferCodeListForCustomer(order.getCustomer());
        if (offerCodes != null && !offerCodes.isEmpty()) {
            order = this.orderService.addOfferCodes(order, offerCodes, false);
        }
        List<Offer> offers = this.offerService.buildOfferListForOrder(order);
        order = this.offerService.applyAndSaveOffersToOrder(offers, order);
        context.setSeedData(order);
        return context;
    }
}

