/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.pricing.service.workflow;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.broadleafcommerce.core.catalog.domain.ProductBundle;
import org.broadleafcommerce.core.catalog.domain.SkuBundleItem;
import org.broadleafcommerce.core.catalog.service.CatalogService;
import org.broadleafcommerce.core.order.dao.FulfillmentGroupItemDao;
import org.broadleafcommerce.core.order.dao.OrderItemDao;
import org.broadleafcommerce.core.order.domain.BundleOrderItem;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupItem;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.service.OrderService;
import org.broadleafcommerce.core.order.service.exception.RemoveFromCartException;
import org.broadleafcommerce.core.order.service.type.OrderItemType;
import org.broadleafcommerce.core.pricing.service.exception.PricingException;
import org.broadleafcommerce.core.workflow.BaseActivity;
import org.broadleafcommerce.core.workflow.ProcessContext;

public class AutoBundleActivity
extends BaseActivity<ProcessContext<Order>> {
    @Resource(name="blCatalogService")
    protected CatalogService catalogService;
    @Resource(name="blOrderService")
    protected OrderService orderService;
    @Resource(name="blOrderItemDao")
    protected OrderItemDao orderItemDao;
    @Resource(name="blFulfillmentGroupItemDao")
    protected FulfillmentGroupItemDao fulfillmentGroupItemDao;

    @Override
    public ProcessContext<Order> execute(ProcessContext<Order> context) throws Exception {
        Order order = context.getSeedData();
        order = this.handleAutomaticBundling(order);
        context.setSeedData(order);
        return context;
    }

    public Order handleAutomaticBundling(Order order) throws PricingException, RemoveFromCartException {
        boolean itemsHaveBeenUnbundled = false;
        List<DiscreteOrderItem> unbundledItems = null;
        List<ProductBundle> productBundles = this.catalogService.findAutomaticProductBundles();
        HashSet<Long> processedBundleIds = new HashSet<Long>();
        for (ProductBundle productBundle : productBundles) {
            int existingUses = this.countExistingUsesOfBundle(order, productBundle);
            Integer maxApplications = null;
            for (SkuBundleItem skuBundleItem : productBundle.getSkuBundleItems()) {
                int maxSkuApplications = this.countMaximumApplications(order, skuBundleItem, processedBundleIds);
                if (maxApplications != null && maxApplications <= maxSkuApplications) continue;
                maxApplications = maxSkuApplications;
            }
            processedBundleIds.add(productBundle.getId());
            if (maxApplications == existingUses) continue;
            if (!itemsHaveBeenUnbundled) {
                unbundledItems = this.unBundleItems(order);
                order = this.removeAutomaticBundles(order);
                itemsHaveBeenUnbundled = true;
            }
            order = this.bundleItems(order, productBundle, maxApplications, unbundledItems);
        }
        return order;
    }

    private Order removeAutomaticBundles(Order order) throws PricingException {
        ArrayList<BundleOrderItem> bundlesToRemove = new ArrayList<BundleOrderItem>();
        for (OrderItem orderItem : order.getOrderItems()) {
            BundleOrderItem bundleOrderItem;
            if (!(orderItem instanceof BundleOrderItem) || (bundleOrderItem = (BundleOrderItem)orderItem).getProductBundle() == null || !bundleOrderItem.getProductBundle().getAutoBundle().booleanValue()) continue;
            bundlesToRemove.add(bundleOrderItem);
        }
        for (BundleOrderItem bundleOrderItem : bundlesToRemove) {
            try {
                order = this.orderService.removeItem(order.getId(), bundleOrderItem.getId(), false);
            }
            catch (RemoveFromCartException e) {
                throw new PricingException("Could not remove item", e);
            }
        }
        return order;
    }

    private List<DiscreteOrderItem> unBundleItems(Order order) throws PricingException {
        ArrayList<DiscreteOrderItem> unbundledItems = null;
        for (OrderItem orderItem : order.getOrderItems()) {
            BundleOrderItem bundleOrderItem;
            if (!(orderItem instanceof BundleOrderItem) || (bundleOrderItem = (BundleOrderItem)orderItem).getProductBundle() == null || !bundleOrderItem.getProductBundle().getAutoBundle().booleanValue()) continue;
            if (unbundledItems == null) {
                unbundledItems = new ArrayList<DiscreteOrderItem>();
            }
            for (DiscreteOrderItem item : bundleOrderItem.getDiscreteOrderItems()) {
                DiscreteOrderItem newOrderItem = (DiscreteOrderItem)item.clone();
                newOrderItem.setQuantity(item.getQuantity() * bundleOrderItem.getQuantity());
                newOrderItem.setSkuBundleItem(null);
                newOrderItem.setBundleOrderItem(null);
                newOrderItem.updateSaleAndRetailPrices();
                newOrderItem.setOrder(order);
                unbundledItems.add(newOrderItem);
            }
        }
        return unbundledItems;
    }

    private Order bundleItems(Order order, ProductBundle productBundle, Integer numApplications, List<DiscreteOrderItem> unbundledItems) throws PricingException, RemoveFromCartException {
        BundleOrderItem bundleOrderItem = (BundleOrderItem)this.orderItemDao.create(OrderItemType.BUNDLE);
        bundleOrderItem.setQuantity(numApplications);
        bundleOrderItem.setCategory(productBundle.getDefaultCategory());
        bundleOrderItem.setSku(productBundle.getDefaultSku());
        bundleOrderItem.setName(productBundle.getName());
        bundleOrderItem.setProductBundle(productBundle);
        bundleOrderItem.setOrder(order);
        HashMap<Long, FulfillmentGroupItem> skuIdFulfillmentGroupMap = new HashMap<Long, FulfillmentGroupItem>();
        for (FulfillmentGroup fulfillmentGroup : order.getFulfillmentGroups()) {
            for (FulfillmentGroupItem fulfillmentGroupItem : fulfillmentGroup.getFulfillmentGroupItems()) {
                if (!(fulfillmentGroupItem.getOrderItem() instanceof DiscreteOrderItem)) continue;
                DiscreteOrderItem discreteOrderItem = (DiscreteOrderItem)fulfillmentGroupItem.getOrderItem();
                skuIdFulfillmentGroupMap.put(discreteOrderItem.getSku().getId(), fulfillmentGroupItem);
            }
        }
        Iterator<Serializable> iterator = productBundle.getSkuBundleItems().iterator();
        while (iterator.hasNext()) {
            int skusRequired;
            ArrayList<DiscreteOrderItem> itemMatches = new ArrayList<DiscreteOrderItem>();
            SkuBundleItem skuBundleItem = (SkuBundleItem)iterator.next();
            int skuMatches = this.populateItemMatchesForSku(itemMatches, order, unbundledItems, skuBundleItem.getSku().getId());
            if (skuMatches < (skusRequired = skuBundleItem.getQuantity() * numApplications)) {
                throw new IllegalArgumentException("Something went wrong creating automatic bundles.  Not enough skus to fulfill bundle requirements for sku id: " + skuBundleItem.getSku().getId());
            }
            for (DiscreteOrderItem discreteOrderItem : itemMatches) {
                order = this.orderService.removeItem(order.getId(), discreteOrderItem.getId(), false);
            }
            DiscreteOrderItem baseItem = null;
            if (itemMatches.size() > 0) {
                baseItem = (DiscreteOrderItem)itemMatches.get(0);
            } else {
                for (DiscreteOrderItem discreteOrderItem : unbundledItems) {
                    if (!discreteOrderItem.getSku().getId().equals(skuBundleItem.getSku().getId())) continue;
                    baseItem = discreteOrderItem;
                }
            }
            DiscreteOrderItem discreteOrderItem = (DiscreteOrderItem)baseItem.clone();
            discreteOrderItem.setSkuBundleItem(skuBundleItem);
            discreteOrderItem.setBundleOrderItem(bundleOrderItem);
            discreteOrderItem.setQuantity(skuBundleItem.getQuantity());
            discreteOrderItem.setOrder(null);
            bundleOrderItem.getDiscreteOrderItems().add(discreteOrderItem);
            if (skuMatches <= skusRequired) continue;
            DiscreteOrderItem newOrderItem = (DiscreteOrderItem)baseItem.clone();
            newOrderItem.setBundleOrderItem(null);
            newOrderItem.setSkuBundleItem(null);
            newOrderItem.setQuantity(skuMatches - skusRequired);
            newOrderItem = (DiscreteOrderItem)this.orderItemDao.save(newOrderItem);
            newOrderItem.setOrder(order);
            newOrderItem.updateSaleAndRetailPrices();
            FulfillmentGroupItem fulfillmentGroupItem = (FulfillmentGroupItem)skuIdFulfillmentGroupMap.get(discreteOrderItem.getSku().getId());
            if (fulfillmentGroupItem != null) {
                FulfillmentGroupItem newFulfillmentGroupItem = fulfillmentGroupItem.clone();
                newFulfillmentGroupItem.setOrderItem(newOrderItem);
                newFulfillmentGroupItem.setQuantity(newOrderItem.getQuantity());
                newFulfillmentGroupItem = this.fulfillmentGroupItemDao.save(newFulfillmentGroupItem);
                for (FulfillmentGroup fg : order.getFulfillmentGroups()) {
                    if (newFulfillmentGroupItem.getFulfillmentGroup() == null || !fg.getId().equals(newFulfillmentGroupItem.getFulfillmentGroup().getId())) continue;
                    fg.addFulfillmentGroupItem(newFulfillmentGroupItem);
                }
            }
            order.getOrderItems().add(newOrderItem);
        }
        bundleOrderItem.updateSaleAndRetailPrices();
        order.getOrderItems().add(bundleOrderItem);
        order = this.orderService.save(order, false);
        for (OrderItem orderItem : order.getOrderItems()) {
            if (!(orderItem instanceof BundleOrderItem)) continue;
            BundleOrderItem bundleItem = (BundleOrderItem)orderItem;
            for (DiscreteOrderItem discreteOrderItem : bundleItem.getDiscreteOrderItems()) {
                FulfillmentGroupItem fulfillmentGroupItem = (FulfillmentGroupItem)skuIdFulfillmentGroupMap.get(discreteOrderItem.getSku().getId());
                if (fulfillmentGroupItem == null) continue;
                FulfillmentGroupItem fulfillmentGroupItem2 = fulfillmentGroupItem.clone();
                fulfillmentGroupItem2.setOrderItem(discreteOrderItem);
                fulfillmentGroupItem2.setQuantity(discreteOrderItem.getQuantity());
                for (FulfillmentGroup fg : order.getFulfillmentGroups()) {
                    if (fulfillmentGroupItem2.getFulfillmentGroup() == null || !fg.getId().equals(fulfillmentGroupItem2.getFulfillmentGroup().getId())) continue;
                    fg.addFulfillmentGroupItem(fulfillmentGroupItem2);
                }
            }
        }
        order = this.orderService.save(order, false);
        return order;
    }

    protected int countExistingUsesOfBundle(Order order, ProductBundle bundle) {
        int existingUses = 0;
        for (OrderItem orderItem : order.getOrderItems()) {
            BundleOrderItem bundleOrderItem;
            if (!(orderItem instanceof BundleOrderItem) || (bundleOrderItem = (BundleOrderItem)orderItem).getProductBundle() == null || !bundleOrderItem.getProductBundle().getId().equals(bundle.getId())) continue;
            ++existingUses;
        }
        return existingUses;
    }

    protected int populateItemMatchesForSku(List<DiscreteOrderItem> matchingItems, Order order, List<DiscreteOrderItem> unbundledItems, Long skuId) {
        int skuMatches = 0;
        for (OrderItem orderItem : order.getOrderItems()) {
            DiscreteOrderItem item;
            if (!(orderItem instanceof DiscreteOrderItem) || !skuId.equals((item = (DiscreteOrderItem)orderItem).getSku().getId())) continue;
            matchingItems.add(item);
            skuMatches += item.getQuantity();
        }
        if (unbundledItems != null) {
            for (DiscreteOrderItem discreteOrderItem : unbundledItems) {
                if (!skuId.equals(discreteOrderItem.getSku().getId())) continue;
                skuMatches += discreteOrderItem.getQuantity();
            }
        }
        return skuMatches;
    }

    protected int countMaximumApplications(Order order, SkuBundleItem skuBundleItem, Set<Long> processedBundles) {
        int skuMatches = 0;
        Long skuId = skuBundleItem.getSku().getId();
        for (OrderItem orderItem : order.getOrderItems()) {
            BundleOrderItem bundleItem;
            if (orderItem instanceof DiscreteOrderItem) {
                DiscreteOrderItem item = (DiscreteOrderItem)orderItem;
                if (!skuId.equals(item.getSku().getId())) continue;
                skuMatches += item.getQuantity();
                continue;
            }
            if (!(orderItem instanceof BundleOrderItem) || (bundleItem = (BundleOrderItem)orderItem).getProductBundle() == null || !bundleItem.getProductBundle().getAutoBundle().booleanValue() || processedBundles.contains(bundleItem.getId())) continue;
            for (DiscreteOrderItem discreteItem : bundleItem.getDiscreteOrderItems()) {
                if (!skuId.equals(discreteItem.getSku().getId())) continue;
                skuMatches += discreteItem.getQuantity() * bundleItem.getQuantity();
            }
        }
        return skuMatches / skuBundleItem.getQuantity();
    }
}

