/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.pricing.service.workflow;

import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.payment.domain.OrderPayment;
import org.broadleafcommerce.core.workflow.BaseActivity;
import org.broadleafcommerce.core.workflow.ProcessContext;

public class AdjustOrderPaymentsActivity
extends BaseActivity<ProcessContext<Order>> {
    @Override
    public ProcessContext<Order> execute(ProcessContext<Order> context) throws Exception {
        Order order = context.getSeedData();
        OrderPayment unconfirmedThirdPartyOrCreditCard = null;
        Money appliedPaymentsWithoutThirdPartyOrCC = Money.ZERO;
        for (OrderPayment payment : order.getPayments()) {
            if (!payment.isActive()) continue;
            if (!payment.isConfirmed() && payment.isFinalPayment()) {
                unconfirmedThirdPartyOrCreditCard = payment;
                continue;
            }
            if (payment.getAmount() == null) continue;
            appliedPaymentsWithoutThirdPartyOrCC = appliedPaymentsWithoutThirdPartyOrCC.add(payment.getAmount());
        }
        if (unconfirmedThirdPartyOrCreditCard != null) {
            Money difference = order.getTotal().subtract(appliedPaymentsWithoutThirdPartyOrCC);
            unconfirmedThirdPartyOrCreditCard.setAmount(difference);
        }
        context.setSeedData(order);
        return context;
    }
}

