/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.service.workflow;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.broadleafcommerce.core.order.dao.FulfillmentGroupItemDao;
import org.broadleafcommerce.core.order.domain.BundleOrderItem;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupItem;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.service.OrderItemService;
import org.broadleafcommerce.core.order.service.OrderMultishipOptionService;
import org.broadleafcommerce.core.order.service.OrderService;
import org.broadleafcommerce.core.order.service.workflow.CartOperationRequest;
import org.broadleafcommerce.core.workflow.BaseActivity;
import org.broadleafcommerce.core.workflow.ProcessContext;

public class PriceOrderIfNecessaryActivity
extends BaseActivity<ProcessContext<CartOperationRequest>> {
    @Resource(name="blOrderService")
    protected OrderService orderService;
    @Resource(name="blOrderItemService")
    protected OrderItemService orderItemService;
    @Resource(name="blFulfillmentGroupItemDao")
    protected FulfillmentGroupItemDao fgItemDao;
    @Resource(name="blOrderMultishipOptionService")
    protected OrderMultishipOptionService orderMultishipOptionService;

    @Override
    public ProcessContext<CartOperationRequest> execute(ProcessContext<CartOperationRequest> context) throws Exception {
        CartOperationRequest request = context.getSeedData();
        Order order = request.getOrder();
        if (CollectionUtils.isNotEmpty(request.getMultishipOptionsToDelete())) {
            for (Long[] pack : request.getMultishipOptionsToDelete()) {
                if (pack[1] == null) {
                    this.orderMultishipOptionService.deleteOrderItemOrderMultishipOptions(pack[0]);
                    continue;
                }
                this.orderMultishipOptionService.deleteOrderItemOrderMultishipOptions(pack[0], pack[1].intValue());
            }
        }
        if (CollectionUtils.isNotEmpty(request.getFgisToDelete())) {
            for (FulfillmentGroupItem fgi : request.getFgisToDelete()) {
                for (FulfillmentGroup fg : order.getFulfillmentGroups()) {
                    ListIterator<FulfillmentGroupItem> fgItemIter = fg.getFulfillmentGroupItems().listIterator();
                    while (fgItemIter.hasNext()) {
                        FulfillmentGroupItem fgi2 = fgItemIter.next();
                        if (fgi2 != fgi) continue;
                        fgItemIter.remove();
                        this.fgItemDao.delete(fgi2);
                    }
                }
            }
        }
        for (OrderItem oi : request.getOisToDelete()) {
            order.getOrderItems().remove(oi);
            this.orderItemService.delete(oi);
            if (oi.getParentOrderItem() == null) continue;
            OrderItem parentItem = oi.getParentOrderItem();
            parentItem.getChildOrderItems().remove(oi);
        }
        HashMap<OrderItem, List<FulfillmentGroupItem>> oiFgiMap = new HashMap<OrderItem, List<FulfillmentGroupItem>>();
        HashMap<OrderItem, OrderItem> savedOrderItems = new HashMap<OrderItem, OrderItem>();
        for (OrderItem oi : order.getOrderItems()) {
            if (oi instanceof BundleOrderItem) {
                ArrayList<Object> doisToAdd = new ArrayList<Object>();
                ListIterator<DiscreteOrderItem> li = ((BundleOrderItem)oi).getDiscreteOrderItems().listIterator();
                while (li.hasNext()) {
                    DiscreteOrderItem doi = li.next();
                    this.getOiFgiMap(order, oiFgiMap, doi);
                    DiscreteOrderItem savedDoi = (DiscreteOrderItem)this.orderItemService.saveOrderItem(doi);
                    savedOrderItems.put(doi, savedDoi);
                    li.remove();
                    doisToAdd.add(savedDoi);
                }
                ((BundleOrderItem)oi).getDiscreteOrderItems().addAll(doisToAdd);
                BundleOrderItem savedBoi = (BundleOrderItem)this.orderItemService.saveOrderItem(oi);
                savedOrderItems.put(oi, savedBoi);
                for (DiscreteOrderItem doi : savedBoi.getDiscreteOrderItems()) {
                    doi.setBundleOrderItem(savedBoi);
                }
                continue;
            }
            this.getOiFgiMap(order, oiFgiMap, oi);
            savedOrderItems.put(oi, this.orderItemService.saveOrderItem(oi));
        }
        ListIterator<OrderItem> li = order.getOrderItems().listIterator();
        ArrayList<OrderItem> oisToAdd = new ArrayList<OrderItem>();
        while (li.hasNext()) {
            OrderItem oi = li.next();
            OrderItem savedOi = (OrderItem)savedOrderItems.get(oi);
            oisToAdd.add(savedOi);
            li.remove();
        }
        order.getOrderItems().addAll(oisToAdd);
        for (Map.Entry entry : oiFgiMap.entrySet()) {
            for (FulfillmentGroupItem fgi : (List)entry.getValue()) {
                fgi.setOrderItem((OrderItem)savedOrderItems.get(entry.getKey()));
            }
            if (entry.getKey() != request.getOrderItem()) continue;
            request.setOrderItem((OrderItem)savedOrderItems.get(entry.getKey()));
        }
        this.updateChildOrderItem(request, order);
        this.preSaveOperation(request);
        order = this.orderService.save(order, request.isPriceOrder());
        request.setOrder(order);
        return context;
    }

    protected void updateChildOrderItem(CartOperationRequest request, Order order) {
        boolean updated = false;
        for (OrderItem oi : order.getOrderItems()) {
            if (oi instanceof BundleOrderItem) {
                BundleOrderItem boi = (BundleOrderItem)oi;
                updated = this.checkAndUpdateChildren(request, boi);
                if (!updated) {
                    for (OrderItem orderItem : boi.getDiscreteOrderItems()) {
                        if (!this.checkAndUpdateChildren(request, orderItem)) continue;
                        updated = true;
                        break;
                    }
                }
            } else {
                updated = this.checkAndUpdateChildren(request, oi);
            }
            if (!updated) continue;
            break;
        }
    }

    protected boolean checkAndUpdateChildren(CartOperationRequest request, OrderItem orderItem) {
        boolean parentUpdated;
        block2: {
            OrderItem childOrderItem;
            block1: {
                parentUpdated = false;
                if (!orderItem.getId().equals(request.getItemRequest().getParentOrderItemId())) break block1;
                orderItem.getChildOrderItems().add(request.getOrderItem());
                parentUpdated = true;
                break block2;
            }
            if (!CollectionUtils.isNotEmpty(orderItem.getChildOrderItems())) break block2;
            Iterator<OrderItem> iterator = orderItem.getChildOrderItems().iterator();
            while (iterator.hasNext() && !(parentUpdated = this.checkAndUpdateChildren(request, childOrderItem = iterator.next()))) {
            }
        }
        return parentUpdated;
    }

    protected void getOiFgiMap(Order order, Map<OrderItem, List<FulfillmentGroupItem>> oiFgiMap, OrderItem oi) {
        ArrayList<FulfillmentGroupItem> fgis = new ArrayList<FulfillmentGroupItem>();
        for (FulfillmentGroup fg : order.getFulfillmentGroups()) {
            for (FulfillmentGroupItem fgi : fg.getFulfillmentGroupItems()) {
                if (!fgi.getOrderItem().equals(oi)) continue;
                fgis.add(fgi);
            }
        }
        oiFgiMap.put(oi, fgis);
    }

    protected void preSaveOperation(CartOperationRequest request) {
    }
}

