/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.service;

import org.broadleafcommerce.common.extension.ExtensionHandler;
import org.broadleafcommerce.common.extension.ExtensionManager;
import org.broadleafcommerce.common.extension.ExtensionManagerOperation;
import org.broadleafcommerce.common.extension.ExtensionResultHolder;
import org.broadleafcommerce.common.extension.ExtensionResultStatusType;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.service.OrderServiceExtensionHandler;
import org.broadleafcommerce.core.order.service.call.OrderItemRequestDTO;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.springframework.stereotype.Service;

@Service(value="blOrderServiceExtensionManager")
public class OrderServiceExtensionManager
extends ExtensionManager<OrderServiceExtensionHandler>
implements OrderServiceExtensionHandler {
    public static final ExtensionManagerOperation attachAdditionalDataToNewNamedCart = new ExtensionManagerOperation(){

        public ExtensionResultStatusType execute(ExtensionHandler handler, Object ... params) {
            return ((OrderServiceExtensionHandler)handler).attachAdditionalDataToNewNamedCart((Customer)params[0], (Order)params[1]);
        }
    };
    public static final ExtensionManagerOperation preValidateCartOperation = new ExtensionManagerOperation(){

        public ExtensionResultStatusType execute(ExtensionHandler handler, Object ... params) {
            return ((OrderServiceExtensionHandler)handler).preValidateCartOperation((Order)params[0], (ExtensionResultHolder)params[1]);
        }
    };
    public static final ExtensionManagerOperation preValidateUpdateQuantityOperation = new ExtensionManagerOperation(){

        public ExtensionResultStatusType execute(ExtensionHandler handler, Object ... params) {
            return ((OrderServiceExtensionHandler)handler).preValidateUpdateQuantityOperation((Order)params[0], (OrderItemRequestDTO)params[1], (ExtensionResultHolder)params[2]);
        }
    };
    public static final ExtensionManagerOperation attachAdditionalDataToOrder = new ExtensionManagerOperation(){

        public ExtensionResultStatusType execute(ExtensionHandler handler, Object ... params) {
            return ((OrderServiceExtensionHandler)handler).attachAdditionalDataToOrder((Order)params[0], (Boolean)params[1]);
        }
    };
    public static final ExtensionManagerOperation findStaleCacheAwareCartForCustomer = new ExtensionManagerOperation(){

        public ExtensionResultStatusType execute(ExtensionHandler handler, Object ... params) {
            return ((OrderServiceExtensionHandler)handler).findCartForCustomerWithEnhancements((Customer)params[0], (ExtensionResultHolder)params[1]);
        }
    };
    public static final ExtensionManagerOperation findStaleCacheAwareCartForCustomer2 = new ExtensionManagerOperation(){

        public ExtensionResultStatusType execute(ExtensionHandler handler, Object ... params) {
            return ((OrderServiceExtensionHandler)handler).findCartForCustomerWithEnhancements((Customer)params[0], (Order)params[1], (ExtensionResultHolder)params[2]);
        }
    };

    public OrderServiceExtensionManager() {
        super(OrderServiceExtensionHandler.class);
    }

    public boolean continueOnHandled() {
        return true;
    }

    @Override
    public ExtensionResultStatusType attachAdditionalDataToNewNamedCart(Customer customer, Order cart) {
        return this.execute(attachAdditionalDataToNewNamedCart, new Object[]{customer, cart});
    }

    @Override
    public ExtensionResultStatusType preValidateCartOperation(Order cart, ExtensionResultHolder erh) {
        return this.execute(preValidateCartOperation, new Object[]{cart, erh});
    }

    @Override
    public ExtensionResultStatusType preValidateUpdateQuantityOperation(Order cart, OrderItemRequestDTO dto, ExtensionResultHolder erh) {
        return this.execute(preValidateUpdateQuantityOperation, new Object[]{cart, dto, erh});
    }

    @Override
    public ExtensionResultStatusType attachAdditionalDataToOrder(Order order, boolean priceOrder) {
        return this.execute(attachAdditionalDataToOrder, new Object[]{order, priceOrder});
    }

    @Override
    public ExtensionResultStatusType findCartForCustomerWithEnhancements(Customer customer, ExtensionResultHolder erh) {
        return this.execute(findStaleCacheAwareCartForCustomer, new Object[]{customer, erh});
    }

    @Override
    public ExtensionResultStatusType findCartForCustomerWithEnhancements(Customer customer, Order candidateCart, ExtensionResultHolder erh) {
        return this.execute(findStaleCacheAwareCartForCustomer2, new Object[]{customer, candidateCart, erh});
    }

    public boolean isEnabled() {
        return true;
    }
}

