/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.domain;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Lob;
import javax.persistence.Table;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.broadleafcommerce.common.copy.CreateResponse;
import org.broadleafcommerce.common.copy.MultiTenantCopyContext;
import org.broadleafcommerce.common.extensibility.jpa.copy.DirectCopyTransform;
import org.broadleafcommerce.common.extensibility.jpa.copy.DirectCopyTransformMember;
import org.broadleafcommerce.common.i18n.service.DynamicTranslationProvider;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.AdminPresentationClass;
import org.broadleafcommerce.common.presentation.override.AdminPresentationMergeEntry;
import org.broadleafcommerce.common.presentation.override.AdminPresentationMergeOverride;
import org.broadleafcommerce.common.presentation.override.AdminPresentationMergeOverrides;
import org.broadleafcommerce.core.order.domain.FulfillmentOption;
import org.broadleafcommerce.core.order.service.type.FulfillmentType;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_FULFILLMENT_OPTION")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blOrderElements")
@AdminPresentationMergeOverrides(value={@AdminPresentationMergeOverride(name="", mergeEntries={@AdminPresentationMergeEntry(propertyType="readOnly", booleanOverrideValue=true)})})
@AdminPresentationClass(friendlyName="Base Fulfillment Option")
@DirectCopyTransform(value={@DirectCopyTransformMember(templateTokens={"sandbox"}, skipOverlaps=true), @DirectCopyTransformMember(templateTokens={"multiTenantSite"})})
public class FulfillmentOptionImpl
implements FulfillmentOption {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="FulfillmentOptionId")
    @GenericGenerator(name="FulfillmentOptionId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="segment_value", value="FulfillmentOptionImpl"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.order.domain.FulfillmentOptionImpl")})
    @Column(name="FULFILLMENT_OPTION_ID")
    protected Long id;
    @Column(name="NAME")
    @AdminPresentation(friendlyName="FulfillmentOptionImpl_name", order=1000, prominent=true, gridOrder=1000, translatable=true)
    protected String name;
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    @Column(name="LONG_DESCRIPTION", length=0x7FFFFFFE)
    @AdminPresentation(friendlyName="FulfillmentOptionImpl_longDescription", order=2000, translatable=true)
    protected String longDescription;
    @Column(name="USE_FLAT_RATES")
    @AdminPresentation(friendlyName="FulfillmentOptionImpl_useFlatRates", order=9000)
    protected Boolean useFlatRates = true;
    @Column(name="FULFILLMENT_TYPE", nullable=false)
    protected String fulfillmentType;
    @Column(name="TAX_CODE", nullable=true)
    protected String taxCode;
    @Column(name="TAXABLE")
    protected Boolean taxable = false;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return DynamicTranslationProvider.getValue((Object)this, (String)"name", (String)this.name);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getLongDescription() {
        return DynamicTranslationProvider.getValue((Object)this, (String)"longDescription", (String)this.longDescription);
    }

    @Override
    public void setLongDescription(String longDescription) {
        this.longDescription = longDescription;
    }

    @Override
    public Boolean getUseFlatRates() {
        return this.useFlatRates;
    }

    @Override
    public void setUseFlatRates(Boolean useFlatRates) {
        this.useFlatRates = useFlatRates;
    }

    @Override
    public FulfillmentType getFulfillmentType() {
        return FulfillmentType.getInstance(this.fulfillmentType);
    }

    @Override
    public void setFulfillmentType(FulfillmentType fulfillmentType) {
        this.fulfillmentType = fulfillmentType == null ? null : fulfillmentType.getType();
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    @Override
    public Boolean getTaxable() {
        return this.taxable;
    }

    @Override
    public void setTaxable(Boolean taxable) {
        this.taxable = taxable;
    }

    @Override
    public void setTaxCode(String taxCode) {
        this.taxCode = taxCode;
    }

    @Override
    public String getTaxCode() {
        return this.taxCode;
    }

    public <G extends FulfillmentOption> CreateResponse<G> createOrRetrieveCopyInstance(MultiTenantCopyContext context) throws CloneNotSupportedException {
        CreateResponse createResponse = context.createOrRetrieveCopyInstance((Object)this);
        if (createResponse.isAlreadyPopulated()) {
            return createResponse;
        }
        FulfillmentOption cloned = (FulfillmentOption)createResponse.getClone();
        cloned.setFulfillmentType(this.getFulfillmentType());
        cloned.setName(this.name);
        cloned.setTaxCode(this.taxCode);
        cloned.setUseFlatRates(this.useFlatRates);
        cloned.setTaxable(this.taxable);
        cloned.setLongDescription(this.longDescription);
        return createResponse;
    }

    public static class Presentation {

        public static class FieldOrder {
            public static final int NAME = 1000;
            public static final int DESCRIPTION = 2000;
            public static final int FLATRATES = 9000;
        }

        public static class Group {

            public static class Order {
            }

            public static class Name {
            }
        }
    }
}

