/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.dao;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.UUID;
import javax.annotation.Resource;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.locale.domain.Locale;
import org.broadleafcommerce.common.persistence.EntityConfiguration;
import org.broadleafcommerce.common.util.BLCSystemProperty;
import org.broadleafcommerce.common.util.StreamCapableTransactionalOperation;
import org.broadleafcommerce.common.util.StreamCapableTransactionalOperationAdapter;
import org.broadleafcommerce.common.util.StreamingTransactionCapableUtil;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.broadleafcommerce.core.order.dao.OrderDao;
import org.broadleafcommerce.core.order.dao.OrderDaoExtensionHandler;
import org.broadleafcommerce.core.order.dao.OrderDaoExtensionManager;
import org.broadleafcommerce.core.order.domain.NullOrderImpl;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderImpl;
import org.broadleafcommerce.core.order.domain.OrderLock;
import org.broadleafcommerce.core.order.service.type.OrderStatus;
import org.broadleafcommerce.core.payment.domain.OrderPayment;
import org.broadleafcommerce.core.payment.domain.PaymentTransaction;
import org.broadleafcommerce.profile.core.dao.CustomerDao;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="blOrderDao")
public class OrderDaoImpl
implements OrderDao {
    private static final Log LOG = LogFactory.getLog(OrderDaoImpl.class);
    private static final String ORDER_LOCK_KEY = UUID.randomUUID().toString();
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;
    @Resource(name="blCustomerDao")
    protected CustomerDao customerDao;
    @Resource(name="blOrderDaoExtensionManager")
    protected OrderDaoExtensionManager extensionManager;
    @Resource(name="blStreamingTransactionCapableUtil")
    protected StreamingTransactionCapableUtil transUtil;

    @Override
    public Order readOrderById(Long orderId) {
        return (Order)this.em.find(OrderImpl.class, (Object)orderId);
    }

    @Override
    public Order readOrderById(Long orderId, boolean refresh) {
        Order order = this.readOrderById(orderId);
        if (refresh) {
            this.em.refresh((Object)order);
        }
        return order;
    }

    @Override
    public List<Order> readOrdersByIds(List<Long> orderIds) {
        if (orderIds == null || orderIds.size() == 0) {
            return null;
        }
        if (orderIds.size() > 100) {
            LOG.warn((Object)("Not recommended to use the readOrdersByIds method for long lists of orderIds, since Hibernate is required to transform the distinct results. The list of requestedorder ids was (" + orderIds.size() + ") in length."));
        }
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(Order.class);
        Root order = criteria.from(OrderImpl.class);
        criteria.select((Selection)order);
        criteria.where((Expression)order.get("id").as(Long.class).in(orderIds));
        TypedQuery query = this.em.createQuery(criteria);
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)"query.Order");
        return query.getResultList();
    }

    @Override
    public List<Order> readBatchOrders(int start, int pageSize, List<OrderStatus> statuses) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(Order.class);
        Root order = criteria.from(OrderImpl.class);
        criteria.select((Selection)order);
        if (CollectionUtils.isNotEmpty(statuses)) {
            ArrayList<String> statusStrings = new ArrayList<String>();
            for (OrderStatus status : statuses) {
                statusStrings.add(status.getType());
            }
            criteria.where((Expression)order.get("status").as(String.class).in(statusStrings));
        }
        TypedQuery query = this.em.createQuery(criteria);
        query.setFirstResult(start);
        query.setMaxResults(pageSize);
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)"query.Order");
        return query.getResultList();
    }

    @Override
    public Order save(Order order) {
        Order response = (Order)this.em.merge((Object)order);
        return response;
    }

    @Override
    public void delete(Order salesOrder) {
        if (!this.em.contains((Object)salesOrder)) {
            salesOrder = this.readOrderById(salesOrder.getId());
        }
        for (OrderPayment payment : salesOrder.getPayments()) {
            payment.setOrder(null);
            payment.setArchived(Character.valueOf('Y'));
            for (PaymentTransaction transaction : payment.getTransactions()) {
                transaction.setArchived(Character.valueOf('Y'));
            }
        }
        this.em.remove((Object)salesOrder);
    }

    @Override
    public List<Order> readOrdersForCustomer(Customer customer, OrderStatus orderStatus) {
        if (orderStatus == null) {
            return this.readOrdersForCustomer(customer.getId());
        }
        Query query = this.em.createNamedQuery("BC_READ_ORDERS_BY_CUSTOMER_ID_AND_STATUS");
        query.setParameter("customerId", (Object)customer.getId());
        query.setParameter("orderStatus", (Object)orderStatus.getType());
        return query.getResultList();
    }

    @Override
    public List<Order> readOrdersForCustomer(Long customerId) {
        Query query = this.em.createNamedQuery("BC_READ_ORDERS_BY_CUSTOMER_ID");
        query.setParameter("customerId", (Object)customerId);
        return query.getResultList();
    }

    @Override
    public Order readCartForCustomer(Customer customer) {
        Order order = null;
        Query query = this.em.createNamedQuery("BC_READ_ORDERS_BY_CUSTOMER_ID_AND_NAME_NULL");
        query.setParameter("customerId", (Object)customer.getId());
        query.setParameter("orderStatus", (Object)OrderStatus.IN_PROCESS.getType());
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)"query.Order");
        List temp = query.getResultList();
        if (temp != null && !temp.isEmpty()) {
            order = (Order)temp.get(0);
        }
        return order;
    }

    @Override
    public Order createNewCartForCustomer(Customer customer) {
        Order order = this.create();
        if (customer.getUsername() == null) {
            customer.setUsername(String.valueOf(customer.getId()));
            if (this.customerDao.readCustomerById(customer.getId()) != null) {
                throw new IllegalArgumentException("Attempting to save a customer with an id (" + customer.getId() + ") " + "that already exists in the database. This can occur when legacy customers have been migrated to " + "Broadleaf customers, but the batchStart setting has not been declared for id generation. In " + "such a case, the defaultBatchStart property of IdGenerationDaoImpl (spring id of " + "blIdGenerationDao) should be set to the appropriate start value.");
            }
            customer = this.customerDao.save(customer);
        }
        order.setCustomer(customer);
        order.setEmailAddress(customer.getEmailAddress());
        order.setStatus(OrderStatus.IN_PROCESS);
        if (BroadleafRequestContext.getBroadleafRequestContext() != null) {
            order.setCurrency(BroadleafRequestContext.getBroadleafRequestContext().getBroadleafCurrency());
            order.setLocale(BroadleafRequestContext.getBroadleafRequestContext().getLocale());
        }
        if (this.extensionManager != null) {
            ((OrderDaoExtensionHandler)this.extensionManager.getProxy()).attachAdditionalDataToNewCart(customer, order);
        }
        order = this.save(order);
        if (this.extensionManager != null) {
            ((OrderDaoExtensionHandler)this.extensionManager.getProxy()).processPostSaveNewCart(customer, order);
        }
        return order;
    }

    @Override
    public Order submitOrder(Order cartOrder) {
        cartOrder.setStatus(OrderStatus.SUBMITTED);
        return this.save(cartOrder);
    }

    @Override
    public Order create() {
        Order order = (Order)this.entityConfiguration.createEntityInstance("org.broadleafcommerce.core.order.domain.Order");
        return order;
    }

    @Override
    public void refresh(Order order) {
        if (order != null && !(order instanceof NullOrderImpl)) {
            this.em.refresh((Object)order);
        }
    }

    @Override
    public Order readNamedOrderForCustomer(Customer customer, String name) {
        Query query = this.em.createNamedQuery("BC_READ_NAMED_ORDER_FOR_CUSTOMER");
        query.setParameter("customerId", (Object)customer.getId());
        query.setParameter("orderStatus", (Object)OrderStatus.NAMED.getType());
        query.setParameter("orderName", (Object)name);
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)"query.Order");
        List orders = query.getResultList();
        if (BroadleafRequestContext.getBroadleafRequestContext() != null) {
            ListIterator iter = orders.listIterator();
            while (iter.hasNext()) {
                Locale locale = BroadleafRequestContext.getBroadleafRequestContext().getLocale();
                Order order = (Order)iter.next();
                if (locale == null || locale.equals(order.getLocale())) continue;
                iter.remove();
            }
        }
        if (orders != null && !orders.isEmpty() && this.extensionManager != null) {
            ((OrderDaoExtensionHandler)this.extensionManager.getProxy()).applyAdditionalOrderLookupFilter(customer, name, orders);
        }
        return orders == null || orders.isEmpty() ? null : (Order)orders.get(0);
    }

    @Override
    public Order readOrderByOrderNumber(String orderNumber) {
        if (orderNumber == null || "".equals(orderNumber)) {
            return null;
        }
        Query query = this.em.createNamedQuery("BC_READ_ORDER_BY_ORDER_NUMBER");
        query.setParameter("orderNumber", (Object)orderNumber);
        List orders = query.getResultList();
        return orders == null || orders.isEmpty() ? null : (Order)orders.get(0);
    }

    @Override
    @Transactional(value="blTransactionManager")
    public Order updatePrices(Order order) {
        if ((order = (Order)this.em.merge((Object)order)).updatePrices()) {
            order = this.save(order);
        }
        return order;
    }

    @Override
    public boolean acquireLock(Order order) {
        String orderLockKey = this.getOrderLockKey();
        Query q = this.em.createNamedQuery("BC_ORDER_LOCK_READ");
        q.setParameter("orderId", (Object)order.getId());
        q.setParameter("key", (Object)orderLockKey);
        q.setHint("org.hibernate.cacheable", (Object)false);
        Long count = (Long)q.getSingleResult();
        if (count == 0L) {
            try {
                OrderLock ol = (OrderLock)this.entityConfiguration.createEntityInstance(OrderLock.class.getName());
                ol.setOrderId(order.getId());
                ol.setLocked(true);
                ol.setKey(orderLockKey);
                ol.setLastUpdated(System.currentTimeMillis());
                this.em.persist((Object)ol);
                return true;
            }
            catch (EntityExistsException e) {
                return false;
            }
        }
        q = this.em.createNamedQuery("BC_ORDER_LOCK_ACQUIRE");
        q.setParameter("orderId", (Object)order.getId());
        q.setParameter("currentTime", (Object)System.currentTimeMillis());
        q.setParameter("key", (Object)orderLockKey);
        Long orderLockTimeToLive = this.getDatabaseOrderLockTimeToLive();
        q.setParameter("timeout", (Object)(orderLockTimeToLive == -1L ? orderLockTimeToLive : System.currentTimeMillis() - orderLockTimeToLive));
        q.setHint("org.hibernate.cacheable", (Object)false);
        int rowsAffected = q.executeUpdate();
        return rowsAffected == 1;
    }

    @Override
    public boolean releaseLock(final Order order) {
        final boolean[] response = new boolean[]{false};
        try {
            this.transUtil.runTransactionalOperation((StreamCapableTransactionalOperation)new StreamCapableTransactionalOperationAdapter(){

                public void execute() throws Throwable {
                    Query q = OrderDaoImpl.this.em.createNamedQuery("BC_ORDER_LOCK_RELEASE");
                    q.setParameter("orderId", (Object)order.getId());
                    q.setParameter("key", (Object)OrderDaoImpl.this.getOrderLockKey());
                    q.setHint("org.hibernate.cacheable", (Object)false);
                    int rowsAffected = q.executeUpdate();
                    response[0] = rowsAffected == 1;
                }

                public boolean shouldRetryOnTransactionLockAcquisitionFailure() {
                    return true;
                }
            }, RuntimeException.class);
        }
        catch (RuntimeException e) {
            LOG.error((Object)String.format("Could not release order lock (%s)", order.getId()), (Throwable)e);
        }
        return response[0];
    }

    protected String getOrderLockKey() {
        return this.getDatabaseOrderLockSessionAffinity() != false ? ORDER_LOCK_KEY : "NO_KEY";
    }

    protected Boolean getDatabaseOrderLockSessionAffinity() {
        return BLCSystemProperty.resolveBooleanSystemProperty((String)"order.lock.database.session.affinity", (boolean)true);
    }

    protected Long getDatabaseOrderLockTimeToLive() {
        return BLCSystemProperty.resolveLongSystemProperty((String)"order.lock.database.time.to.live", (long)-1L);
    }
}

