/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.dao;

import java.util.List;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.broadleafcommerce.common.persistence.EntityConfiguration;
import org.broadleafcommerce.core.order.dao.FulfillmentGroupDao;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupFee;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupImpl;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.service.type.FulfillmentGroupStatusType;
import org.springframework.stereotype.Repository;

@Repository(value="blFulfillmentGroupDao")
public class FulfillmentGroupDaoImpl
implements FulfillmentGroupDao {
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;

    @Override
    public FulfillmentGroup save(FulfillmentGroup fulfillmentGroup) {
        return (FulfillmentGroup)this.em.merge((Object)fulfillmentGroup);
    }

    @Override
    public FulfillmentGroup readFulfillmentGroupById(Long fulfillmentGroupId) {
        return (FulfillmentGroup)this.em.find(FulfillmentGroupImpl.class, (Object)fulfillmentGroupId);
    }

    @Override
    public FulfillmentGroupImpl readDefaultFulfillmentGroupForOrder(Order order) {
        Query query = this.em.createNamedQuery("BC_READ_DEFAULT_FULFILLMENT_GROUP_BY_ORDER_ID");
        query.setParameter("orderId", (Object)order.getId());
        List fulfillmentGroups = query.getResultList();
        return fulfillmentGroups == null || fulfillmentGroups.isEmpty() ? null : (FulfillmentGroupImpl)fulfillmentGroups.get(0);
    }

    @Override
    public void delete(FulfillmentGroup fulfillmentGroup) {
        if (!this.em.contains((Object)fulfillmentGroup)) {
            fulfillmentGroup = this.readFulfillmentGroupById(fulfillmentGroup.getId());
        }
        this.em.remove((Object)fulfillmentGroup);
    }

    @Override
    public FulfillmentGroup createDefault() {
        FulfillmentGroup fg = (FulfillmentGroup)this.entityConfiguration.createEntityInstance("org.broadleafcommerce.core.order.domain.FulfillmentGroup");
        fg.setPrimary(true);
        return fg;
    }

    @Override
    public FulfillmentGroup create() {
        FulfillmentGroup fg = (FulfillmentGroup)this.entityConfiguration.createEntityInstance("org.broadleafcommerce.core.order.domain.FulfillmentGroup");
        return fg;
    }

    @Override
    public FulfillmentGroupFee createFulfillmentGroupFee() {
        return (FulfillmentGroupFee)this.entityConfiguration.createEntityInstance("org.broadleafcommerce.core.order.domain.FulfillmentGroupFee");
    }

    @Override
    public List<FulfillmentGroup> readUnfulfilledFulfillmentGroups(int start, int maxResults) {
        Query query = this.em.createNamedQuery("BC_READ_UNFULFILLED_FULFILLMENT_GROUP_ASC");
        query.setFirstResult(start);
        query.setMaxResults(maxResults);
        return query.getResultList();
    }

    @Override
    public List<FulfillmentGroup> readPartiallyFulfilledFulfillmentGroups(int start, int maxResults) {
        Query query = this.em.createNamedQuery("BC_READ_PARTIALLY_FULFILLED_FULFILLMENT_GROUP_ASC");
        query.setFirstResult(start);
        query.setMaxResults(maxResults);
        return query.getResultList();
    }

    @Override
    public List<FulfillmentGroup> readUnprocessedFulfillmentGroups(int start, int maxResults) {
        Query query = this.em.createNamedQuery("BC_READ_UNPROCESSED_FULFILLMENT_GROUP_ASC");
        query.setFirstResult(start);
        query.setMaxResults(maxResults);
        return query.getResultList();
    }

    @Override
    public List<FulfillmentGroup> readFulfillmentGroupsByStatus(FulfillmentGroupStatusType status, int start, int maxResults, boolean ascending) {
        Query query = null;
        query = ascending ? this.em.createNamedQuery("BC_READ_FULFILLMENT_GROUP_BY_STATUS_ASC") : this.em.createNamedQuery("BC_READ_FULFILLMENT_GROUP_BY_STATUS_DESC");
        query.setParameter("status", (Object)status.getType());
        query.setFirstResult(start);
        query.setMaxResults(maxResults);
        return query.getResultList();
    }

    @Override
    public List<FulfillmentGroup> readFulfillmentGroupsByStatus(FulfillmentGroupStatusType status, int start, int maxResults) {
        return this.readFulfillmentGroupsByStatus(status, start, maxResults, true);
    }

    @Override
    public Integer readNextFulfillmentGroupSequnceForOrder(Order order) {
        Query query = this.em.createNamedQuery("BC_READ_MAX_FULFILLMENT_GROUP_SEQUENCE");
        query.setParameter("orderId", (Object)order.getId());
        List max = query.getResultList();
        if (max != null && !max.isEmpty()) {
            Integer maxNumber = (Integer)max.get(0);
            if (maxNumber == null) {
                return 1;
            }
            return maxNumber + 1;
        }
        return 1;
    }
}

